#ifndef RENDERINGSURFACE_H
#define RENDERINGSURFACE_H

#include <QtOpenGL>

/**
* @class RenderingSurface defines the surface where to render. Is derived from QGLWidget which provides the link to OpenGL
*/
class RenderingSurface : public QGLWidget
{
	Q_OBJECT

 public:
	RenderingSurface(const QGLFormat& format, QWidget* parent=0, const QGLWidget* shareWidget = 0, Qt::WindowFlags f=0);
	virtual ~RenderingSurface();

 signals:
	//! @brief this signal is emitted when the initialization of OpenGL has finished.
	void initGLFinished();

 public slots:
	//! @brief this slot allowes to update the Renderer and Animation by calling it in a tight loop or by a timer
	void processTimer();
	//! @brief this slot allowes to trigger a screenShot
	void screenShot();

 private:
	//! @brief the rendering-loop timer: calls the slot processTimer
	QTimer* animationTimer;

	//! @brief is called automatically for initializing OpenGL
	void initializeGL();
	//! @brief is called automatically when the OpenGL is resized
	void resizeGL(int w, int h);
	//! @brief is called automatically when OpenGL wants to be painted
	void paintGL();

};

#endif
