#include "RenderingSurface.h"

#include "../FlowVis.h"

#include <vector>
#include <iostream>

using namespace std;

RenderingSurface::RenderingSurface(const QGLFormat& format, QWidget* parent, const QGLWidget* shareWidget, Qt::WindowFlags f)
	:  QGLWidget(format, parent, shareWidget, f)
{
	this->setObjectName("RenderingSurface");

	this->setFixedSize(1024, 768);

	// create a new timer
	this->animationTimer = new QTimer(this);
	// the timer should call processTimer as fast and as many times as possible
	connect(this->animationTimer, SIGNAL(timeout()), this, SLOT(processTimer()));
}

RenderingSurface::~RenderingSurface()
{
	delete this->animationTimer;
}

void RenderingSurface::screenShot()
{
	// do a screenshot
	QImage image = this->grabFrameBuffer();
	image.save("screenshot01.jpg", "JPG");
}

void RenderingSurface::initializeGL()
{
	// initialize the Renderer
	FlowVis::getRenderer().initGL();

	// tell listeners that OpenGL and Renderer have finished initialization
	emit this->initGLFinished();

	// start rendering-loop
	this->animationTimer->start(0);
}

void RenderingSurface::resizeGL(int w, int h)
{
	// delegate resize to Renderer
	FlowVis::getRenderer().resizeGL(w, h);
}

void RenderingSurface::paintGL()
{
	// delegate rendering-call to Renderer
	FlowVis::getRenderer().paintGL();
	// swap the buffers
	this->swapBuffers();
}

void RenderingSurface::processTimer()
{
	// do animation
	FlowVis::getRenderer().animate();
	// call updateGL which will result in a call to paintGL
	this->updateGL();
}
