#include "MainWindow.h"

MainWindow::MainWindow(QWidget* parent)
	: QWidget(parent)
{
	this->setObjectName("MainWindow");

	this->controls = new Controls(this);
	this->controls->show();

	QGLFormat format;
	format.setDoubleBuffer(true);
	this->renderingSurface = new RenderingSurface(format, this);
	this->renderingSurface->move(this->controls->width(), 0);

	// connect screenShot-Button-pressed of control-window with screenShot-method of renderingsurface
	connect(this->controls, SIGNAL(screenShotPressed()), this->renderingSurface, SLOT(screenShot()));
	connect(this->renderingSurface, SIGNAL(initGLFinished()), this->controls, SLOT(initGLFinished()));
}

MainWindow::~MainWindow()
{
}
