#ifndef CONTROLS_H
#define CONTROLS_H

#include <QGroupBox>
#include <QSpinBox>
#include <QDoubleSpinBox>

#include "Shadewidget.h"
#include "Hoverpoints.h"
#include "../renderer/Renderer.h"

/**
* @class Controls defines the controls and the window to embedd them
*/
class Controls : public QWidget
{
	Q_OBJECT

 public:
	Controls(QWidget* parent = 0);
	virtual ~Controls();

 signals:
	//! @brief emits this signal when the screen-shot-button is pressed
	void screenShotPressed();

 public slots:
	//! @brief reacts on the finished OpenGL initialization
	void initGLFinished();
	//! @brief loads a Volume from the given filename and sets it as active to be rendered
	void saveTransferFunctions(const std::string&);

	void setDataset();
	
	void setDoTexture();
	void setTextureChannel();
	
	void setDoArrows();
	void setArrowSize();
	void setArrowStyle();
	
	void setDoStreamlines();
	void setStreamlineColor();
	void setStreamlineDtest();
	void setStreamlineDsep();
	void setStreamlineSegLength();
	void setStreamlineStyle();

 private:
	
	QGroupBox* boxDataset;
	QGroupBox* boxTexture;
	QGroupBox* boxArrows;
	QGroupBox* boxStreamlines;
	QGroupBox* boxTF;

	QComboBox* cbData;
	
	QLabel* lblBgChannel;
	QComboBox* cbBgChannel;
	//QLabel* lblBgTF;
	//QComboBox* cbBgTF;
	
	QLabel* lblArrowSize;
	QDoubleSpinBox* sbArrowSize;
	QLabel* lblArrowStyle;
	QComboBox* cbArrowStyle;

	QLabel* lblStreamlineColor;
	QLabel* lblStreamlineDtest;
	QDoubleSpinBox* sbStreamlineDtest;
	QLabel* lblStreamlineDsep;
	QSpinBox* sbStreamlineDsep;
	QLabel* lblStreamlineSegLength;
	QDoubleSpinBox* cbStreamlineSegLength;
	QLabel* lblStreamlineStyle;
	QComboBox* cbStreamlineStyle;
	
	std::vector<Renderer::TransferFunction*> transferFunctions;

	QLabel* transferFuncLabel;
	QComboBox* transferFuncBox;

	QCheckBox* cbTf;
	QLineEdit* tfName;
	
	QPushButton* newTfButton;

	ShadeWidget* transferEditor;

	QPushButton* screenShotButton;

 private slots:
	void transferFuncSelected(int);

	void newTransferFuncPressed();
	void loadTransferFunctions(const std::string&);
	Renderer::TransferFunction* loadTF(QString&, QDomElement&);
	bool loadTFPoint(Renderer::TFPoint& tfPoint, QDomElement&);

};

#endif
