#include "Controls.h"

#include "../FlowVis.h"

#include <iostream>

using namespace std;

Controls::Controls(QWidget* parent)
	: QWidget(parent)
{
	this->setObjectName("Controls");

	this->setFixedSize(200, 768);
	//this->transferFuncLabel->setText("Transferfunction:");
	
	this->boxDataset = new QGroupBox(this);
	this->boxDataset->setTitle("Dataset");
	this->boxDataset->setFixedSize(180,45);
	this->boxDataset->move(10, 0);
	this->boxDataset->setFlat(true);

	this->cbData = new QComboBox(this->boxDataset);
	this->cbData->setFixedSize(160,20);
	this->cbData->move(10,25);
	this->cbData->addItem("Hurricane");
	this->cbData->addItem("Hurricane t=10");
	this->cbData->addItem("Hurricane t=48");
	this->cbData->addItem("Tube");
	this->cbData->addItem("Block");
	connect(this->cbData, SIGNAL(activated(int)), this, SLOT(setDataset()));

	this->boxTexture = new QGroupBox(this);
	this->boxTexture->setTitle("Texture");
	this->boxTexture->setFixedSize(180,55);
	this->boxTexture->move(10, 45);
	this->boxTexture->setFlat(true);
	this->boxTexture->setCheckable(true);
	this->boxTexture->setChecked(true);
	//connect(this->boxTexture, SIGNAL(toggled(bool)), this, SLOT(setDoTexture()));

	this->lblBgChannel = new QLabel(this->boxTexture);
	this->lblBgChannel->setText("Channel");
	this->lblBgChannel->move(10,25);
	this->cbBgChannel = new QComboBox(this->boxTexture);
	this->cbBgChannel->move(60,20);
	this->cbBgChannel->addItem("0 (X-Velocity)");
	this->cbBgChannel->addItem("1 (Y-Velocity)");
	this->cbBgChannel->addItem("2 (Z-Velocity)");
	this->cbBgChannel->addItem("3 (Temp/Pressure)");
	this->cbBgChannel->addItem("4 (Humidity/Vorticity)");
	connect(this->cbBgChannel, SIGNAL(activated(int)), this, SLOT(setTextureChannel()));
	//this->lblBgTF = new QLabel(this->boxTexture);
	//this->lblBgTF->setText("TF");
	//this->lblBgTF->move(10,50);
	//this->cbBgTF = new QComboBox(this->boxTexture);
	//this->cbBgTF->move(60,45);

	this->boxArrows = new QGroupBox(this);
	this->boxArrows->setTitle("Arrows");
	this->boxArrows->setFixedSize(180,70);
	this->boxArrows->move(10, 85);
	this->boxArrows->setFlat(true);
	this->boxArrows->setCheckable(true);
	this->boxArrows->setChecked(true);
	connect(this->boxArrows, SIGNAL(toggled(bool)), this, SLOT(setDoArrows()));

	this->lblArrowSize = new QLabel(this->boxArrows);
	this->lblArrowSize->setText("Size");
	this->lblArrowSize->move(10,25);
	this->sbArrowSize = new QDoubleSpinBox(this->boxArrows);
	this->sbArrowSize->move(60,20);
	this->sbArrowSize->setRange(1.0,20.0);
	this->sbArrowSize->setSingleStep(0.1);
	this->sbArrowSize->setValue(10.0);
	connect(this->sbArrowSize, SIGNAL(valueChanged(double)), this, SLOT(setArrowSize()));
	this->lblArrowStyle = new QLabel(this->boxArrows);
	this->lblArrowStyle->setText("Style");
	this->lblArrowStyle->move(10,50);
	this->cbArrowStyle = new QComboBox(this->boxArrows);
	this->cbArrowStyle->move(60,45);
	this->cbArrowStyle->addItem("Default");
	this->cbArrowStyle->addItem("Alternate");
	this->cbArrowStyle->setEnabled(false);

	this->boxStreamlines = new QGroupBox(this);
	this->boxStreamlines->setTitle("Streamlines");
	this->boxStreamlines->setFixedSize(180,150);
	this->boxStreamlines->move(10,150);
	this->boxStreamlines->setFlat(true);
	this->boxStreamlines->setCheckable(true);
	this->boxStreamlines->setChecked(true);
	connect(this->boxStreamlines, SIGNAL(toggled(bool)), this, SLOT(setDoStreamlines()));

	this->lblStreamlineColor = new QLabel(this->boxStreamlines);
	this->lblStreamlineColor->setText("Color");
	this->lblStreamlineColor->move(10,25);
	this->lblStreamlineDtest = new QLabel(this->boxStreamlines);
	this->lblStreamlineDtest->setText("Dtest");
	this->lblStreamlineDtest->move(10,50);
	this->sbStreamlineDtest = new QDoubleSpinBox(this->boxStreamlines);
	this->sbStreamlineDtest->move(60,45);
	this->sbStreamlineDtest->setRange(0.2,0.9);
	this->sbStreamlineDtest->setSingleStep(0.1);
	this->sbStreamlineDtest->setValue(0.5);
	connect(this->sbStreamlineDtest, SIGNAL(valueChanged(double)), this, SLOT(setStreamlineDtest()));
	this->lblStreamlineDsep = new QLabel(this->boxStreamlines);
	this->lblStreamlineDsep->setText("Dsep");
	this->lblStreamlineDsep->move(10,75);
	this->sbStreamlineDsep = new QSpinBox(this->boxStreamlines);
	this->sbStreamlineDsep->move(60,70);
	this->sbStreamlineDsep->setRange(5,15);
	this->sbStreamlineDsep->setSingleStep(1);
	this->sbStreamlineDsep->setValue(10);
	connect(this->sbStreamlineDsep, SIGNAL(valueChanged(int)), this, SLOT(setStreamlineDsep()));
	this->lblStreamlineSegLength = new QLabel(this->boxStreamlines);
	this->lblStreamlineSegLength->setText("Dist");
	this->lblStreamlineSegLength->move(10,100);
	this->cbStreamlineSegLength = new QDoubleSpinBox(this->boxStreamlines);
	this->cbStreamlineSegLength->move(60,95);
	this->cbStreamlineSegLength->setRange(1.0,10.0);
	this->cbStreamlineSegLength->setSingleStep(0.1);
	this->cbStreamlineSegLength->setValue(5.0);
	connect(this->cbStreamlineSegLength, SIGNAL(valueChanged(double)), this, SLOT(setStreamlineSegLength()));
	this->lblStreamlineStyle = new QLabel(this->boxStreamlines);
	this->lblStreamlineStyle->setText("Style");
	this->lblStreamlineStyle->move(10,125);
	this->cbStreamlineStyle = new QComboBox(this->boxStreamlines);
	this->cbStreamlineStyle->move(60,120);
	this->cbStreamlineStyle->addItem("Default");
	this->cbStreamlineStyle->addItem("Tapering");
	this->cbStreamlineStyle->addItem("Arrowed");
	this->cbStreamlineStyle->setEnabled(false);

	this->boxTF = new QGroupBox(this);
	this->boxTF->setTitle("Transfer-F");
	this->boxTF->move(10,285);
	this->boxTF->setFlat(true);
	
	this->transferFuncBox = new QComboBox(this);
	this->transferFuncBox->setFixedSize(180, 20);
	this->transferFuncBox->move(10, 310);
	connect(this->transferFuncBox, SIGNAL(activated(int)), this, SLOT(transferFuncSelected(int)));

	this->transferEditor = new ShadeWidget(this);
	this->transferEditor->setFixedSize(180, 390);
	this->transferEditor->move(10, 360);


	this->tfName = new QLineEdit(this);
	this->tfName->setFixedSize(140, 30);
	this->tfName->move(10, 330);

	this->newTfButton = new QPushButton(this);
	this->newTfButton->setFixedSize(40, 30);
	this->newTfButton->move(150,330);
	this->newTfButton->setText("New");
	connect(this->newTfButton, SIGNAL(clicked()), this, SLOT(newTransferFuncPressed()));

	this->screenShotButton = new QPushButton(this);
	this->screenShotButton->setFixedSize(180, 20);
	this->screenShotButton->move(10, 750);
	this->screenShotButton->setText("Screenshot");
	connect(this->screenShotButton, SIGNAL(clicked()), this, SIGNAL(screenShotPressed()));
	this->loadTransferFunctions("tf.xml");

	//std::cout << " xxx " << this->transferFunctions[0].points[0]->pos << std::endl;
	this->transferFunctions[0]->histo = FlowVis::getRenderer().getHisto();
	this->transferFunctions[0]->maxHist = FlowVis::getRenderer().getMaxHist();
	this->transferEditor->set_transferfunction(*this->transferFunctions[0]);
}

void Controls::setDataset()
{
	FlowVis::getRenderer().setDataset(this->cbData->currentIndex());
	//Renderer* renderer = &FlowVis::getRenderer();
	//delete renderer;
	//renderer = new Renderer(this->cbData->currentIndex());
}
	
void Controls::setDoTexture()
{

}
void Controls::setTextureChannel()
{
	FlowVis::getRenderer().setChannel(this->cbBgChannel->currentIndex());
}

void Controls::setDoArrows()
{
	FlowVis::getRenderer().setArrows(this->boxArrows->isChecked());
}
void Controls::setArrowSize()
{
	FlowVis::getRenderer().setArrowSize(this->sbArrowSize->value());
}
void Controls::setArrowStyle()
{

}

void Controls::setDoStreamlines()
{
	FlowVis::getRenderer().setStreamlines(this->boxStreamlines->isChecked());
}
void Controls::setStreamlineColor()
{

}
void Controls::setStreamlineDtest()
{
	FlowVis::getRenderer().setDTest(this->sbStreamlineDtest->value());
}
void Controls::setStreamlineDsep()
{
	FlowVis::getRenderer().setDSep(this->sbStreamlineDsep->value());
}
void Controls::setStreamlineSegLength()
{
	FlowVis::getRenderer().setStepSize(this->cbStreamlineSegLength->value());
}
void Controls::setStreamlineStyle()
{

}

Controls::~Controls()
{
}

void Controls::initGLFinished()
{
	if (this->transferFunctions.size() == 0)
		return;
	
	this->transferFunctions[0]->histo = FlowVis::getRenderer().getHisto();
	this->transferFunctions[0]->maxHist = FlowVis::getRenderer().getMaxHist();
	this->transferEditor->set_transferfunction(*this->transferFunctions[0]);

	FlowVis::getRenderer().setTransferFunction(*this->transferFunctions[0]);
}

void Controls::newTransferFuncPressed()
{
	QString tfName = this->tfName->text();
   
	Renderer::TransferFunction* tf = new Renderer::TransferFunction();
	
	tf->histo = FlowVis::getRenderer().getHisto();
	tf->maxHist = FlowVis::getRenderer().getMaxHist();

	(*tf).width = 4096;

	Renderer::TFPoint tfPointStart;
	Renderer::TFPoint tfPointEnd;
	
	tfPointStart.pos = 0;
	tfPointStart.r = 0;
	tfPointStart.g = 0;
	tfPointStart.b = 0;
	tfPointStart.a = 0;

	tfPointEnd.pos = 4096;
	tfPointEnd.r = 0;
	tfPointEnd.g = 0;
	tfPointEnd.b = 0;
	tfPointEnd.a = 0;
	
	tf->points.push_back(tfPointStart);
	tf->points.push_back(tfPointEnd);

	this->transferFunctions.push_back(tf);

	this->transferFuncBox->addItem(tfName);
}

void Controls::transferFuncSelected(int index)
{
	cout << "selected TF " << index << endl;

	this->transferFunctions[0]->histo = FlowVis::getRenderer().getHisto();
	this->transferFunctions[0]->maxHist = FlowVis::getRenderer().getMaxHist();
	this->transferEditor->set_transferfunction(*this->transferFunctions[index]);

	FlowVis::getRenderer().setTransferFunction(*this->transferFunctions[index]);
}

void Controls::saveTransferFunctions(const string& fileName)
{

  std::cout << "saving transferfunctions ..." << std::endl;

  QDomDocument doc;
  QFile file(fileName.c_str());
  if (!file.open(QIODevice::WriteOnly | QIODevice::Truncate | QIODevice::Text))
    return;

  QDomElement root = doc.createElement("transferFunctions");
  doc.appendChild( root );

  std::vector<Renderer::TransferFunction*>::iterator tfIter;
  int i = 0;
  
  for(tfIter = transferFunctions.begin(); tfIter != transferFunctions.end(); tfIter++)
  {
    QDomElement tf = doc.createElement("transferFunction");
    tf.setAttribute( "name", this->transferFuncBox->itemText(i) );
    tf.setAttribute( "width", (*tfIter)->width );
    root.appendChild( tf );

    std::vector<Renderer::TFPoint>::iterator pIter;
    
    for(pIter = (*tfIter)->points.begin(); pIter != (*tfIter)->points.end(); pIter++ )
    {
      QDomElement point = doc.createElement("point");
      point.setAttribute( "pos", (*pIter).pos );
      point.setAttribute( "r", (*pIter).r );
      point.setAttribute( "g", (*pIter).g );
      point.setAttribute( "b", (*pIter).b );
      point.setAttribute( "a", (*pIter).a );

      tf.appendChild( point );
    }

    i++;
  }
  
  QTextStream out(&file);
  out << doc.toString();

  file.close();

  std::cout << "saved" << std::endl;
  
}

// loads all transferfunctions from a given xml-file
void Controls::loadTransferFunctions(const string& fileName)
{
	QDomDocument doc;
	QFile file(fileName.c_str());
	if (!file.open(QIODevice::ReadOnly))
		return;

	if (!doc.setContent(&file)) {
		file.close();
		return;
	}

	QDomElement tfsElement = doc.firstChildElement("transferFunctions");
	if (tfsElement.isNull()) {
		cout << "ERROR in Controls::loadTransferFunctions: failed to get transferFunctions-node" << endl;
		file.close();
		return;
	}

	QDomNode tfNode = tfsElement.firstChild();
	while(!tfNode.isNull()) {
		QDomElement e = tfNode.toElement();
		if(!e.isNull()) {
			if (e.tagName() == "transferFunction") {
				QString tfName;
				Renderer::TransferFunction* tf = this->loadTF(tfName, e);
				tf->histo = FlowVis::getRenderer().getHisto();
				if (tf) {
					this->transferFunctions.push_back(tf);
					this->transferFuncBox->addItem(tfName);
				}
			}
		}

		tfNode = tfNode.nextSibling();
	}
}

// returns a single TransferFunction* from a DomElement
Renderer::TransferFunction* Controls::loadTF(QString& tfName, QDomElement& e)
{
	Renderer::TransferFunction* tf = new Renderer::TransferFunction();

	tfName = e.attribute("name");
	tf->width = atoi(e.attribute("width").toStdString().c_str());

	cout << "New TF with Name= " << tfName.toStdString() << " and width = " << tf->width << endl;

	for(QDomNode n = e.firstChild(); !n.isNull(); n = n.nextSibling()) {
		QDomElement e = n.toElement();
		if(!e.isNull()) {
			if (e.tagName() == "point") {
				Renderer::TFPoint tfPoint;
				if (this->loadTFPoint(tfPoint, e))
					tf->points.push_back(tfPoint);
			}
		}
	}

	return tf;
}

// returns a single TransferFunction* from a DomElement
bool Controls::loadTFPoint(Renderer::TFPoint& tfPoint, QDomElement& e)
{
	tfPoint.pos = atoi(e.attribute("pos").toStdString().c_str());
	tfPoint.r = atoi(e.attribute("r").toStdString().c_str());
	tfPoint.g = atoi(e.attribute("g").toStdString().c_str());
	tfPoint.b = atoi(e.attribute("b").toStdString().c_str());
	tfPoint.a = atoi(e.attribute("a").toStdString().c_str());

	cout << "new Point with pos = " << tfPoint.pos << " r = " << (int) tfPoint.r << " g = " << (int) tfPoint.g << " b = " << (int) tfPoint.b << " a = "<< (int) tfPoint.a << endl;

	return true;
}
