#ifndef FLOWVIS_H
#define FLOWVIS_H

#include "renderer/Renderer.h"
#include "gui/MainWindow.h"

/**
* @class FlowVis is the central Hub of the Program. It's main purpose is to create a new Instance of both the
* Renderer and MainWindow and provide access to the Renderer and MainWindow in a Singleton-Way.
*/
class FlowVis
{
 public:
	//! @brief must be called first to initialize the Class which will instantiate the MainWindow and the Renderer
	static void initialize();
	//! @brief call to dispose the Class which will result in disposal of the MainWindow and the Renderer
	static void shutdown();

	//! @brief returns the Singleton Instance of the Renderer
	static Renderer& getRenderer() { return *FlowVis::renderer; };

	//! @brief returns the Singleton Instance of the MainWindow
	static MainWindow& getMainWindow() { return *FlowVis::mainWin; };

	//! @brief starts the App by showing the MainWindow
	static void start();

 private:
	static Renderer* renderer;
	static MainWindow* mainWin;
};

#endif
