uniform sampler2D channel0Tex;
uniform sampler2D channel1Tex;

uniform float pointSize;

void main()
{
	// standard OpenGL transform
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	// pass texcoord
	gl_TexCoord[0] = gl_MultiTexCoord0;

	// need to divide the position of the vertex by the dimensions because we need to map into 0...1
	vec2 position = gl_Vertex.xy;
	position = (position - gl_PointSize) / 500.0;

	// fetching velocity X and Y - luminance has same value in all components
	float velocityX = texture2D(channel0Tex, position.xy).x;
	// need to negate Y-Component (tutor says so... ;))
	float velocityY = -texture2D(channel1Tex, position.xy).x;
	
	// need to bring velocity vector between -1 and 1 for angle calculation
	velocityX = (velocityX * 2.0 - 1.0);
	velocityY = (velocityY * 2.0 + 1.0);

	vec2 velocity = vec2(velocityX, velocityY);


	float magnitude = length(velocity);
	//if( magnitude < 0.5)
	//	gl_PointSize = pointSize;
	//else
		gl_PointSize = pointSize * magnitude * 2;
	
	velocity = normalize(velocity);

	// calculate angle
	float angle = acos(velocity.x);
	// special case for y < 0.0
	if (velocityY < 0.0)
		angle = 2.0 * 3.1415926535 - angle;

	// store the angle in texcoord to pass to frag-shader without varying
	gl_TexCoord[1].s = angle;
	//gl_TexCoord[1].t = magnitude;
}
