uniform sampler2D arrowTex;

void main()
{
	// calculate angles, angle has been stored by vert-shader in textcoord[1]
	//float cosAngle = cos(gl_TexCoord[1].s * 2 - 1);
	//float sinAngle = sin(gl_TexCoord[1].s * 2 - 1) ;

	// we stored cosine of angle
	//mat2 rotationMatrix = mat2(cosAngle, -sinAngle, sinAngle, cosAngle);

	// center of arrowTex
	//vec2 h = vec2(0.5, 0.5);
	// rotate Texture Coordinates
	//vec2 rotatedTexCoord = (rotationMatrix * (gl_TexCoord[0].st - h)) + h;

	

	float cosAngle = cos(gl_TexCoord[1].s);
	float sinAngle = sin(gl_TexCoord[1].s);
	mat2 rotationMatrix = mat2(cosAngle, -sinAngle, sinAngle, cosAngle);
	
	vec2 rotatedTexCoord = gl_TexCoord[0].st * 2.0 - 1.0;
	rotatedTexCoord = rotationMatrix * rotatedTexCoord;

	rotatedTexCoord = (rotatedTexCoord + 1.0) * 0.5;

	rotatedTexCoord.x = clamp(rotatedTexCoord.x, 0.0 , 1.0);
	rotatedTexCoord.y = clamp(rotatedTexCoord.y, 0.0 , 1.0);

	// fetch
	gl_FragColor = texture2D(arrowTex, rotatedTexCoord.xy);
	if( gl_FragColor.x <= 0.1 && gl_FragColor.y <= 0.1 && gl_FragColor.z <= 0.1)
		gl_FragColor.w = 0.0;
	else
		gl_FragColor.w = 0.6;
}