#include "DensityPoint.h"

/**
* DensityPoint constructor.
* This class handles the points used by the transfer function.
*
*/
DensityPoint::DensityPoint () 
{
	density = 0;
	color = new Color(0,0,0,0);
}

/**
*@override
* DensityPoint constructor.
* This class handles the points used by the transfer function.
* Each point has a density value and a color.
*
* @param float d
* @param Color* c
*/
DensityPoint::DensityPoint (float d, Color* c) 
{
	this->density = d;
	this->color = c;
}

/**
* Get color of density point.
*
* @return Color* color
*/
Color* DensityPoint::getColor() 
{
	return color;
}

/**
* Set color of density point.
*
* @param Color* c
*/
void DensityPoint::setColor(Color* c)
{
	color = c;
}

/**
* Get density of density point.
*
* @return float density
*/
float DensityPoint::getDensity() 
{
	return density;
}

/**
* Set density of density point.
*
* @param float d
*/
void DensityPoint::setDensity(float d)
{
	density = d;
}