float sizeX, sizeY, sizeZ;
int backgroundType;

// Pfeile
float4 arrowPos;
float arrowSize;
int arrowColorAccordingTo;
int arrowSizeAccordingTo;
float4 arrowFixedColor;

float ratio2D;

float4x4 arrowRotationM = {1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1};
float4x4 arrowTranslationM = {1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1};
float4x4 arrowSizeM = {1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1};

// Streamlines
float4 streamlineFixedColor;
int streamlineColorAccordingTo;

// Texturen
texture texData16;
texture texData32F;
texture texStreamvector;
texture texTransferBg;
texture texTransferArrows;
texture texTransferStreamlines;
texture texWhiteNoise;

// gui
float4x4 xViewProjectionM;
float4x4 viewRotationM;


// Sampler
sampler2D Data16TextureSampler = sampler_state { 
	texture = <texData16> ;
    magfilter = linear; 
    minfilter = linear;
    mipfilter = linear;
    AddressU = border;
    AddressV = border;
};

sampler2D Data32FTextureSampler = sampler_state { 
	texture = <texData32F> ;
    magfilter = linear; 
    minfilter = linear;
    mipfilter = linear;
    AddressU = clamp;
    AddressV = clamp;
};

sampler2D StreamvectorTextureSampler = sampler_state { 
	texture = <texStreamvector> ;
    AddressU  = clamp;        
    AddressV  = clamp;
    mipfilter = none;
    minfilter = none;
    magfilter = none;
};

sampler1D TransferBgTextureSampler = sampler_state { 
	texture = <texTransferBg> ;
    magfilter =linear; 
    minfilter =linear;
    AddressU = clamp;
};

sampler1D TransferArrowsTextureSampler = sampler_state { 
	texture = <texTransferArrows> ;
    magfilter =linear; 
    minfilter =linear;
    AddressU = clamp;
};

sampler1D TransferStreamlinesTextureSampler = sampler_state { 
	texture = <texTransferStreamlines> ;
    magfilter =linear; 
    minfilter =linear;
    AddressU = clamp;
};

sampler2D WhiteNoiseSampler = sampler_state { 
	texture = <texWhiteNoise> ;
    magfilter =linear; 
    minfilter =linear;
    AddressU = clamp;
    AddressV = clamp;
};
  
struct VertexIn {
    float4 Position     : POSITION;
    float4 TexCoords    : TEXCOORD0;
    float4 Color		: COLOR0;
};

struct VertexOut {
 	float4 Position     : POSITION;
    float4 TexCoords    : TEXCOORD0;
    float4 Color		: COLOR0;
};

//// Shader ////

// vertex mapper 

VertexOut VertexMapper(VertexIn In) {
    VertexOut output = (VertexOut)0;
   
   	output.Position = mul(In.Position, mul(viewRotationM, xViewProjectionM));
    output.TexCoords = In.TexCoords;
    output.Color = In.Color;
        
    return output;    
}

// pfeil mapper 

VertexOut ArrowMapper(VertexIn In) {
    VertexOut output = (VertexOut)0;
       
    float3 streamDirection = tex2Dlod (StreamvectorTextureSampler,float4(arrowPos.xy,0.0f,0.0f)).xyz;
      
    float alpha = atan2(streamDirection.y,streamDirection.x);

    float arrowSizeChange = 0.5;   
    if (arrowSizeAccordingTo == 0)
    	arrowSizeChange = tex2Dlod (Data32FTextureSampler,float4(arrowPos.xy,0.0f,0.0f)).r;
   	else if (arrowSizeAccordingTo == 1)
   		arrowSizeChange = tex2Dlod (Data32FTextureSampler,float4(arrowPos.xy,0.0f,0.0f)).g;
   	else if (arrowSizeAccordingTo == 2)
   		arrowSizeChange = tex2Dlod (Data32FTextureSampler,float4(arrowPos.xy,0.0f,0.0f)).b;
   	
   	arrowSizeChange = (arrowSize + 2 * arrowSizeChange) / 2;
   	
   	arrowSizeM = float4x4 (float4(arrowSizeChange, 0, 0, 0),
    					   float4(0, arrowSizeChange, 0, 0),
    					   float4(0, 0, arrowSizeChange, 0),
    					   float4(0, 0, 0, 1));
    
    arrowRotationM = float4x4 (float4(cos(alpha), -sin(alpha), 0, 0),
    					       float4(sin(alpha), cos(alpha), 0, 0), 
    					       float4(0,0,0,0),
    					       float4(0,0,0,1));

	if (ratio2D < 1.0f)
		arrowTranslationM = float4x4 (float4(1,0,0,(arrowPos.x - .5)*2*ratio2D),
    					       	  	float4(0,1,0,(arrowPos.y - .5)*2), 
    					       	  	float4(0,0,1,0),
    					       	  	float4(0,0,0,1));
	else
		arrowTranslationM = float4x4 (float4(1,0,0,(arrowPos.x - .5)*2),
    					       	  	float4(0,1,0,(arrowPos.y - .5)*2/ratio2D), 
    					       	  	float4(0,0,1,0),
    					       	  	float4(0,0,0,1));
    					   
	output.Position = mul(mul(mul(arrowTranslationM,mul(arrowRotationM, mul(arrowSizeM, In.Position))), viewRotationM), xViewProjectionM);
    output.Color = arrowFixedColor;
   	      
    return output;
}

// streamline mapper

VertexOut StreamlineMapper(VertexIn In) {
    VertexOut output = (VertexOut)0;
   
   	output.Position = mul(In.Position, mul(viewRotationM, xViewProjectionM));
    output.TexCoords = (In.Position + 1.0) / 2.0;
    output.Color = streamlineFixedColor;
    output.Color.a = In.Color.a * streamlineFixedColor.a;
        
    return output;    
}

// Transferfunktion

float4 Transferlookup(VertexOut In) : COLOR0 {

	if (backgroundType == 0)
		return tex1Dlod (TransferBgTextureSampler, tex2Dlod (Data16TextureSampler, float4(In.TexCoords.xy, 0, 0)).r);
	else if (backgroundType == 1)
		return tex1Dlod (TransferBgTextureSampler, tex2Dlod (Data16TextureSampler, float4(In.TexCoords.xy, 0, 0)).g);
	else
		return tex1Dlod (TransferBgTextureSampler, tex2Dlod (Data16TextureSampler, float4(In.TexCoords.xy, 0, 0)).b);
}

// Pfeile

float4 ArrowPainter (VertexOut In) : COLOR0 {
	
	if (arrowColorAccordingTo == -1)
		return In.Color;
	else if (arrowColorAccordingTo == 0)
		return tex1D (TransferArrowsTextureSampler, tex2D (Data16TextureSampler, arrowPos).r);
	else if (arrowColorAccordingTo == 1)
		return tex1D (TransferArrowsTextureSampler, tex2D (Data16TextureSampler, arrowPos).g);
	else
		return tex1D (TransferArrowsTextureSampler, tex2D (Data16TextureSampler, arrowPos).b);
}

// Streamlines

float4 StreamlinePainter(VertexOut In) : COLOR0 {
		
	float4 color;
	if (streamlineColorAccordingTo == -1)
		color = In.Color;
	else if (streamlineColorAccordingTo == 0)
		color = tex1Dlod (TransferStreamlinesTextureSampler, tex2Dlod (Data16TextureSampler, float4(In.TexCoords.xy, 0, 0)).r);
	else if (streamlineColorAccordingTo == 1)
		color = tex1Dlod (TransferStreamlinesTextureSampler, tex2Dlod (Data16TextureSampler, float4(In.TexCoords.xy, 0, 0)).g);
	else
		color = tex1Dlod (TransferStreamlinesTextureSampler, tex2Dlod (Data16TextureSampler, float4(In.TexCoords.xy, 0, 0)).b);
		
	color.a = In.Color.a * color.a;
	
	return color;
}

// techniques

technique Background {
    pass Pass0 {        
        VertexShader = compile vs_1_1 VertexMapper();
        PixelShader = compile ps_3_0 Transferlookup();
    }
}

technique Arrows {
    pass Pass0 {        
        VertexShader = compile vs_3_0 ArrowMapper();
        PixelShader = compile ps_2_0 ArrowPainter();
    }
}

technique Streamlines {
    pass Pass0 {        
        VertexShader = compile vs_1_1 StreamlineMapper();
        PixelShader = compile ps_3_0 StreamlinePainter();
    }
}