uniform sampler2D tex_vector;
uniform sampler2D tex_data;
uniform sampler1D tex_transfer;
uniform int colorCoding;
uniform int arrowScaling;
uniform int arrowSize;

void main()
{
  const float pi = 2.0 * asin(1.0);

  vec4 data = texture2D(tex_vector, gl_Vertex.xy);
  
  // rebuild data
  data.xy *= 2.0;
  data.xy -= 1.0;
  data.y = -data.y;
  
  float rotation_ang = acos(data.x);
  if (data.y < 0.0) 
    rotation_ang = 2*pi-rotation_ang;

  gl_TexCoord[1] = vec4(cos(rotation_ang), -sin(rotation_ang), 
                        sin(rotation_ang), cos(rotation_ang));
    
  // default vertex transformation
	gl_Position = ftransform();
	gl_TexCoord[0] = gl_MultiTexCoord0;

  if (colorCoding==1)
  {
	  gl_FrontColor = texture1D(tex_transfer, texture2D(tex_data, gl_Vertex.xy).x);
    gl_FrontColor.a = gl_FrontColor.a*gl_Color.a;
	  gl_BackColor = gl_FrontColor;
  }
  else
  {
	  gl_FrontColor = gl_Color;
	  gl_BackColor = gl_Color;
  }
  if (arrowScaling==1)
    gl_PointSize = arrowSize*(texture2D(tex_data, gl_Vertex.xy).x);
  else
    gl_PointSize = arrowSize;
}