uniform sampler3D slices;
uniform sampler1D transfer;
uniform sampler2DRect tex_entry;
uniform sampler2DRect tex_exit;
uniform ivec3 volume_dimension;
uniform int mode;

void main()
{
	const float dz = 0.005;
	const int maxrange = 347;
	float deltax = 1.0 / volume_dimension.x;
	float deltay = 1.0 / volume_dimension.y;
	float deltaz = 1.0 / volume_dimension.z;
	const float ns = 8.0;
	
	vec4 entry_point = texture2DRect(tex_entry, vec2(gl_TexCoord[0]));
	vec4 exit_point = texture2DRect(tex_exit, vec2(gl_TexCoord[0]));
	
	float dist = distance(entry_point, exit_point) / dz;
			
	int maxiter = int(floor(dist));
	
	vec3 diff = (exit_point.xyz - entry_point.xyz) / dist;
	vec3 point = entry_point.xyz;
				
	if(entry_point.w == 0.0)
	{
		discard;
	}
	else
	{
		if(mode == 0)
		{
			// Compositing
			float numSamples = 0.0;
			vec4 result = vec4(0.0, 0.0, 0.0, 0.0);
			
			vec4 maxIntensity = texture3D(slices, point);
			
			for(int i = 0; i < maxrange; i++)
			{
				vec4 intensity = texture3D(slices, point);
				vec4 transferred = texture1D(transfer, intensity.x);
							
				//Gradient berechnen
				vec3 gradient;
				gradient.x = 0.5 *(texture3D(slices, vec3(point.x + deltax, point.y, point.z)).x - texture3D(slices, vec3(point.x - deltax, point.y, point.z)).x);
				gradient.y = 0.5 *(texture3D(slices, vec3(point.x, point.y + deltay, point.z)).x - texture3D(slices, vec3(point.x, point.y - deltay, point.z)).x);
				gradient.z = 0.5 *(texture3D(slices, vec3(point.x, point.y, point.z + deltaz)).x - texture3D(slices, vec3(point.x, point.y, point.z - deltaz)).x);			
				
				//Schattierung berechnen
				vec3 N = normalize(gl_NormalMatrix * gradient);
				vec3 L = normalize((gl_LightSource[0].position - gl_ModelViewMatrix * vec4(point, 1.0)).xyz);//normalize(gl_LightSource[0].position.xyz);
				vec3 ambient;
				vec3 diffuse;
				vec3 specular;
				float NL = max(0.0, dot(N, L));
				
				ambient = transferred.rgb * gl_LightSource[0].ambient.rgb;
				diffuse = transferred.rgb * gl_LightSource[0].diffuse.rgb * NL;
				
				float NH = max(0.0, dot(N, normalize(gl_LightSource[0].halfVector.xyz)));
				specular = transferred.rgb * gl_LightSource[0].specular.rgb * pow(NH, ns);
			
				result.xyz += (1 - result.w) * transferred.w * vec3(ambient + diffuse + specular);//vec3(ambient + diffuse + specular);
				result.w += (1 - result.w) * transferred.w;
				
				point += diff;
				
				if(i >= maxiter - 1 || result.w >= 1.0)
				{
					break;
				}
			}
			gl_FragColor = result;
		}
		else if(mode == 1)
		{
			//////// AVG		
			float numSamples = 0.0;
			vec4 result = vec4(0.0, 0.0, 0.0, 0.0);
			
			vec4 maxIntensity = texture3D(slices, point);
			
			for(int i = 0; i < maxrange; i++)
			{
				vec4 intensity = texture3D(slices, point);
				vec4 transferred = texture1D(transfer, intensity.x);

				result.xyz += transferred.w * transferred.xyz;
				result.w += transferred.w;
				
				point += diff;
				
				if(i >= maxiter)
				{
					result /= float(maxiter);
					break;
				}
			}
			gl_FragColor = result;
		}
		else if(mode == 2)
		{
			///// MIP
			float numSamples = 0.0;
			vec4 result = vec4(0.0, 0.0, 0.0, 0.0);
			
			vec4 maxIntensity = texture3D(slices, point);
			
			for(int i = 0; i < maxrange; i++)
			{
				vec4 intensity = texture3D(slices, point);
				vec4 transferred = texture1D(transfer, intensity.x);
				
				if(intensity.r > result.r)
					result = intensity;
				
				point += diff;
				
				if(i >= maxiter)
				{
					//result /= float(maxiter);
					break;
				}
			}
			gl_FragColor = result;
		}
	}
}