
//UNIFORM

uniform sampler1D txDensityTransfer;
uniform sampler3D txVolume;
uniform int shadowSamples;
uniform float shadowTreshold;
uniform float ambience;

//FRAGMENT GLOBAL VARS

float shadowMultiply;
vec3 samplePos;
vec3 lightDir;

//----------------------------------------------------
// SHADOW COMPUTATION
//----------------------------------------------------

void DoShadow()
{
	vec3  sStart          = samplePos - (lightDir*0.02);
	float shadowRayLenght = length(lightDir);
	float step            = shadowRayLenght/shadowSamples;
	vec3  sSamplePos;

	for(int i = 0 ; i < shadowSamples ; i++)
	{
		sSamplePos =  sStart - (lightDir * step * i);

		if(texture1D(txDensityTransfer,texture3D(txVolume, sSamplePos).a).a > shadowTreshold)
		{   
			shadowMultiply = ambience;
			break;
		}
	}
}