
//UNIFORM

uniform vec3 lightPos;
uniform bool bLocalViewer;
uniform bool bHeadLight;

//FRAGMENT GLOBAL VARS

vec3  grad;
float gradLength;
vec3  lightDir;
vec3  rayDir;
vec3  samplePos;
float diffuse;
float specular;

//VARYING

varying vec3 lightDirNL;

//----------------------------------------------------
//LIGHT COMPUTATION 
//----------------------------------------------------

void DoLighting()
{
	grad     = normalize(grad);
	diffuse  = max( 0.0 , dot( grad , lightDir ) );
	specular = 2.0 * diffuse * diffuse - 1.0;
	specular = pow( max( 0.0 , specular ) , 8.0 );
}