
//UNIFORM
uniform sampler3D txVolume;
uniform sampler1D txDensityTransfer;
uniform vec3 gradDelta;

//FRAGMENT GLOBAL VARS
vec3 samplePos;
vec3 grad;

//--------------------------------------------------------------------------------------------------------
//GRATIENT COMPUTATION METHOD 1 - compute the gradient upon the unclassified raw data
//--------------------------------------------------------------------------------------------------------

void Grad1()
{
	grad = vec3(			
	texture3D(txVolume, samplePos + (gradDelta.x * vec3(+1.0, 0.0, 0.0)) ).a - 
	texture3D(txVolume, samplePos + (gradDelta.x * vec3(-1.0, 0.0, 0.0)) ).a,
	texture3D(txVolume, samplePos + (gradDelta.y * vec3(0.0, +1.0, 0.0)) ).a - 
	texture3D(txVolume, samplePos + (gradDelta.y * vec3(0.0, -1.0, 0.0)) ).a,
	texture3D(txVolume, samplePos + (gradDelta.z * vec3(0.0, 0.0, +1.0)) ).a - 
	texture3D(txVolume, samplePos + (gradDelta.z * vec3(0.0, 0.0, -1.0)) ).a
	);
}

//--------------------------------------------------------------------------------------------------------
//GRADIENT COMPUTATION METHOD 2 - compute the gradient upon the classified data
//---------------------------------------------------------------------------------------------------------

void Grad2()
{
	grad = vec3(			
	texture1D(txDensityTransfer,texture3D(txVolume, samplePos + (gradDelta.x * vec3(+1.0, 0.0, 0.0)) ).a).a - 
	texture1D(txDensityTransfer,texture3D(txVolume, samplePos + (gradDelta.x * vec3(-1.0, 0.0, 0.0)) ).a).a,
	texture1D(txDensityTransfer,texture3D(txVolume, samplePos + (gradDelta.y * vec3(0.0, +1.0, 0.0)) ).a).a - 
	texture1D(txDensityTransfer,texture3D(txVolume, samplePos + (gradDelta.y * vec3(0.0, -1.0, 0.0)) ).a).a,
	texture1D(txDensityTransfer,texture3D(txVolume, samplePos + (gradDelta.z * vec3(0.0, 0.0, +1.0)) ).a).a - 
	texture1D(txDensityTransfer,texture3D(txVolume, samplePos + (gradDelta.z * vec3(0.0, 0.0, -1.0)) ).a).a
	);
}