
//UNIFORM

uniform sampler1D txDensityTransfer;
uniform sampler1D txGradTransfer;

//FRAGMENT GLOBAL VARS

float density;
float gradLength;
vec4  sampleCol;

//----------------------------------------------------------------------------------------
//MODULATE ALL - modulate density transfer classification by grad magnitude classification
//----------------------------------------------------------------------------------------

void ModulateAll()
{
	sampleCol = texture1D(txDensityTransfer,density);
	sampleCol *= texture1D(txGradTransfer,gradLength);
}

//----------------------------------------------------------------------------------------
//MODULATE COLOR - modulate density transfer color classification by grad magnitude color
//----------------------------------------------------------------------------------------

void ModulateColor()
{
	sampleCol = texture1D(txDensityTransfer,density);
	vec4 mod =  texture1D(txGradTransfer,gradLength);
	sampleCol.rgb = (1 - mod.a)*sampleCol.rgb + mod.a * mod.rgb;
}

//----------------------------------------------------------------------------------------
//MODULATE NONE - just use density transfer
//----------------------------------------------------------------------------------------

void ModulateNone()
{
	sampleCol = texture1D(txDensityTransfer,density);
}


