
//LIGHTING
uniform bool bHeadLight;
uniform vec3 lightPos;

//TEXTURE ACCESS
varying vec2 fragpos;

//LIGHTDIR
varying vec3 lightDirNL;


 /*********************** DVR VERTEX SHADER *******************\
|*                                                             *|
|*  APPROACH : BACK FRONT COLOR TEXTURES                       *|
|*  VERSION  : 1.2                                             *|
|*  (c)      : Robert Hausmair                                 *|
|*                                                             *|
 \*************************************************************/

void main()
{
	//---------------------------------------------------------------------------
	//transform cube vertex into normalized homogenous projection clip cordinates
	//---------------------------------------------------------------------------

	vec4 ecPos = gl_ModelViewProjectionMatrix * gl_Vertex;

	//---------------------------------------------------------------------------
	//devide in order to get non homogenous clip coordinates [-1,-1]
	//---------------------------------------------------------------------------

	gl_Position = ecPos/ecPos.w;
	
	//---------------------------------------------------------------------------
	//map lookup texture coordinates from [-1,1] to [0,1]
	//---------------------------------------------------------------------------

	fragpos = gl_Position.xy * 0.5 + vec2(0.5);

	//---------------------------------------------------------------------------
	//setup directional light light vector
	//---------------------------------------------------------------------------

	if(bHeadLight)
	{
		lightDirNL = (gl_ModelViewMatrix * vec4(0,0,1,0)).xyz;
	}
	else
	{
		lightDirNL = -lightPos;
	}
}