#extension GL_ARB_texture_rectangle : enable

uniform sampler2DRect backFaces;
uniform sampler2DRect frontFaces;
uniform sampler3D volumeData;

uniform float stepSize;
uniform float threshold;
uniform float lum;

void main(void)
{
   vec3 rayStart = vec3(texture2DRect(backFaces, gl_TexCoord[0].st).rgb);
   vec3 rayEnd = vec3(texture2DRect(frontFaces, gl_TexCoord[0].st).rgb);
   vec3 rayDirection = rayEnd - rayStart; 
   int iterations =int(length(rayDirection)/stepSize);
   vec3 stepVector = normalize(rayDirection) * stepSize;
   vec4 color = vec4(0.0,0.0,0.0,1.0);
   vec3 currentPos = rayStart;
   int counter = 0;
   vec4 currentColor;
   for(int i = 0; i < iterations; i++){
      currentColor = texture3D(volumeData, currentPos.xyz);
      
      if(currentColor.x > threshold){
         color.rgb += currentColor.rgb * currentColor.x;
         counter++;
      }
      currentPos += stepVector;
   }
   color.xyz = color.xyz/counter * lum;
   gl_FragColor = color;
}