#extension GL_ARB_texture_rectangle : enable

uniform sampler3D tex_intensity;
uniform sampler3D tex_gradients;
uniform sampler2DRect tex_entry;
uniform sampler2DRect tex_exit;
uniform sampler2DRect tex_postprocessing;
uniform sampler1D tex_transfer;
uniform int renderpass;
uniform int rendermode;
uniform int stepmode;
uniform int lighting;
uniform int applytransfer;
uniform int modi;
uniform float dz;
uniform float isoValue;

uniform float lightDirWorldX;
uniform float lightDirWorldY;
uniform float lightDirWorldZ;

varying vec3 view;


void raycasting_comp() {
	const int maxrange = 347;
	
	vec4 entry_point = texture2DRect(tex_entry, gl_FragCoord.xy);
	vec4 exit_point = texture2DRect(tex_exit, gl_FragCoord.xy);
	
	vec4 diffuse, ambient, specular;
	vec4 globalAmbient = vec4(0.05, 0.05, 0.05, 0.0);
	
	float NdotL, NdotH, gradientMulti;

	vec3 point = entry_point.xyz;
	vec3 lightDir, normal, H, grad;
	vec4 intensity, transferred, color;
	vec4 result = vec4(0.0, 0.0, 0.0, 0.0);
	
	vec3 V = normalize(-view);
	
	float dist = distance(entry_point, exit_point);
	float distPerStep = dist / dz;
	int maxiter = int(floor(distPerStep));
	vec3 exitMinusEntry = exit_point.xyz - entry_point.xyz;
	vec3 diff = exitMinusEntry / distPerStep;	
	
	if(entry_point.w == 0.0)
	{ 
		discard;
	}
	else
	{
		float numSamples = 0.0;
		for(int i = 0; i < maxrange; i++)
		{	
			intensity = texture3D(tex_intensity, point.xyz);
			transferred = texture1D(tex_transfer, intensity.x);
			grad = texture3D(tex_gradients, point.xyz).xyz;
			grad = (grad * 2.0) - 1.0; // transform gradients from [0...1] into real dimensions
			grad = vec3(gl_NormalMatrix * grad);
			
			//if(intensity.x != 0.0) {
			//	gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
			//	break;
			//}
			
			// show direction texture
			//gl_FragColor = exit_point;
			//break;
			
			if(lighting == 1) // lighting enabled
			{
				normal = normalize(grad);
				//lightDir = normalize(gl_LightSource[0].position.xyz - view);
				lightDir = normalize(vec3(gl_ModelViewMatrix * vec4(lightDirWorldX, lightDirWorldY, lightDirWorldZ, 1.0)) - view);
				
				H = normalize(lightDir + V);
	
				diffuse = 0.5 * transferred * gl_LightSource[0].diffuse;
				ambient = 0.5 * transferred * gl_LightSource[0].ambient;
				specular = 0.5 * transferred * gl_LightSource[0].specular;

				NdotL = max(dot(normal, lightDir), 0.0);
				
				color = globalAmbient;
				
				if (NdotL > 0.0) {
					color += globalAmbient;
					color += ambient;
					color += diffuse * NdotL;
					NdotH = max(dot(normal, H), 0.0);
					color += specular * pow(NdotH, gl_FrontMaterial.shininess);
				}
				result.xyz += (1.0 - result.w) * transferred.w * color.xyz;
				result.w += (1.0 - result.w) * transferred.w;
			}
			else
			{	
				result.xyz += (1.0 - result.w) * transferred.w * transferred.xyz;
				result.w += (1.0 - result.w) * transferred.w;
			}
			
			if(stepmode == 0) // adaptive stepsize enabled
			{	
				if((length(grad) >= 0.0) && (length(grad) <= 0.03)) 
				{ 
					gradientMulti = 0.005;
				}
				else  
				{ 
					gradientMulti = 1.0 / length(grad) / 1000.0;
				}
				point += gradientMulti * exitMinusEntry;
				if((length(point - entry_point.xyz) >= dist) || (result.w >= 1.0)) break;
			}
			else
			{
				point += diff;
				if((result.w >= 1.0) || (i >= maxiter)) break;
			}
		}
		
		gl_FragColor = result;
	}
}

void raycasting_avg() {
	const int maxrange = 347;
	int iters = 0;
	
	vec4 entry_point = texture2DRect(tex_entry, gl_FragCoord.xy);
	vec4 exit_point = texture2DRect(tex_exit, gl_FragCoord.xy);
	
	vec3 point = entry_point.xyz;
	vec4 intensity = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 transferred = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 result = vec4(0.0, 0.0, 0.0, 0.0);
	
	float gradientMulti;
	vec3 grad;
	
	float dist = distance(entry_point, exit_point);
	float distPerStep = dist / dz;
	int maxiter = int(floor(distPerStep));
	vec3 exitMinusEntry = exit_point.xyz - entry_point.xyz;
	vec3 diff = exitMinusEntry / distPerStep;
	
	if(entry_point.w == 0.0) 
	{ 
		discard;
	}
	else
	{
		float numSamples = 0.0;
		for(int i = 0; i < maxrange; i++)
		{	
			intensity = texture3D(tex_intensity, point.xyz);
			transferred = texture1D(tex_transfer, intensity.x);			
			
			result.xyz += transferred.w * transferred.xyz;
			result.w += transferred.w;
			
			if(stepmode == 0) // adaptive stepsize enabled
			{	
				iters++;
				grad = texture3D(tex_gradients, point.xyz).xyz;
				grad = (grad * 2.0) - 1.0; // transform gradients from [0...1] into real dimensions
				grad = vec3(gl_NormalMatrix * grad);
				if((length(grad) >= 0.0) && (length(grad) <= 0.03)) 
				{ 
					gradientMulti = 0.005;
				}
				else  
				{ 
					gradientMulti = 1.0 / length(grad) / 1000.0;
				}
				point += gradientMulti * exitMinusEntry;
				if(length(point - entry_point.xyz) >= dist) 
				{ 
					result /= float(iters);
					break;
				}
			}
			else
			{
				point += diff;
			
				if(i >= maxiter)
				{
					result /= float(maxiter);
					break;
				}
			}							
		}	
		
		gl_FragColor = result;
	}	
}

void raycasting_mip() {
	const int maxrange = 347;
	
	vec4 entry_point = texture2DRect(tex_entry, gl_FragCoord.xy);
	vec4 exit_point = texture2DRect(tex_exit, gl_FragCoord.xy);
	
	vec3 point = entry_point.xyz;
	vec4 intensity = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 transferred = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 result = vec4(0.0, 0.0, 0.0, 0.0);
	
	float gradientMulti;
	vec3 grad;
	
	float dist = distance(entry_point, exit_point);
	float distPerStep = dist / dz;
	int maxiter = int(floor(distPerStep));
	vec3 exitMinusEntry = exit_point.xyz - entry_point.xyz;
	vec3 diff = exitMinusEntry / distPerStep;
	
	vec4 intensity_max = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 transferred_max = vec4(0.0, 0.0, 0.0, 0.0);
	
	if(entry_point.w == 0.0) 
	{ 
		discard;
	}
	else
	{
		float numSamples = 0.0;
		for(int i = 0; i < maxrange; i++)
		{	
			intensity = texture3D(tex_intensity, point.xyz);
			transferred = texture1D(tex_transfer, intensity.x);	
			
			if(intensity.x > intensity_max.x) {
				intensity_max = intensity;
				transferred_max = transferred;
			}
			
			if(stepmode == 0) // adaptive stepsize enabled
			{	
				grad = texture3D(tex_gradients, point.xyz).xyz;
				grad = (grad * 2.0) - 1.0; // transform gradients from [0...1] into real dimensions
				grad = vec3(gl_NormalMatrix * grad);
				if((length(grad) >= 0.0) && (length(grad) <= 0.03)) 
				{ 
					gradientMulti = 0.005;
				}
				else  
				{ 
					gradientMulti = 1.0 / length(grad) / 1000.0;
				}
				point += gradientMulti * exitMinusEntry;
				if(length(point - entry_point.xyz) >= dist) break;
			}
			else
			{
				point += diff;
			
				if(i >= maxiter)
				{
					break;	
				}	
			}		
		}
		result.xyz = transferred_max.w * transferred_max.xyz;
		result.w = transferred_max.w;	
		
		gl_FragColor = result;
	}	
}

void raycasting_first() {
	const int maxrange = 347;
	
	vec4 entry_point = texture2DRect(tex_entry, gl_FragCoord.xy);
	vec4 exit_point = texture2DRect(tex_exit, gl_FragCoord.xy);
	
	vec3 point = entry_point.xyz;
	vec4 intensity = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 transferred = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 result = vec4(0.0, 0.0, 0.0, 0.0);
	
	float gradientMulti;
	vec3 grad;
	
	float dist = distance(entry_point, exit_point);
	float distPerStep = dist / dz;
	int maxiter = int(floor(distPerStep));
	vec3 exitMinusEntry = exit_point.xyz - entry_point.xyz;
	vec3 diff = exitMinusEntry / distPerStep;
	
	if(entry_point.w == 0.0) 
	{ 
		discard;
	}
	else
	{
		float numSamples = 0.0;
		for(int i = 0; i < maxrange; i++)
		{	
			intensity = texture3D(tex_intensity, point.xyz);
			transferred = texture1D(tex_transfer, intensity.x);	
			
			if(intensity.x > isoValue) break;
			
			if(stepmode == 0) // adaptive stepsize enabled
			{	
				grad = texture3D(tex_gradients, point.xyz).xyz;
				grad = (grad * 2.0) - 1.0; // transform gradients from [0...1] into real dimensions
				grad = vec3(gl_NormalMatrix * grad);
				if((length(grad) >= 0.0) && (length(grad) <= 0.03)) 
				{ 
					gradientMulti = 0.005;
				}
				else  
				{ 
					gradientMulti = 1.0 / length(grad) / 1000.0;
				}
				point += gradientMulti * exitMinusEntry;
			}
			else
			{
				point += diff;
			}
		}
		result.xyz = transferred.w * transferred.xyz;
		result.w = transferred.w;	
		
		gl_FragColor = result;
	}	
}

void slicing() 
{
	vec3 intensity = texture3D(tex_intensity, gl_TexCoord[0].stp).xyz;
	if(applytransfer == 0) 
	{
		gl_FragColor = vec4(intensity.x, intensity.y, intensity.z, 1.0);
	}
	else 
	{
		gl_FragColor = texture1D(tex_transfer, intensity.x);
	} 
}

void postprocessing() {
	// apply a 3x3 gaussschen filter
	// texture coordinates of a 2DRect-Texture are not normalized!
	gl_FragColor =	(texture2DRect(tex_postprocessing, vec2(gl_TexCoord[5].s - 1.0, gl_TexCoord[5].t + 1.0)) + 
					2.0 * texture2DRect(tex_postprocessing, vec2(gl_TexCoord[5].s, gl_TexCoord[5].t + 1.0)) + 
					texture2DRect(tex_postprocessing, vec2(gl_TexCoord[5].s + 1.0, gl_TexCoord[5].t + 1.0)) + 
					2.0 * texture2DRect(tex_postprocessing, vec2(gl_TexCoord[5].s - 1.0, gl_TexCoord[5].t)) +
					4.0 * texture2DRect(tex_postprocessing, vec2(gl_TexCoord[5].s, gl_TexCoord[5].t)) +  
					2.0 * texture2DRect(tex_postprocessing, vec2(gl_TexCoord[5].s + 1.0, gl_TexCoord[5].t)) + 
					texture2DRect(tex_postprocessing, vec2(gl_TexCoord[5].s + 1.0, gl_TexCoord[5].t + 1.0)) + 
					2.0 * texture2DRect(tex_postprocessing, vec2(gl_TexCoord[5].s, gl_TexCoord[5].t - 1.0)) + 
					texture2DRect(tex_postprocessing, vec2(gl_TexCoord[5].s + 1.0, gl_TexCoord[5].t - 1.0))) / 16.0;
		
	//gl_FragColor = texture2DRect(tex_test, gl_TexCoord[5].st);
}

void main()
{	
	if(renderpass == 1) // direction texture
	{
		gl_FragColor = vec4(gl_TexCoord[0].x, gl_TexCoord[0].y, gl_TexCoord[0].z, 1.0);
	}
	else if(renderpass == 3) // postprocessing
	{	
		postprocessing();
	}
	else
	{
		if(modi == 0) // slicing
		{ 
			slicing();
		}
		else // raycasting
		{
			if(rendermode == 0) 
			{
				raycasting_comp();
			}
			else if(rendermode == 1)
			{
				raycasting_avg();
			}
			else if(rendermode == 2)
			{
				raycasting_mip();
			}
			else if(rendermode == 3)
			{
				raycasting_first();
			}
		}
	}
}