/*
 * Decompiled with CFR 0.152.
 */
package flowvis;

import flowvis.Canvas;
import flowvis.GridStore;
import flowvis.Vector;
import java.awt.Graphics;
import java.io.IOException;

public class Streamlines {
    protected GridStore gs;
    protected Canvas canvas;
    protected int xStep;
    protected int yStep;

    public Streamlines(GridStore gs, Canvas canvas) {
        this.gs = gs;
        this.canvas = canvas;
        this.xStep = 1;
        this.yStep = 1;
    }

    public void setStepSizes(int xStep, int yStep) {
        this.xStep = xStep;
        this.yStep = yStep;
    }

    public Vector getCoordinates(int x, int y, int z) throws IOException {
        return new Vector(this.gs.getCoordinate(x, y, z, 0), this.gs.getCoordinate(x, y, z, 1), this.gs.getCoordinate(x, y, z, 2));
    }

    public Vector[] getCellPoints(int x, int y, int z) throws IOException {
        Vector[] p = new Vector[]{this.getCoordinates(x, y, z), this.getCoordinates(x + this.xStep, y, z), this.getCoordinates(x + this.xStep, y + this.yStep, z), this.getCoordinates(x, y + this.yStep, z)};
        return p;
    }

    public Vector[] getEdgeVectors(int x, int y, int z, Vector[] cellPoints) {
        Vector[] v = new Vector[cellPoints.length];
        int i = 0;
        while (i < cellPoints.length) {
            Vector a = cellPoints[i];
            Vector b = i < cellPoints.length - 1 ? cellPoints[i + 1] : cellPoints[0];
            v[i] = new Vector(b.x - a.x, b.y - a.y, b.z - a.z);
            ++i;
        }
        return v;
    }

    public Vector[] getCellVectors(int x, int y, int z) throws IOException {
        Vector[] p = new Vector[]{this.getVector(x, y, z), this.getVector(x + this.xStep, y, z), this.getVector(x + this.xStep, y + this.yStep, z), this.getVector(x, y + this.yStep, z)};
        return p;
    }

    public Vector getCenter(int x, int y, int z) throws IOException {
        Vector[] p = this.getCellPoints(x, y, z);
        return new Vector((p[0].x + p[1].x + p[2].x + p[3].x) / 4.0f, (p[0].y + p[1].y + p[2].y + p[3].y) / 4.0f, (p[0].z + p[1].z + p[2].z + p[3].z) / 4.0f);
    }

    public Vector getVector(int x, int y, int z) throws IOException {
        return new Vector(this.gs.getVector(x, y, z, 0), this.gs.getVector(x, y, z, 1), this.gs.getVector(x, y, z, 2));
    }

    public static Vector intersectXY(Vector p0, Vector v0, Vector p1, Vector v1) {
        float s;
        float d = v0.x * v1.y - v0.y * v1.x;
        if (d < 0.001f) {
            d = v0.y * v1.x - v0.x * v1.y;
            s = (p0.x - p1.x) * v1.y + (p1.y - p0.y) * v1.x;
        } else {
            s = (p0.y - p1.y) * v1.x + (p1.x - p0.x) * v1.y;
        }
        return new Vector(p0.x + (s /= d) * v0.x, p0.y + s * v0.y, 0.0f);
    }

    public Vector interpolate(int x, int y, int z, Vector pos) throws IOException {
        Vector[] p = this.getCellPoints(x, y, z);
        Vector[] v = this.getCellVectors(x, y, z);
        if (this.gs.xyexchanged) {
            float y0 = this.canvas.getWindowY((p[0].y + p[3].y) / 2.0f);
            float y1 = this.canvas.getWindowY((p[1].y + p[2].y) / 2.0f);
            float dy = Math.abs(y1 - y0);
            float dy0 = Math.abs(pos.y - y0);
            float wb = dy > 0.0f ? dy0 / dy : 0.5f;
            float wa = 1.0f - wb;
            Vector a = v[0];
            Vector b = v[1];
            Vector vi01 = new Vector(a.x * wa + b.x * wb, a.y * wa + b.y * wb, a.z * wa + b.z * wb);
            a = v[3];
            b = v[2];
            Vector vi32 = new Vector(a.x * wa + b.x * wb, a.y * wa + b.y * wb, a.z * wa + b.z * wb);
            float x0 = this.canvas.getWindowX((p[0].y + p[1].y) / 2.0f);
            float x1 = this.canvas.getWindowX((p[3].y + p[2].y) / 2.0f);
            float dx = Math.abs(x1 - x0);
            float dx0 = Math.abs(pos.x - x0);
            wb = dx > 0.0f ? dx0 / dx : 0.0f;
            wa = 1.0f - wb;
            a = vi01;
            b = vi32;
            return new Vector(a.x * wa + b.x * wb, a.y * wa + b.y * wb, a.z * wa + b.z * wb);
        }
        float x0 = this.canvas.getWindowX((p[0].x + p[3].x) / 2.0f);
        float x1 = this.canvas.getWindowX((p[1].x + p[2].x) / 2.0f);
        float dx = Math.abs(x1 - x0);
        float dx0 = Math.abs(pos.x - x0);
        float wb = dx > 0.0f ? dx0 / dx : 0.5f;
        float wa = 1.0f - wb;
        Vector a = v[0];
        Vector b = v[1];
        Vector vi01 = new Vector(a.x * wa + b.x * wb, a.y * wa + b.y * wb, a.z * wa + b.z * wb);
        a = v[3];
        b = v[2];
        Vector vi32 = new Vector(a.x * wa + b.x * wb, a.y * wa + b.y * wb, a.z * wa + b.z * wb);
        float y0 = this.canvas.getWindowY((p[0].y + p[1].y) / 2.0f);
        float y1 = this.canvas.getWindowY((p[3].y + p[2].y) / 2.0f);
        float dy = Math.abs(y1 - y0);
        float dy0 = Math.abs(pos.y - y0);
        wb = dy > 0.0f ? dy0 / dx : 0.0f;
        wa = 1.0f - wb;
        a = vi01;
        b = vi32;
        return new Vector(a.x * wa + b.x * wb, a.y * wa + b.y * wb, a.z * wa + b.z * wb);
    }

    public Vector getCell(int x, int y, int z, Vector p, Vector v) throws IOException {
        Vector[] cellPoints = this.getCellPoints(x, y, z);
        Vector[] edgeVectors = this.getEdgeVectors(x, y, z, cellPoints);
        float dmin = Float.MAX_VALUE;
        int isect = -1;
        int i = 0;
        while (i < cellPoints.length) {
            float dy;
            float dx;
            float d;
            Vector cellPoint = cellPoints[i];
            Vector windowCellPoint = new Vector(this.canvas.getWindowX(cellPoint.x), this.canvas.getWindowY(cellPoint.y), 0.0f);
            Vector pi = Streamlines.intersectXY(p, v, windowCellPoint, edgeVectors[i]);
            Vector ppi = new Vector(pi.x - p.x, pi.y - p.y, pi.z - p.z);
            if (!(v.x > 0.0f && pi.x < p.x || v.x < 0.0f && pi.x > p.x || v.y > 0.0f && pi.y < p.y || v.y < 0.0f && pi.y > p.y || !((d = (dx = pi.x - p.x) * dx + (dy = pi.y - p.y) * dy) < dmin))) {
                dmin = d;
                isect = i;
            }
            ++i;
        }
        boolean isectXlo = true;
        int i2 = 0;
        while (i2 < cellPoints.length) {
            if (p.x + v.x >= (float)this.canvas.getWindowX(cellPoints[i2].x)) {
                isectXlo = false;
            }
            ++i2;
        }
        boolean isectXhi = true;
        int i3 = 0;
        while (i3 < cellPoints.length) {
            if (p.x + v.x <= (float)this.canvas.getWindowX(cellPoints[i3].x)) {
                isectXhi = false;
            }
            ++i3;
        }
        boolean isectYlo = true;
        int i4 = 0;
        while (i4 < cellPoints.length) {
            if (p.y + v.y >= (float)this.canvas.getWindowY(cellPoints[i4].y)) {
                isectYlo = false;
            }
            ++i4;
        }
        boolean isectYhi = true;
        int i5 = 0;
        while (i5 < cellPoints.length) {
            if (p.y + v.y <= (float)this.canvas.getWindowY(cellPoints[i5].y)) {
                isectYhi = false;
            }
            ++i5;
        }
        if (this.gs.xyexchanged) {
            if (isectXlo) {
                y -= this.yStep;
            }
            if (isectXhi) {
                y += this.yStep;
            }
            if (isectYlo) {
                x -= this.xStep;
            }
            if (isectYhi) {
                x += this.xStep;
            }
        } else {
            if (isectXlo) {
                x -= this.xStep;
            }
            if (isectXhi) {
                x += this.xStep;
            }
            if (isectYlo) {
                y -= this.yStep;
            }
            if (isectYhi) {
                y += this.yStep;
            }
        }
        return new Vector(x, y, z);
    }

    public Vector getVectorAtHalfEuler(int x, int y, int z, Vector p, Vector v) throws IOException {
        Vector cell = this.getCell(x, y, z, p, new Vector(v.x / 2.0f, v.y / 2.0f, v.z / 2.0f));
        Vector pos = new Vector(p.x + v.x, p.y + v.y, p.z + v.z);
        return this.interpolate((int)cell.x, (int)cell.y, (int)cell.z, pos);
    }

    public void calculate(int x, int y, int z, Vector[][] streamlines, java.util.Vector<Vector> vectors, java.util.Vector<Float> thicknesses, Vector pos, boolean invert, Graphics g) throws IOException {
        try {
            while (true) {
                float t;
                float d;
                int j;
                double len;
                float thickness = 1.0f;
                Vector vi = this.interpolate(x, y, z, pos);
                if (this.canvas.layers[2][1] == 1) {
                    vi = this.getVectorAtHalfEuler(x, y, z, pos, vi);
                }
                if ((len = Math.sqrt(vi.x * vi.x + vi.y * vi.y + vi.z * vi.z)) != 0.0) {
                    vi.x = (float)((double)vi.x * ((double)this.canvas.vlen / len));
                    vi.y = (float)((double)vi.y * ((double)this.canvas.vlen / len));
                    vi.z = (float)((double)vi.z * ((double)this.canvas.vlen / len));
                }
                Vector cell = this.getCell(x, y, z, pos, vi);
                pos = invert ? new Vector(pos.x - vi.x, pos.y - vi.y, pos.z - vi.z) : new Vector(pos.x + vi.x, pos.y + vi.y, pos.z + vi.z);
                int j2 = 0;
                while (j2 < streamlines.length) {
                    float d2 = this.getMinDistance2(streamlines[j2], pos);
                    if (d2 < (float)this.canvas.dsep) {
                        float t2 = (float)((Math.sqrt(d2) - Math.sqrt(this.canvas.dtest)) / (Math.sqrt(this.canvas.dsep) - Math.sqrt(this.canvas.dtest)));
                        if (t2 < thickness) {
                            thickness = t2;
                        }
                        if (d2 < (float)this.canvas.dtest) {
                            return;
                        }
                    }
                    ++j2;
                }
                int dtest = this.canvas.dtest < 81 ? 81 : this.canvas.dtest;
                if (invert) {
                    j = 5;
                    while (j < vectors.size()) {
                        d = this.getDistance2(vectors.get(j), pos);
                        if (d < (float)this.canvas.dsep) {
                            t = (float)((Math.sqrt(d) - Math.sqrt(this.canvas.dtest)) / (Math.sqrt(this.canvas.dsep) - Math.sqrt(this.canvas.dtest)));
                            if (t < thickness) {
                                thickness = t;
                            }
                            if (d < (float)dtest) {
                                return;
                            }
                        }
                        ++j;
                    }
                    vectors.add(0, pos);
                    thicknesses.add(0, Float.valueOf(thickness));
                } else {
                    j = 0;
                    while (j < vectors.size() - 5) {
                        d = this.getDistance2(vectors.get(j), pos);
                        if (d < (float)this.canvas.dsep) {
                            t = (float)((Math.sqrt(d) - Math.sqrt(this.canvas.dtest)) / (Math.sqrt(this.canvas.dsep) - Math.sqrt(this.canvas.dtest)));
                            if (t < thickness) {
                                thickness = t;
                            }
                            if (d < (float)dtest) {
                                return;
                            }
                        }
                        ++j;
                    }
                    vectors.add(pos);
                    thicknesses.add(Float.valueOf(thickness));
                }
                x = (int)cell.x;
                y = (int)cell.y;
                z = (int)cell.z;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
    }

    public void calculate(java.util.Vector<Vector> vectors, java.util.Vector<Float> thicknesses, int x, int y, int z, Graphics g, Vector[][] streamlines) throws IOException {
        Vector vc = this.getCenter(x, y, 0);
        int xc = this.canvas.getWindowX(vc.x);
        int yc = this.canvas.getWindowY(vc.y);
        Vector pos = new Vector(xc, yc, 0.0f);
        int i = 0;
        while (i < streamlines.length) {
            float d = this.getMinDistance2(streamlines[i], pos);
            if (d < (float)this.canvas.dsep) {
                return;
            }
            ++i;
        }
        vectors.add(pos);
        thicknesses.add(Float.valueOf(1.0f));
        this.calculate(x, y, z, streamlines, vectors, thicknesses, pos, false, g);
        this.calculate(x, y, z, streamlines, vectors, thicknesses, pos, true, g);
    }

    public float getDistance2(Vector a, Vector b) {
        float dx = b.x - a.x;
        float dy = b.y - a.y;
        return dx * dx + dy * dy;
    }

    public float getMinDistance2(Vector[] points, Vector point) {
        float min = Float.MAX_VALUE;
        int i = 0;
        while (i < points.length) {
            float d2 = this.getDistance2(points[i], point);
            if (d2 < min) {
                min = d2;
            }
            ++i;
        }
        return min;
    }
}

