/*
 * Decompiled with CFR 0.152.
 */
package flowvis;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class GridStore {
    public static final int DATATYPE_GRID = 1;
    public static final int DATATYPE_VECTORS = 2;
    protected int xSize;
    protected int ySize;
    protected int zSize;
    protected int numberOfAdditionalSets = -1;
    protected int numberOfTimesteps = -1;
    protected float timestepSize = -1.0f;
    protected byte[] gridData;
    protected DataInputStream gridDataInputStream;
    protected byte[] vectorData;
    protected DataInputStream vectorDataInputStream;
    protected float[] min = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] max = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] minValues = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    protected float[] maxValues = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    protected float maxVectorLength = 0.0f;
    protected boolean xyexchanged = false;

    public static void swapFloats(byte[] data) {
        int i = 0;
        while (i < data.length) {
            byte tmp0 = data[i];
            data[i] = data[i + 3];
            data[i + 3] = tmp0;
            byte tmp1 = data[i + 1];
            data[i + 1] = data[i + 2];
            data[i + 2] = tmp1;
            i += 4;
        }
    }

    protected float getMin(int index) throws IOException {
        float min = Float.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.zSize) {
            int j = 0;
            while (j < this.ySize) {
                int k = 0;
                while (k < this.xSize) {
                    float coord = this.getCoordinate(k, j, i, index);
                    if (coord < min) {
                        min = coord;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    protected float getMax(int index) throws IOException {
        float max = Float.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.zSize) {
            int j = 0;
            while (j < this.ySize) {
                int k = 0;
                while (k < this.xSize) {
                    float coord = this.getCoordinate(k, j, i, index);
                    if (coord > max) {
                        max = coord;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    protected float getMinValue(int index) throws IOException {
        float min = Float.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.zSize) {
            int j = 0;
            while (j < this.ySize) {
                int k = 0;
                while (k < this.xSize) {
                    float value = this.getVector(k, j, i, index);
                    if (value < min) {
                        min = value;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    protected float getMaxValue(int index) throws IOException {
        float max = Float.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.zSize) {
            int j = 0;
            while (j < this.ySize) {
                int k = 0;
                while (k < this.xSize) {
                    float value = this.getVector(k, j, i, index);
                    if (value > max) {
                        max = value;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    public void loadGrid(String filename) throws IOException {
        int ret;
        int ret2;
        BufferedReader br = new BufferedReader(new FileReader(filename));
        char[] cbuf = new char[40];
        int n = 0;
        while ((ret2 = br.read(cbuf, n, cbuf.length - n)) >= 1 && (n += ret2) < cbuf.length) {
        }
        br.close();
        String header = new String(cbuf);
        StringTokenizer st = new StringTokenizer(header, "\u0000 ,");
        if (!"SN4DB".equals(st.nextToken())) {
            return;
        }
        this.xSize = Integer.parseInt(st.nextToken());
        this.ySize = Integer.parseInt(st.nextToken());
        this.zSize = Integer.parseInt(st.nextToken());
        this.numberOfAdditionalSets = Integer.parseInt(st.nextToken());
        this.numberOfTimesteps = Integer.parseInt(st.nextToken());
        this.timestepSize = Float.parseFloat(st.nextToken());
        System.out.println("xsize " + this.xSize);
        System.out.println("ysize " + this.ySize);
        System.out.println("zsize " + this.zSize);
        System.out.println("numberOfAdditionalSets " + this.numberOfAdditionalSets);
        System.out.println("numberOfTimesteps " + this.numberOfTimesteps);
        System.out.println("timestepSize " + this.timestepSize);
        this.gridData = new byte[40 + this.xSize * this.ySize * this.zSize * 12];
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(filename));
        n = 0;
        while ((ret = bis.read(this.gridData, n, this.gridData.length - n)) >= 1 && (n += ret) < this.gridData.length) {
        }
        bis.close();
        this.gridDataInputStream = new DataInputStream(new ByteArrayInputStream(this.gridData));
    }

    public void loadGrid(String filename, boolean swapFloats) throws IOException {
        this.loadGrid(filename);
        if (swapFloats) {
            GridStore.swapFloats(this.gridData);
        }
        int i = 0;
        while (i < this.min.length) {
            this.min[i] = this.getMin(i);
            this.max[i] = this.getMax(i);
            ++i;
        }
    }

    public void loadVectors(String filename) throws IOException {
        int ret;
        if (this.numberOfAdditionalSets < 0 || this.numberOfTimesteps < 0 || this.timestepSize < 0.0f) {
            return;
        }
        this.vectorData = new byte[40 + this.xSize * this.ySize * this.zSize * (12 + 4 * this.numberOfAdditionalSets)];
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(filename));
        int n = 0;
        while ((ret = bis.read(this.vectorData, n, this.vectorData.length - n)) >= 1 && (n += ret) < this.vectorData.length) {
        }
        bis.close();
        this.vectorDataInputStream = new DataInputStream(new ByteArrayInputStream(this.vectorData));
    }

    public synchronized void loadVectors(String filename, boolean swapFloats) throws IOException {
        this.loadVectors(filename);
        if (swapFloats) {
            GridStore.swapFloats(this.vectorData);
        }
        int i = 0;
        while (i < this.minValues.length) {
            this.minValues[i] = this.getMinValue(i);
            this.maxValues[i] = this.getMaxValue(i);
            ++i;
        }
    }

    public float getCoordinate(int x, int y, int z, int index) throws IOException {
        if (x < 0 || x >= this.xSize) {
            throw new IndexOutOfBoundsException("x index out of bounds");
        }
        if (y < 0 || y >= this.ySize) {
            throw new IndexOutOfBoundsException("y index out of bounds");
        }
        if (z < 0 || z >= this.zSize) {
            throw new IndexOutOfBoundsException("z index out of bounds");
        }
        int pos = 40 + z * this.ySize * this.xSize * 12 + y * this.xSize * 12 + x * 12 + index * 4;
        this.gridDataInputStream.reset();
        int n = 0;
        while ((n += this.gridDataInputStream.skipBytes(pos - n)) < pos) {
        }
        return this.gridDataInputStream.readFloat();
    }

    public synchronized float getVector(int x, int y, int z, int index) throws IOException {
        if (this.numberOfAdditionalSets < 0 || this.numberOfTimesteps < 0 || this.timestepSize < 0.0f) {
            return 0.0f;
        }
        if (x < 0 || x >= this.xSize) {
            throw new IndexOutOfBoundsException("x index out of bounds");
        }
        if (y < 0 || y >= this.ySize) {
            throw new IndexOutOfBoundsException("y index out of bounds");
        }
        if (z < 0 || z >= this.zSize) {
            throw new IndexOutOfBoundsException("z index out of bounds");
        }
        int recordSize = 12 + 4 * this.numberOfAdditionalSets;
        int pos = z * this.ySize * this.xSize * recordSize + y * this.xSize * recordSize + x * recordSize + index * 4;
        this.vectorDataInputStream.reset();
        int n = 0;
        while ((n += this.vectorDataInputStream.skipBytes(pos - n)) < pos) {
        }
        return this.vectorDataInputStream.readFloat();
    }
}

