/*
 * Decompiled with CFR 0.152.
 */
package flowvis;

import flowvis.Canvas;
import flowvis.ControlPanel;
import flowvis.GridStore;
import flowvis.Streamlines;
import flowvis.Vector;
import flowvis.WindowClosingAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JFrame;

public class FlowVis
extends JFrame {
    protected GridStore gs;
    protected Streamlines sl;

    public FlowVis() throws IOException {
        super("FlowVis");
        Container cp = this.getContentPane();
        this.gs = new GridStore();
        Canvas canvas = new Canvas(this.gs);
        cp.setLayout(new BorderLayout());
        cp.add((Component)new ControlPanel(this.gs, canvas), "West");
        cp.add((Component)canvas, "Center");
        this.sl = new Streamlines(this.gs, canvas);
    }

    public static void main(String[] args) throws IOException {
        Vector p0 = new Vector(6.0f, 0.0f, 0.0f);
        Vector v0 = new Vector(-2.0f, 0.0f, 0.0f);
        Vector p1 = new Vector(3.0f, -2.0f, 0.0f);
        Vector v1 = new Vector(0.25f, 1.0f, 0.0f);
        Vector result = Streamlines.intersectXY(p0, v0, p1, v1);
        System.out.println(String.valueOf(result.x) + "; " + result.y);
        FlowVis wnd = new FlowVis();
        wnd.addWindowListener(new WindowClosingAdapter());
        Dimension scrsize = wnd.getToolkit().getScreenSize();
        int w = 600;
        int h = 400;
        wnd.setSize(w, h);
        wnd.setLocation((scrsize.width - w) / 2, (scrsize.height - h) / 2);
        wnd.setVisible(true);
    }
}

