/*
 * Decompiled with CFR 0.152.
 */
package flowvis;

import flowvis.Canvas;
import flowvis.GridStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ControlPanel
extends JPanel {
    protected Thread reloadThread = null;

    public ControlPanel(final GridStore gs, final Canvas canvas) {
        JPanel panel;
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.add((Component)buttonPanel, "North");
        GridBagConstraints gc = new GridBagConstraints();
        JPanel filePanel = new JPanel(new BorderLayout());
        filePanel.add((Component)new JLabel("data set:"), "North");
        System.out.println(new File("data").list()[0]);
        String[] files = new File("data").list();
        Vector<String> fileVector = new Vector<String>();
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            if (!file.startsWith(".")) {
                fileVector.add(file);
            }
            ++i;
        }
        final JList<Object> fileList = new JList<Object>(fileVector.toArray());
        fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (arg0.getValueIsAdjusting()) {
                    return;
                }
                String basename = fileList.getSelectedValue().toString();
                gs.xyexchanged = false;
                if ("hurricane_p_tc_singletime10".equals(basename)) {
                    gs.xyexchanged = true;
                }
                final String dir = "data/" + basename;
                String basepath = String.valueOf(dir) + "/" + basename;
                Object[] filenames = new File(dir).list();
                Arrays.sort(filenames);
                try {
                    if (ControlPanel.this.reloadThread != null) {
                        try {
                            ControlPanel.this.reloadThread.interrupt();
                            System.out.println("waiting for thread...");
                            ControlPanel.this.reloadThread.join();
                            System.out.println("prev thread killed");
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ControlPanel.this.reloadThread = null;
                    }
                    gs.loadGrid(String.valueOf(basepath) + ".gri", true);
                    final Vector<Object> v = new Vector<Object>();
                    int i = 0;
                    while (i < filenames.length) {
                        Object filename = filenames[i];
                        if (((String)filename).endsWith(".dat")) {
                            v.add(filename);
                        }
                        ++i;
                    }
                    if (v.size() < 1) {
                        return;
                    }
                    if (v.size() > 1) {
                        ControlPanel.this.reloadThread = new Thread(){

                            @Override
                            public void run() {
                                while (!this.isInterrupted()) {
                                    int i = 0;
                                    while (i < v.size()) {
                                        try {
                                            gs.loadVectors(String.valueOf(dir) + "/" + (String)v.get(i), true);
                                            SwingUtilities.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    canvas.repaint();
                                                }
                                            });
                                            Thread.sleep(50L);
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                        catch (InterruptedException e) {
                                            this.interrupt();
                                        }
                                        ++i;
                                    }
                                }
                            }
                        };
                        ControlPanel.this.reloadThread.start();
                    } else {
                        gs.loadVectors(String.valueOf(dir) + "/" + (String)v.get(0), true);
                        canvas.repaint();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        filePanel.add((Component)new JScrollPane(fileList), "Center");
        gc.gridy = 0;
        gc.insets = new Insets(4, 4, 8, 8);
        gc.fill = 2;
        buttonPanel.add((Component)filePanel, gc);
        JPanel layerPanel = new JPanel(new GridLayout(0, 5));
        String[][] layerNames = new String[][]{{"vectors"}, {"pressure"}, {"streamlines", "o:euler|runge-kutta", "o:straight|tapering|glyphs|texture"}};
        int i2 = 0;
        while (i2 < layerNames.length) {
            final int ii = i2;
            String[] controlTexts = layerNames[i2];
            canvas.layers[i2] = new int[controlTexts.length];
            final JCheckBox cb = new JCheckBox(controlTexts[0], i2 == 0);
            if (i2 == 0) {
                canvas.layers[ii][0] = 1;
            }
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    canvas.layers[ii][0] = cb.isSelected() ? 1 : 0;
                    canvas.repaint();
                }
            });
            panel = new JPanel(new BorderLayout());
            panel.add((Component)cb, "North");
            layerPanel.add(panel);
            int j = 1;
            while (j < controlTexts.length) {
                final int jj = j;
                String text = controlTexts[j];
                String[] parts = text.split("[:]");
                if ("o".equals(parts[0])) {
                    JPanel optionPanel = new JPanel(new GridLayout(0, 1));
                    parts = parts[1].split("[|]");
                    ButtonGroup bg = new ButtonGroup();
                    int k = 0;
                    while (k < parts.length) {
                        final int kk = k;
                        System.out.println(parts[k]);
                        JRadioButton rb = new JRadioButton(parts[k], k == 0);
                        rb.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                canvas.layers[ii][jj] = kk;
                                canvas.repaint();
                            }
                        });
                        bg.add(rb);
                        optionPanel.add(rb);
                        ++k;
                    }
                    panel = new JPanel(new BorderLayout());
                    panel.add((Component)optionPanel, "North");
                    layerPanel.add(panel);
                }
                ++j;
            }
            j = 0;
            while (j < 5 - controlTexts.length) {
                layerPanel.add(new JLabel());
                ++j;
            }
            ++i2;
        }
        gc.gridy = 1;
        buttonPanel.add((Component)layerPanel, gc);
        JPanel vectorPanel = new JPanel(new BorderLayout());
        vectorPanel.add((Component)new JLabel("flow vector control:"), "North");
        JPanel vectorControlPanel = new JPanel(new GridLayout(0, 1));
        final JLabel vectorLengthLabel = new JLabel();
        final JSlider vectorLengthSlider = new JSlider();
        vectorLengthSlider.setMinimum(0);
        vectorLengthSlider.setMaximum(100);
        vectorLengthSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                canvas.vlen = vectorLengthSlider.getValue();
                vectorLengthLabel.setText("length = " + canvas.vlen);
            }
        });
        vectorLengthSlider.setValue((int)canvas.vlen);
        vectorControlPanel.add(vectorLengthLabel);
        vectorControlPanel.add(vectorLengthSlider);
        panel = new JPanel(new BorderLayout());
        panel.add((Component)vectorControlPanel, "West");
        vectorPanel.add((Component)panel, "Center");
        gc.gridy = 2;
        buttonPanel.add((Component)vectorPanel, gc);
        JPanel streamlinePanel = new JPanel(new BorderLayout());
        streamlinePanel.add((Component)new JLabel("streamline control:"), "North");
        JPanel streamlineSepControlPanel = new JPanel(new GridLayout(0, 1));
        final JLabel dsepLabel = new JLabel();
        final JLabel dtestLabel = new JLabel();
        final JSlider dsepSlider = new JSlider();
        dsepSlider.setMinimum(0);
        dsepSlider.setMaximum(100);
        dsepSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = dsepSlider.getValue();
                canvas.dsep = value * value;
                dsepLabel.setText("dsep = " + value);
            }
        });
        dsepSlider.setValue((int)Math.sqrt(canvas.dsep));
        streamlineSepControlPanel.add(dsepLabel);
        streamlineSepControlPanel.add(dsepSlider);
        final JSlider dtestSlider = new JSlider();
        dtestSlider.setMinimum(0);
        dtestSlider.setMaximum(100);
        dtestSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = dtestSlider.getValue();
                canvas.dtest = value * value;
                dtestLabel.setText("dtest = " + value);
            }
        });
        dtestSlider.setValue((int)Math.sqrt(canvas.dtest));
        streamlineSepControlPanel.add(dtestLabel);
        streamlineSepControlPanel.add(dtestSlider);
        panel = new JPanel(new BorderLayout());
        panel.add((Component)streamlineSepControlPanel, "West");
        streamlinePanel.add((Component)panel, "Center");
        gc.gridy = 3;
        buttonPanel.add((Component)streamlinePanel, gc);
        JButton updateButton = new JButton("update");
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                canvas.repaint();
            }
        });
        gc.gridy = 4;
        gc.fill = 0;
        buttonPanel.add((Component)updateButton, gc);
    }
}

