/*
 * Decompiled with CFR 0.152.
 */
package flowvis;

import flowvis.GridStore;
import flowvis.Streamlines;
import flowvis.Textures;
import flowvis.Vector;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import javax.swing.JComponent;

public class Canvas
extends JComponent {
    public static final int GLYPH_ARROW = 1;
    public static final int GLYPH_FILLED_ARROW = 2;
    protected GridStore gs;
    protected Textures textures;
    protected int textureIndex;
    protected int[][] layers;
    protected int dsep;
    protected int dtest;
    protected float vlen;

    public Canvas(GridStore gs) {
        this.gs = gs;
        this.textures = null;
        this.textureIndex = 0;
        this.layers = new int[3][];
        this.dsep = 324;
        this.dtest = 144;
        this.vlen = 4.0f;
    }

    public int getWindowCoord(int index, float coord, boolean offsets) {
        float gh;
        float gw;
        float w = this.getWidth();
        if (w == 0.0f) {
            return 0;
        }
        float h = this.getHeight();
        float gsminx = this.gs.min[0];
        float gsmaxx = this.gs.max[0];
        float gsminy = this.gs.min[1];
        float gsmaxy = this.gs.max[1];
        float gsw = gsmaxx - gsminx;
        float gsh = gsmaxy - gsminy;
        float xo = 0.0f;
        float yo = 0.0f;
        if (gsh / gsw < h / w) {
            gw = w - 10.0f;
            gh = h * gsh / gsw - 10.0f;
            if (offsets) {
                xo = 5.0f;
                yo = (h - gh) / 2.0f;
            }
        } else {
            gw = w * gsw / gsh - 10.0f;
            gh = h - 10.0f;
            if (offsets) {
                xo = (w - gw) / 2.0f;
                yo = 5.0f;
            }
        }
        if (index == 0) {
            return (int)(xo + (coord - gsminx) * gw / (gsmaxx - gsminx));
        }
        if (index == 1) {
            return (int)(yo + (coord - gsminy) * gh / (gsmaxy - gsminy));
        }
        return 0;
    }

    public int getWindowX(float x) {
        return this.getWindowCoord(0, x, true);
    }

    public int getWindowY(float y) {
        return this.getWindowCoord(1, y, true);
    }

    public int getTextureX(float x) {
        return this.getWindowCoord(0, x, false);
    }

    public int getTextureY(float y) {
        return this.getWindowCoord(1, y, false);
    }

    public int getXStep() {
        float w = this.getWidth();
        return (int)(10000.0f / w);
    }

    public int getYStep() {
        float h = this.getHeight();
        return (int)(10000.0f / h);
    }

    public void drawGlyph(Graphics g, float x0, float y0, float x1, float y1, int type) {
        float dx = x1 - x0;
        float dy = y1 - y0;
        float xn = -dy;
        float yn = dx;
        switch (type) {
            case 1: {
                g.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
                g.drawLine((int)x1, (int)y1, (int)(x0 + xn * 0.5f), (int)(y0 + yn * 0.5f));
                break;
            }
            case 2: {
                float f = 0.0f;
                while (f < 0.4f) {
                    float x = x0 + xn * f;
                    float y = y0 + yn * f;
                    g.drawLine((int)x1, (int)y1, (int)x, (int)y);
                    f += 0.1f;
                }
                break;
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        try {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int w = this.getWidth();
            int h = this.getHeight();
            int xStep = this.getXStep();
            int yStep = this.getYStep();
            Streamlines sl = new Streamlines(this.gs, this);
            sl.setStepSizes(xStep, yStep);
            java.util.Vector<Vector[]> streamlines = new java.util.Vector<Vector[]>();
            g.setColor(Color.GRAY);
            g.fillRect(0, 0, w, h);
            g.setColor(Color.BLACK);
            int i = 0;
            while (i < this.gs.ySize) {
                int j = 0;
                while (j < this.gs.xSize) {
                    int x = this.getWindowX(this.gs.getCoordinate(j, i, 0, 0));
                    int y = this.getWindowY(this.gs.getCoordinate(j, i, 0, 1));
                    int xv = (int)(this.gs.getVector(j, i, 0, 0) * this.vlen * 0.2f);
                    int yv = (int)(this.gs.getVector(j, i, 0, 1) * this.vlen * 0.2f);
                    if (this.layers[1][0] == 1) {
                        float pressure = this.gs.getVector(j, i, 0, 3);
                        float min = this.gs.minValues[3];
                        float max = this.gs.maxValues[3];
                        g.setColor(Color.getHSBColor((pressure - min) / (max - min), 1.0f, 1.0f));
                    }
                    if (this.layers[0][0] == 1) {
                        this.drawGlyph(g, x, y, x + xv, y + yv, 1);
                    }
                    if (this.layers[2][0] != 0) {
                        g.setColor(Color.BLACK);
                        try {
                            Vector vc = sl.getCenter(j, i, 0);
                            java.util.Vector<Vector> vectors = new java.util.Vector<Vector>();
                            java.util.Vector<Float> thicknesses = new java.util.Vector<Float>();
                            if (vectors.size() != thicknesses.size()) {
                                System.out.println("<>");
                            }
                            sl.calculate(vectors, thicknesses, j, i, 0, g, (Vector[][])streamlines.toArray((T[])new Vector[0][]));
                            if (vectors.size() > 1) {
                                switch (this.layers[2][2]) {
                                    case 1: {
                                        g2d.setStroke(new BasicStroke(5.0f, 1, 1));
                                        break;
                                    }
                                    case 2: {
                                        g2d.setStroke(new BasicStroke(2.0f, 1, 1));
                                        break;
                                    }
                                    case 3: {
                                        g2d.setStroke(new BasicStroke(3.0f, 1, 1));
                                    }
                                }
                                int ii = 1;
                                while (ii < vectors.size()) {
                                    Vector a = vectors.get(ii - 1);
                                    Vector b = vectors.get(ii);
                                    switch (this.layers[2][2]) {
                                        case 0: {
                                            g2d.drawLine((int)a.x, (int)a.y, (int)b.x, (int)b.y);
                                            break;
                                        }
                                        case 1: {
                                            float t = thicknesses.get(ii).floatValue();
                                            if (t < 1.0f) {
                                                g2d.setStroke(new BasicStroke(t * 5.0f, 1, 1));
                                            }
                                            g2d.drawLine((int)a.x, (int)a.y, (int)b.x, (int)b.y);
                                            if (!(t < 1.0f)) break;
                                            g2d.setStroke(new BasicStroke(5.0f, 1, 1));
                                            break;
                                        }
                                        case 2: {
                                            this.drawGlyph(g, a.x, a.y, b.x, b.y, 2);
                                            break;
                                        }
                                        case 3: {
                                            g.setColor(Color.getHSBColor((float)ii / ((float)vectors.size() - 1.0f), 1.0f, 1.0f));
                                            g2d.drawLine((int)a.x, (int)a.y, (int)b.x, (int)b.y);
                                        }
                                    }
                                    ++ii;
                                }
                                g2d.setStroke(new BasicStroke());
                                streamlines.add(vectors.toArray(new Vector[0]));
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        g.setColor(Color.BLACK);
                    }
                    j += xStep;
                }
                i += yStep;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

