varying vec3 view;
uniform float x;
uniform float y;
varying mat2 rot;

void main(void)
{
	float nx;
	float ny;
	float alpha;
	float pi = 3.141592653;
	
	ny = -y;
	
	nx = x;
	
	alpha = acos(nx);
	
	//quadranten berechnung
	if(ny > 0.0)
		alpha = 2.0 * pi - alpha;
	
	rot = mat2(cos(alpha), -sin(alpha),
	           sin(alpha), cos(alpha));
	
	
	view = vec3(gl_ModelViewMatrix * gl_Vertex);
	gl_TexCoord[1] = gl_MultiTexCoord1;
	gl_TexCoord[0] = gl_MultiTexCoord0;
	gl_TexCoord[2] = gl_MultiTexCoord2;
	gl_Position = ftransform();
}