uniform sampler2D tex;
uniform sampler2D background;
varying vec3 view;
varying mat2 rot;
uniform sampler1D rgb_texture;
uniform sampler1D rgb2_texture;

uniform int render_phase; /* 1 bei sprite und 0 bei bg */

void main()
{
	vec2 lookup;
	vec4 temp;
	vec4 color;
	
	if(render_phase == 1)
	{
		lookup = rot * vec2(gl_TexCoord[1].x - 0.5, gl_TexCoord[1].y - 0.5) + vec2(0.5, 0.5);
		
		if (lookup.x > 1.0)
			lookup.x = 1.0;
		if (lookup.y > 1.0)
			lookup.y = 1.0;
		if (lookup.x < 0.0)
			lookup.x = 0.0;
		if (lookup.y < 0.0)
			lookup.y = 0.0;
		
		color = texture2D(tex, lookup);
	}
	else
	{
		temp = texture2D(background, vec2(gl_TexCoord[0].x, gl_TexCoord[0].y));
		color = texture1D(rgb_texture, temp.x);
	}
	gl_FragColor = color;
}

