/*
 * Decompiled with CFR 0.152.
 */
package gui;

import glcanvas.VisCanvas;
import gui.GradientColorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ParentColorPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -2175027471849474859L;
    private String name;
    private GradientColorPanel gradientColorPanel;
    private JLabel grayValueAlphaLabel;
    private JLabel grayValueColorLabel;
    private JLabel alphaLabel;
    private JLabel colorLabel;
    private JButton applyAlphaButton;
    private JButton applyColorButton;
    private JButton deleteAlphaButton;
    private JButton deleteColorButton;
    private JTextField grayValueAlphaTextField;
    private JTextField grayValueColorTextField;
    private JTextField alphaTextField;
    private JPanel colorPanel;
    private ActionListener listener;
    private JLabel minLabel;
    private JLabel maxLabel;
    private VisCanvas vc = null;

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void setCanvas(VisCanvas vc) {
        this.vc = vc;
    }

    public ParentColorPanel(String name) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(name), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.name = name;
        JPanel helperPanel = new JPanel();
        this.setLayout(new BorderLayout());
        helperPanel.setLayout(new FlowLayout(1));
        helperPanel.setPreferredSize(new Dimension(520, 65));
        this.gradientColorPanel = new GradientColorPanel();
        this.gradientColorPanel.setPreferredSize(new Dimension(520, 100));
        this.gradientColorPanel.addActionListener(this);
        JPanel helperPanel2 = new JPanel();
        helperPanel2.setLayout(new GridLayout(2, 1));
        helperPanel.add(this.gradientColorPanel);
        JPanel helperPanel10 = new JPanel();
        helperPanel10.setLayout(new BorderLayout(10, 0));
        helperPanel10.setPreferredSize(new Dimension(520, 20));
        this.minLabel = new JLabel();
        helperPanel10.add("West", this.minLabel);
        this.maxLabel = new JLabel();
        helperPanel10.add("East", this.maxLabel);
        this.add("North", helperPanel);
        this.add("Center", helperPanel10);
        JPanel helperPanel3 = new JPanel();
        helperPanel3.setPreferredSize(new Dimension(550, 60));
        helperPanel3.setLayout(new GridLayout(2, 3));
        JPanel helperPanel6 = new JPanel();
        helperPanel6.setLayout(new FlowLayout(0));
        this.alphaTextField = new JTextField();
        this.alphaTextField.setPreferredSize(new Dimension(40, 20));
        this.alphaLabel = new JLabel("opaqueness:");
        helperPanel6.add(this.alphaLabel);
        helperPanel6.add(this.alphaTextField);
        helperPanel3.add(helperPanel6);
        JPanel helperPanel4 = new JPanel();
        helperPanel4.setLayout(new FlowLayout(0));
        this.grayValueAlphaTextField = new JTextField();
        this.grayValueAlphaTextField.setPreferredSize(new Dimension(40, 20));
        this.grayValueAlphaLabel = new JLabel("grayvalue:");
        helperPanel4.add(this.grayValueAlphaLabel);
        helperPanel4.add(this.grayValueAlphaTextField);
        helperPanel3.add(helperPanel4);
        JPanel helperPanel8 = new JPanel();
        helperPanel8.setLayout(new FlowLayout(0));
        this.deleteAlphaButton = new JButton("Delete");
        this.deleteAlphaButton.addActionListener(this);
        this.deleteAlphaButton.setActionCommand("delete alpha");
        this.applyAlphaButton = new JButton("Apply");
        helperPanel8.add(this.applyAlphaButton);
        this.applyAlphaButton.addActionListener(this);
        this.applyAlphaButton.setActionCommand("apply alpha");
        helperPanel8.add(this.deleteAlphaButton);
        helperPanel3.add(helperPanel8);
        JPanel helperPanel7 = new JPanel();
        helperPanel7.setLayout(new FlowLayout(0));
        this.colorPanel = new JPanel();
        this.colorPanel.setPreferredSize(new Dimension(40, 20));
        this.colorPanel.setBackground(Color.BLACK);
        this.colorLabel = new JLabel("color:           ");
        helperPanel7.add(this.colorLabel);
        helperPanel7.add(this.colorPanel);
        helperPanel3.add(helperPanel7);
        JPanel helperPanel5 = new JPanel();
        helperPanel5.setLayout(new FlowLayout(0));
        this.grayValueColorTextField = new JTextField();
        this.grayValueColorTextField.setPreferredSize(new Dimension(40, 20));
        this.grayValueColorLabel = new JLabel("grayvalue:");
        helperPanel5.add(this.grayValueColorLabel);
        helperPanel5.add(this.grayValueColorTextField);
        helperPanel3.add(helperPanel5);
        JPanel helperPanel9 = new JPanel();
        helperPanel9.setLayout(new FlowLayout(0));
        this.deleteColorButton = new JButton("Delete");
        this.deleteColorButton.addActionListener(this);
        this.deleteColorButton.setActionCommand("delete color");
        this.applyColorButton = new JButton("Apply");
        this.applyColorButton.addActionListener(this);
        this.applyColorButton.setActionCommand("apply color");
        helperPanel9.add(this.applyColorButton);
        helperPanel9.add(this.deleteColorButton);
        helperPanel3.add(helperPanel9);
        this.add("South", helperPanel3);
        this.enableColor(false);
        this.enableAlpha(false);
    }

    public void setMinLabel(float min) {
        String minStr = String.valueOf(min);
        if (minStr.length() > 5) {
            minStr = minStr.substring(0, 5);
        }
        this.minLabel.setText(minStr);
    }

    public void setMaxLabel(float max) {
        String maxStr = String.valueOf(max);
        if (maxStr.length() > 5) {
            maxStr = maxStr.substring(0, 5);
        }
        this.maxLabel.setText(maxStr);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public GradientColorPanel getGradientColorPanel() {
        return this.gradientColorPanel;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("color deselected")) {
            this.enableColor(false);
        } else if (ae.getActionCommand().equals("color selected")) {
            this.enableColor(true);
        } else if (ae.getActionCommand().equals("alpha deselected")) {
            this.enableAlpha(false);
        } else if (ae.getActionCommand().equals("alpha selected")) {
            this.enableAlpha(true);
        } else if (ae.getActionCommand().equals("apply alpha")) {
            int trValue;
            int grValue = this.getValue(this.grayValueAlphaTextField);
            if (grValue != -1 && (trValue = this.getValue(this.alphaTextField)) != -1) {
                this.gradientColorPanel.setAlpha(grValue, trValue);
            }
        } else if (ae.getActionCommand().equals("apply color")) {
            int grValue = this.getValue(this.grayValueColorTextField);
            if (grValue != -1) {
                this.gradientColorPanel.setColor(grValue);
            }
        } else if (ae.getActionCommand().equals("delete alpha")) {
            this.gradientColorPanel.deleteSelectedAlphaHist();
        } else if (ae.getActionCommand().equals("delete color")) {
            this.gradientColorPanel.deleteSelectedColorHist();
        } else if (ae.getActionCommand().equals("tf changed")) {
            ActionEvent event = new ActionEvent(this, 28, "tf changed");
            this.listener.actionPerformed(event);
        }
    }

    private int getValue(JTextField textField) {
        int value;
        try {
            value = Integer.parseInt(textField.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "You have entered a non-integer value in a color textfield, which only allows integer values.", "Error", 0);
            value = -1;
        }
        return value;
    }

    private void enableColor(boolean enabled) {
        if (enabled) {
            this.grayValueColorLabel.setEnabled(true);
            this.deleteColorButton.setEnabled(true);
            this.grayValueColorTextField.setText(String.valueOf(this.gradientColorPanel.getSelectedGrayValue()));
            this.grayValueColorTextField.setEnabled(true);
            this.colorPanel.setEnabled(true);
            this.colorPanel.setBackground(new Color(this.gradientColorPanel.getSelectedRed(), this.gradientColorPanel.getSelectedGreen(), this.gradientColorPanel.getSelectedBlue()));
            this.colorLabel.setEnabled(true);
            this.applyColorButton.setEnabled(true);
        } else {
            this.grayValueColorLabel.setEnabled(false);
            this.deleteColorButton.setEnabled(false);
            this.grayValueColorTextField.setText("");
            this.grayValueColorTextField.setEnabled(false);
            this.colorPanel.setEnabled(false);
            this.colorPanel.setBackground(Color.LIGHT_GRAY);
            this.colorLabel.setEnabled(false);
            this.applyColorButton.setEnabled(false);
        }
    }

    private void enableAlpha(boolean enabled) {
        if (enabled) {
            this.grayValueAlphaLabel.setEnabled(true);
            this.alphaLabel.setEnabled(true);
            this.deleteAlphaButton.setEnabled(true);
            this.grayValueAlphaTextField.setEnabled(true);
            this.grayValueAlphaTextField.setText(String.valueOf(this.gradientColorPanel.getSelectedAlphaGrayValue()));
            this.alphaTextField.setEnabled(true);
            this.alphaTextField.setText(String.valueOf(this.gradientColorPanel.getSelectedAlphaTransparency()));
            this.applyAlphaButton.setEnabled(true);
        } else {
            this.grayValueAlphaLabel.setEnabled(false);
            this.alphaLabel.setEnabled(false);
            this.deleteAlphaButton.setEnabled(false);
            this.grayValueAlphaTextField.setEnabled(false);
            this.grayValueAlphaTextField.setText("");
            this.alphaTextField.setEnabled(false);
            this.alphaTextField.setText("");
            this.applyAlphaButton.setEnabled(false);
        }
    }
}

