/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.sun.org.apache.xerces.internal.impl.xpath.regex.ParseException;
import glcanvas.ArrowPlot;
import glcanvas.SpacedStreamlines;
import glcanvas.Streamlines;
import glcanvas.VisCanvas;
import glcanvas.data.Vec4;
import gui.ColorChooserPanel;
import gui.ColorHist;
import gui.DatFilter;
import gui.ExtendedInputVerifier;
import gui.FlowVisMain;
import gui.GradientColorPanel;
import gui.MFTFilter;
import gui.PNGFilter;
import gui.ParentColorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GuiMain
extends JFrame
implements ActionListener,
ChangeListener,
FocusListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final long serialVersionUID = -7609425377173567595L;
    static final int SLICE_MIN = 0;
    static final int SLICE_MAX = 100;
    static final int SLICE_INIT = 50;
    private JMenuBar menuBar = null;
    private JSlider sliceSlider = null;
    private static JSlider stepSizeSlider = null;
    private GLCanvas canvas = null;
    private GLCanvas histogramCanvas = null;
    private GradientColorPanel gradientColorPanel = null;
    private JButton showTransferFButton;
    private JTabbedPane leftPanel = null;
    private JCheckBox planarCBox = null;
    private JCheckBox mipCBox = null;
    private JCheckBox gradientCBox = null;
    private JCheckBox backgroundCBox = null;
    private JCheckBox arrowsCBox = null;
    private JCheckBox streamlinesCBox = null;
    private JCheckBox evenlyCBox = null;
    private JCheckBox showSeedCBox = null;
    private JComboBox integrationCombo = null;
    private JFileChooser fileChooser = null;
    private MFTFilter mftFilter = null;
    private PNGFilter pngFilter = null;
    private DatFilter datFilter = null;
    private JPanel mainTPanel = null;
    private JPanel mainColorPanel = null;
    private LinkedList<ParentColorPanel> parentColorPanels = null;
    private JScrollPane scrollPane;
    private JRadioButton equalArrowsRButton;
    private JRadioButton unEqualArrowsRButton;
    private JPanel visibleLayersPanel;
    private VisCanvas vc = null;
    private JSlider arrowSizeSlider;
    private JSlider stepSlider;
    private JSlider dsepSlider;
    private JSlider dtestSlider;
    private JLabel streamLinesColorLabel;
    private ColorChooserPanel streamLinesColorPanel;
    private JLabel streamLinesTranspLabel;
    private JTextField streamLinesTranspTextField;
    private JLabel arrowsColorLabel;
    private ColorChooserPanel arrowsColorPanel;
    private JLabel arrowsTranspLabel;
    private JTextField arrowsTranspTextField;

    public GuiMain(VisCanvas vc) {
        this.vc = vc;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("I didn't load the Default System LookAndFeel");
        }
        this.setSize(new Dimension(1210, 710));
        this.setDefaultCloseOperation(3);
        this.setTitle("Visualize");
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.getCanvas(), "Center");
        this.add((Component)this.getPanel(), "West");
        this.add((Component)this.getTransferfunctionPanel(), "South");
        this.setJMenuBar(this.getMenu());
        this.setVisible(true);
        this.fileChooser = new JFileChooser();
        this.datFilter = new DatFilter();
        this.mftFilter = new MFTFilter();
        this.pngFilter = new PNGFilter();
    }

    private JMenuBar getMenu() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            JMenuItem loadItem = new JMenuItem("Load File");
            loadItem.setMnemonic(76);
            loadItem.setActionCommand("load file");
            JMenuItem loadTFItem = new JMenuItem("Load Transferfunction");
            loadTFItem.setMnemonic(79);
            loadTFItem.setActionCommand("load tf");
            JMenuItem saveTFItem = new JMenuItem("Save Transferfunction");
            saveTFItem.setMnemonic(83);
            saveTFItem.setActionCommand("save tf");
            JMenuItem saveImageItem = new JMenuItem("Save Image");
            saveImageItem.setMnemonic(73);
            saveImageItem.setActionCommand("save image");
            loadTFItem.addActionListener(this);
            saveTFItem.addActionListener(this);
            loadItem.addActionListener(this);
            saveImageItem.addActionListener(this);
            JMenu menu = new JMenu("File");
            menu.setMnemonic(70);
            menu.add(loadItem);
            menu.add(loadTFItem);
            menu.add(saveTFItem);
            menu.add(saveImageItem);
            this.menuBar.add(menu);
        }
        return this.menuBar;
    }

    private JPanel getPanel() {
        JPanel helperPanel = new JPanel();
        helperPanel.setPreferredSize(new Dimension(200, 0));
        helperPanel.setLayout(new FlowLayout(0));
        this.leftPanel = new JTabbedPane();
        JPanel layersPanel = new JPanel();
        layersPanel.setLayout(new GridLayout(6, 1, 0, 0));
        layersPanel.setPreferredSize(new Dimension(170, 150));
        layersPanel.add(new JLabel("Visible Layers:"));
        this.arrowsCBox = new JCheckBox("Arrows");
        this.arrowsCBox.setActionCommand("show arrows");
        this.arrowsCBox.setMnemonic(65);
        this.arrowsCBox.setSelected(true);
        this.arrowsCBox.addActionListener(this);
        this.streamlinesCBox = new JCheckBox("Streamlines");
        this.streamlinesCBox.setActionCommand("show streamlines");
        this.streamlinesCBox.setMnemonic(84);
        this.streamlinesCBox.setSelected(false);
        this.streamlinesCBox.addActionListener(this);
        layersPanel.add(this.arrowsCBox);
        JPanel arrowsLayerPanel = new JPanel();
        arrowsLayerPanel.setLayout(new FlowLayout());
        this.arrowsColorPanel = new ColorChooserPanel();
        this.arrowsColorPanel.addActionListener(this);
        this.arrowsColorLabel = new JLabel("Color:");
        arrowsLayerPanel.add(this.arrowsColorLabel);
        arrowsLayerPanel.add(this.arrowsColorPanel);
        this.arrowsTranspLabel = new JLabel("Alpha:");
        arrowsLayerPanel.add(this.arrowsTranspLabel);
        this.arrowsTranspTextField = new JTextField();
        this.arrowsTranspTextField.setInputVerifier(new ExtendedInputVerifier());
        this.arrowsTranspTextField.setText("100");
        this.arrowsTranspTextField.addActionListener(this);
        this.arrowsTranspTextField.setActionCommand("arrows transparency");
        this.arrowsTranspTextField.addFocusListener(this);
        arrowsLayerPanel.add(this.arrowsTranspTextField);
        layersPanel.add(arrowsLayerPanel);
        layersPanel.add(this.streamlinesCBox);
        JPanel streamLinesLayerPanel = new JPanel();
        streamLinesLayerPanel.setLayout(new FlowLayout());
        this.streamLinesColorPanel = new ColorChooserPanel();
        this.streamLinesColorPanel.addActionListener(this);
        this.streamLinesColorLabel = new JLabel("Color:");
        streamLinesLayerPanel.add(this.streamLinesColorLabel);
        streamLinesLayerPanel.add(this.streamLinesColorPanel);
        this.streamLinesTranspLabel = new JLabel("Alpha:");
        streamLinesLayerPanel.add(this.streamLinesTranspLabel);
        this.streamLinesTranspTextField = new JTextField();
        this.streamLinesTranspTextField.addActionListener(this);
        this.streamLinesTranspTextField.setActionCommand("streamlines transparency");
        this.streamLinesTranspTextField.addFocusListener(this);
        this.streamLinesTranspTextField.setText("100");
        this.streamLinesTranspTextField.setInputVerifier(new ExtendedInputVerifier());
        streamLinesLayerPanel.add(this.streamLinesTranspTextField);
        layersPanel.add(streamLinesLayerPanel);
        this.streamLinesColorLabel.setEnabled(false);
        this.streamLinesColorPanel.setEnabled(false);
        this.streamLinesTranspLabel.setEnabled(false);
        this.streamLinesTranspTextField.setEnabled(false);
        helperPanel.add(layersPanel);
        helperPanel.add(this.initResetButton());
        JPanel arrows = this.getArrowPanel();
        this.leftPanel.addTab("Arrows", arrows);
        this.leftPanel.setPreferredSize(new Dimension(200, 350));
        this.leftPanel.addChangeListener(this);
        JPanel streamLines = this.getStreamLinesPanel();
        this.leftPanel.addTab("Streamlines", streamLines);
        JPanel test = new JPanel();
        test.setPreferredSize(new Dimension(200, 350));
        test.add(this.leftPanel);
        helperPanel.add(test);
        return helperPanel;
    }

    private JPanel getArrowPanel() {
        JPanel arrow = new JPanel(new FlowLayout(0, 5, 10));
        JPanel dirPanel = new JPanel(new GridLayout(0, 1));
        arrow.setPreferredSize(new Dimension(200, 0));
        ButtonGroup group = new ButtonGroup();
        this.equalArrowsRButton = new JRadioButton("Equal Arrow Length");
        this.equalArrowsRButton.setActionCommand("equal arrows");
        this.equalArrowsRButton.addActionListener(this);
        this.equalArrowsRButton.setSelected(true);
        this.unEqualArrowsRButton = new JRadioButton("Arrow Length depends on value");
        this.unEqualArrowsRButton.setActionCommand("unequal arrows");
        this.unEqualArrowsRButton.addActionListener(this);
        group.add(this.equalArrowsRButton);
        group.add(this.unEqualArrowsRButton);
        dirPanel.add(this.equalArrowsRButton);
        dirPanel.add(this.unEqualArrowsRButton);
        arrow.add(dirPanel);
        arrow.add(new JLabel("Distance between arrows:"));
        this.sliceSlider = new JSlider(0, 0, 100, 50);
        this.sliceSlider.setPreferredSize(new Dimension(180, 50));
        this.sliceSlider.setMajorTickSpacing(50);
        this.sliceSlider.setMinorTickSpacing(10);
        this.sliceSlider.setValue(20);
        this.sliceSlider.setPaintTicks(true);
        this.sliceSlider.setPaintLabels(true);
        this.sliceSlider.addChangeListener(this);
        arrow.add(this.sliceSlider);
        arrow.add(new JLabel("Size of arrow:"));
        this.arrowSizeSlider = new JSlider(0, 0, 100, 50);
        this.arrowSizeSlider.setPreferredSize(new Dimension(180, 50));
        this.arrowSizeSlider.setMajorTickSpacing(50);
        this.arrowSizeSlider.setMinorTickSpacing(10);
        this.arrowSizeSlider.setPaintTicks(true);
        this.arrowSizeSlider.setPaintLabels(true);
        this.arrowSizeSlider.addChangeListener(this);
        this.arrowSizeSlider.setValue(30);
        arrow.add(this.arrowSizeSlider);
        this.vc.setTexCoord(50);
        return arrow;
    }

    private JPanel getStreamLinesPanel() {
        JPanel slines = new JPanel(new FlowLayout(0, 5, 10));
        this.evenlyCBox = new JCheckBox("Evenly Spaced");
        this.evenlyCBox.setMnemonic(86);
        this.evenlyCBox.setActionCommand("Evenly Spaced");
        this.evenlyCBox.addActionListener(this);
        this.evenlyCBox.setSelected(true);
        slines.add(this.evenlyCBox);
        String[] istrings = new String[]{"Euler", "Runge-Kutta", "Both"};
        this.integrationCombo = new JComboBox<String>(istrings);
        this.integrationCombo.setSelectedIndex(0);
        this.integrationCombo.setActionCommand("Integration Method");
        this.integrationCombo.addActionListener(this);
        slines.add(this.integrationCombo);
        this.stepSlider = new JSlider(0, 0, 100, 50);
        this.stepSlider.setPreferredSize(new Dimension(180, 50));
        this.stepSlider.setMajorTickSpacing(50);
        this.stepSlider.setMinorTickSpacing(10);
        this.stepSlider.setPaintTicks(true);
        this.stepSlider.setPaintLabels(true);
        this.stepSlider.addChangeListener(this);
        Hashtable<Integer, JLabel> labelTable0 = new Hashtable<Integer, JLabel>();
        labelTable0.put(new Integer(0), new JLabel("0.01"));
        labelTable0.put(new Integer(50), new JLabel("steps"));
        labelTable0.put(new Integer(100), new JLabel("0.1"));
        this.stepSlider.setLabelTable(labelTable0);
        slines.add(this.stepSlider);
        this.dsepSlider = new JSlider(0, 0, 100, 50);
        this.dsepSlider.setPreferredSize(new Dimension(180, 50));
        this.dsepSlider.setMajorTickSpacing(50);
        this.dsepSlider.setMinorTickSpacing(10);
        this.dsepSlider.setPaintTicks(true);
        this.dsepSlider.setPaintLabels(true);
        this.dsepSlider.addChangeListener(this);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("0.1"));
        labelTable.put(new Integer(50), new JLabel("d sep"));
        labelTable.put(new Integer(100), new JLabel("1.0"));
        this.dsepSlider.setLabelTable(labelTable);
        slines.add(this.dsepSlider);
        this.dtestSlider = new JSlider(0, 0, 100, 50);
        this.dtestSlider.setPreferredSize(new Dimension(180, 50));
        this.dtestSlider.setMajorTickSpacing(50);
        this.dtestSlider.setMinorTickSpacing(10);
        this.dtestSlider.setPaintTicks(true);
        this.dtestSlider.setPaintLabels(true);
        this.dtestSlider.addChangeListener(this);
        Hashtable<Integer, JLabel> labelTable2 = new Hashtable<Integer, JLabel>();
        labelTable2.put(new Integer(0), new JLabel("0.1"));
        labelTable2.put(new Integer(50), new JLabel("d test"));
        labelTable2.put(new Integer(100), new JLabel("1.0"));
        this.dtestSlider.setLabelTable(labelTable2);
        slines.add(this.dtestSlider);
        this.showSeedCBox = new JCheckBox("Show Seed Points");
        this.showSeedCBox.setMnemonic(72);
        this.showSeedCBox.setActionCommand("Show Seeds");
        this.showSeedCBox.addActionListener(this);
        slines.add(this.showSeedCBox);
        return slines;
    }

    private JButton initResetButton() {
        JButton resetButton = new JButton("Reset View");
        resetButton.setMnemonic(82);
        resetButton.setActionCommand("reset");
        resetButton.addActionListener(this);
        return resetButton;
    }

    private JPanel getRaycastingPanel() {
        JPanel rayCasting = new JPanel(new FlowLayout(0, 5, 10));
        rayCasting.setPreferredSize(new Dimension(200, 0));
        this.mipCBox = new JCheckBox("MIP");
        this.mipCBox.setMnemonic(77);
        this.mipCBox.setActionCommand("mip");
        this.mipCBox.addActionListener(this);
        this.mipCBox.setPreferredSize(new Dimension(180, 20));
        rayCasting.add(this.mipCBox);
        stepSizeSlider = new JSlider(0, 0, 100, 50);
        stepSizeSlider.setPreferredSize(new Dimension(180, 50));
        stepSizeSlider.setMajorTickSpacing(50);
        stepSizeSlider.setMinorTickSpacing(10);
        stepSizeSlider.setPaintTicks(true);
        stepSizeSlider.setPaintLabels(true);
        stepSizeSlider.addChangeListener(this);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("0.001"));
        labelTable.put(new Integer(100), new JLabel("0.5"));
        stepSizeSlider.setLabelTable(labelTable);
        rayCasting.add(stepSizeSlider);
        rayCasting.add(this.initResetButton());
        return rayCasting;
    }

    private JPanel getTransferfunctionPanel() throws ParseException {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new FlowLayout(0));
        titlePanel.add(new JLabel("Transferfunction"));
        titlePanel.setBorder(BorderFactory.createBevelBorder(1));
        this.showTransferFButton = new JButton("Hide");
        this.showTransferFButton.addActionListener(this);
        this.showTransferFButton.setActionCommand("transfer");
        titlePanel.add(this.showTransferFButton);
        this.mainTPanel = new JPanel();
        this.mainTPanel.setLayout(new FlowLayout(0));
        bottomPanel.add("North", titlePanel);
        bottomPanel.add(this.mainTPanel);
        this.mainTPanel.setPreferredSize(new Dimension(1000, 200));
        JPanel helpPanel2 = new JPanel();
        this.visibleLayersPanel = new JPanel();
        helpPanel2.setBorder(BorderFactory.createLineBorder(Color.gray));
        helpPanel2.setPreferredSize(new Dimension(100, 180));
        helpPanel2.add(new JLabel("Visible Layers:"));
        helpPanel2.add(this.visibleLayersPanel);
        this.mainTPanel.add(helpPanel2);
        JPanel helpPanel = new JPanel();
        helpPanel.setPreferredSize(new Dimension(700, 190));
        helpPanel.setLayout(new FlowLayout(0));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setPreferredSize(new Dimension(600, 180));
        this.mainColorPanel = new JPanel();
        this.mainColorPanel.setPreferredSize(new Dimension(100, 800));
        this.mainColorPanel.setLayout(new FlowLayout(0));
        this.scrollPane.getViewport().add(this.mainColorPanel);
        helpPanel.add(this.scrollPane);
        this.mainTPanel.add(helpPanel);
        this.parentColorPanels = new LinkedList();
        return bottomPanel;
    }

    public void initParentColorPanels(String[] names, float[] min, float[] max) {
        this.parentColorPanels.clear();
        this.mainColorPanel.removeAll();
        this.visibleLayersPanel.removeAll();
        this.visibleLayersPanel.setLayout(new GridLayout(names.length, 1));
        this.mainColorPanel.setPreferredSize(new Dimension(100, names.length * 250));
        int i = 0;
        while (i < names.length) {
            ParentColorPanel parentColorPanel = new ParentColorPanel(names[i]);
            parentColorPanel.setMinLabel(min[i]);
            parentColorPanel.setMaxLabel(max[i]);
            this.parentColorPanels.add(parentColorPanel);
            parentColorPanel.addActionListener(this);
            this.mainColorPanel.add(parentColorPanel);
            JCheckBox cBox = new JCheckBox(names[i]);
            cBox.addActionListener(this);
            cBox.setActionCommand("layers/" + i);
            this.visibleLayersPanel.add(cBox);
            ++i;
        }
        this.scrollPane.updateUI();
        this.visibleLayersPanel.updateUI();
    }

    protected GLCanvas getCanvas() {
        if (this.canvas == null) {
            GLCapabilities caps = new GLCapabilities();
            caps.setDoubleBuffered(true);
            caps.setHardwareAccelerated(true);
            this.canvas = new GLCanvas(caps);
            this.canvas.setPreferredSize(new Dimension(800, 0));
            this.canvas.addGLEventListener((GLEventListener)this.vc);
            this.canvas.addMouseMotionListener((MouseMotionListener)this);
            this.canvas.addMouseWheelListener((MouseWheelListener)this);
            this.canvas.addKeyListener((KeyListener)this);
        }
        return this.canvas;
    }

    protected GLCanvas getHistogramCanvas() {
        if (this.histogramCanvas == null) {
            GLCapabilities caps = new GLCapabilities();
            caps.setDoubleBuffered(true);
            caps.setHardwareAccelerated(true);
            this.histogramCanvas = new GLCanvas(caps);
            this.histogramCanvas.setPreferredSize(new Dimension(256, 50));
            this.histogramCanvas.addGLEventListener((GLEventListener)this.vc);
        }
        return this.histogramCanvas;
    }

    protected void setCanvas(GLCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("load file")) {
            this.fileChooser.setSelectedFile(null);
            this.fileChooser.updateUI();
            this.fileChooser.removeChoosableFileFilter(this.pngFilter);
            this.fileChooser.removeChoosableFileFilter(this.mftFilter);
            this.fileChooser.setFileFilter(this.datFilter);
            int returnVal = this.fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                FlowVisMain.loadFile(file);
            } else {
                System.out.println("opening canceled");
            }
        } else if (ae.getActionCommand().equals("show background")) {
            this.vc.showBackground(this.backgroundCBox.isSelected());
        } else if (ae.getActionCommand().equals("show arrows")) {
            this.arrowsColorLabel.setEnabled(this.arrowsCBox.isSelected());
            this.arrowsColorPanel.setEnabled(this.arrowsCBox.isSelected());
            this.arrowsTranspLabel.setEnabled(this.arrowsCBox.isSelected());
            this.arrowsTranspTextField.setEnabled(this.arrowsCBox.isSelected());
            this.vc.showArrows(this.arrowsCBox.isSelected());
        } else if (ae.getActionCommand().equals("show streamlines")) {
            this.streamLinesColorLabel.setEnabled(this.streamlinesCBox.isSelected());
            this.streamLinesColorPanel.setEnabled(this.streamlinesCBox.isSelected());
            this.streamLinesTranspLabel.setEnabled(this.streamlinesCBox.isSelected());
            this.streamLinesTranspTextField.setEnabled(this.streamlinesCBox.isSelected());
            this.vc.showStreamlines(this.streamlinesCBox.isSelected());
        } else if (ae.getActionCommand().equals("colorchooser changed")) {
            if (ae.getSource() == this.arrowsColorPanel) {
                Vec4 color = new Vec4();
                color.setX((float)this.arrowsColorPanel.getColor().getRed() / 255.0f);
                color.setY((float)this.arrowsColorPanel.getColor().getGreen() / 255.0f);
                color.setZ((float)this.arrowsColorPanel.getColor().getBlue() / 255.0f);
                color.setAlpha((float)Integer.valueOf(this.arrowsTranspTextField.getText()).intValue() / 100.0f);
                ArrowPlot.setColor(color);
            } else {
                Vec4 color = new Vec4();
                color.setX((float)this.streamLinesColorPanel.getColor().getRed() / 255.0f);
                color.setY((float)this.streamLinesColorPanel.getColor().getGreen() / 255.0f);
                color.setZ((float)this.streamLinesColorPanel.getColor().getBlue() / 255.0f);
                color.setAlpha((float)Integer.valueOf(this.streamLinesTranspTextField.getText()).intValue() / 100.0f);
                SpacedStreamlines.setColor(color);
                Streamlines.setColor(color);
            }
        } else if (ae.getActionCommand().equals("arrows transparency")) {
            if (this.arrowsTranspTextField.getInputVerifier().verify(this.arrowsTranspTextField)) {
                ActionEvent event = new ActionEvent(this, 23, "arrows transparency changed");
                this.actionPerformed(event);
            }
        } else if (ae.getActionCommand().equals("arrows transparency changed")) {
            Vec4 color = new Vec4();
            color.setX((float)this.arrowsColorPanel.getColor().getRed() / 255.0f);
            color.setY((float)this.arrowsColorPanel.getColor().getGreen() / 255.0f);
            color.setZ((float)this.arrowsColorPanel.getColor().getBlue() / 255.0f);
            color.setAlpha((float)Integer.valueOf(this.arrowsTranspTextField.getText()).intValue() / 100.0f);
            ArrowPlot.setColor(color);
        } else if (ae.getActionCommand().equals("streamlines transparency")) {
            if (this.streamLinesTranspTextField.getInputVerifier().verify(this.streamLinesTranspTextField)) {
                ActionEvent event = new ActionEvent(this, 23, "streamlines transparency changed");
                this.actionPerformed(event);
            }
        } else if (ae.getActionCommand().equals("streamlines transparency changed")) {
            Vec4 color = new Vec4();
            color.setX((float)this.streamLinesColorPanel.getColor().getRed() / 255.0f);
            color.setY((float)this.streamLinesColorPanel.getColor().getGreen() / 255.0f);
            color.setZ((float)this.streamLinesColorPanel.getColor().getBlue() / 255.0f);
            color.setAlpha((float)Integer.valueOf(this.streamLinesTranspTextField.getText()).intValue() / 100.0f);
            SpacedStreamlines.setColor(color);
        } else if (ae.getActionCommand().equals("equal arrows")) {
            ArrowPlot.updateEqualLength(this.equalArrowsRButton.isSelected());
        } else if (ae.getActionCommand().equals("unequal arrows")) {
            ArrowPlot.updateEqualLength(this.equalArrowsRButton.isSelected());
        } else if (ae.getActionCommand().equals("z")) {
            this.vc.setTexCoord(this.sliceSlider.getValue());
        } else if (ae.getActionCommand().equals("transfer")) {
            if (this.mainTPanel.isVisible()) {
                this.showTransferFButton.setText("Show");
                this.mainTPanel.setVisible(false);
            } else {
                this.showTransferFButton.setText("Hide");
                this.mainTPanel.setVisible(true);
            }
        } else if (ae.getActionCommand().equals("reset")) {
            this.vc.flushCamera();
        } else if (ae.getActionCommand().equals("planar")) {
            this.vc.setPlanarView(this.planarCBox.isSelected());
        } else if (ae.getActionCommand().equals("tf changed")) {
            ParentColorPanel pcp = this.getSenderPanel((Component)ae.getSource());
            this.vc.transferFunctionChanged(this.parentColorPanels.indexOf(pcp), pcp.getGradientColorPanel().getInterpolatedColorHist());
        } else if (ae.getActionCommand().equals("save tf")) {
            this.fileChooser.setSelectedFile(null);
            this.fileChooser.updateUI();
            this.fileChooser.removeChoosableFileFilter(this.pngFilter);
            this.fileChooser.removeChoosableFileFilter(this.datFilter);
            this.fileChooser.setFileFilter(this.mftFilter);
            int returnVal = this.fileChooser.showSaveDialog(this);
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                this.writeTFToFile(file.getAbsolutePath());
            } else {
                System.out.println("opening canceled");
            }
        } else if (ae.getActionCommand().equals("load tf")) {
            this.fileChooser.setSelectedFile(null);
            this.fileChooser.updateUI();
            this.fileChooser.removeChoosableFileFilter(this.pngFilter);
            this.fileChooser.removeChoosableFileFilter(this.datFilter);
            this.fileChooser.setFileFilter(this.mftFilter);
            int returnVal = this.fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                this.readTFFromFile(file.getAbsolutePath());
            } else {
                System.out.println("opening canceled");
            }
        } else if (ae.getActionCommand().equals("save image")) {
            this.fileChooser.setSelectedFile(null);
            this.fileChooser.updateUI();
            this.fileChooser.removeChoosableFileFilter(this.datFilter);
            this.fileChooser.removeChoosableFileFilter(this.mftFilter);
            this.fileChooser.setFileFilter(this.pngFilter);
            int returnVal = this.fileChooser.showSaveDialog(this);
            if (returnVal == 0) {
                System.out.println("writing file");
                File file = this.fileChooser.getSelectedFile();
                this.vc.saveImage(file + ".png");
            } else {
                System.out.println("opening canceled");
            }
        } else if (ae.getActionCommand().startsWith("layers")) {
            String command = ae.getActionCommand();
            String senderID = command.substring(command.indexOf("/") + 1);
            JCheckBox cBox = (JCheckBox)ae.getSource();
            this.vc.updateRenderChannel(Integer.valueOf(senderID), cBox.isSelected());
        } else if (ae.getActionCommand().equals("Evenly Spaced")) {
            this.vc.showEvenlySpaced(this.evenlyCBox.isSelected());
        } else if (ae.getActionCommand().equals("Show Seeds")) {
            SpacedStreamlines.setShowSeeds(this.showSeedCBox.isSelected());
        } else if (ae.getActionCommand().equals("Integration Method")) {
            SpacedStreamlines.setIntegrationMethod(this.integrationCombo.getSelectedIndex());
        }
    }

    private ParentColorPanel getSenderPanel(Component comp) {
        Container parentComp = comp.getParent();
        ParentColorPanel panel = null;
        if (comp instanceof ParentColorPanel) {
            panel = (ParentColorPanel)comp;
        }
        return panel;
    }

    private void writeTFToFile(String fileName) {
        fileName = String.valueOf(fileName) + ".mft";
        PrintWriter pw = null;
        try {
            try {
                FileWriter fw = new FileWriter(fileName);
                BufferedWriter bw = new BufferedWriter(fw);
                pw = new PrintWriter(bw);
                pw.println("-");
                int i = 0;
                while (i < this.gradientColorPanel.getColorPoints().size()) {
                    String line = String.valueOf(new Integer(this.gradientColorPanel.getColorPoints().get(i).getGrayValue()).toString()) + "/" + new Integer(this.gradientColorPanel.getColorPoints().get(i).getColor().getRed()).toString() + "r" + new Integer(this.gradientColorPanel.getColorPoints().get(i).getColor().getGreen()).toString() + "g" + new Integer(this.gradientColorPanel.getColorPoints().get(i).getColor().getBlue()).toString() + "b";
                    pw.println(line);
                    ++i;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Could'nt write File. We apologize.", "Error", 0);
                if (pw != null) {
                    pw.close();
                }
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public void readTFFromFile(String fileName) {
        block15: {
            BufferedReader in = null;
            try {
                try {
                    String line;
                    in = new BufferedReader(new FileReader(fileName));
                    this.gradientColorPanel.getColorPoints().clear();
                    boolean isLDPRead = false;
                    while ((line = in.readLine()) != null) {
                        int grayValue;
                        int pos;
                        if (line.equals("-")) {
                            isLDPRead = true;
                            continue;
                        }
                        if (!isLDPRead) {
                            pos = line.indexOf("/");
                            grayValue = Integer.parseInt(line.substring(0, pos));
                            int opacity = Integer.parseInt(line.substring(pos + 1, line.length()));
                            continue;
                        }
                        pos = line.indexOf("/");
                        int posR = line.indexOf("r");
                        int posG = line.indexOf("g");
                        int posB = line.indexOf("b");
                        grayValue = Integer.parseInt(line.substring(0, pos));
                        int red = Integer.parseInt(line.substring(pos + 1, posR));
                        int green = Integer.parseInt(line.substring(posR + 1, posG));
                        int blue = Integer.parseInt(line.substring(posG + 1, posB));
                        this.gradientColorPanel.getColorPoints().add(new ColorHist(grayValue, new Color(red, green, blue)));
                    }
                    this.gradientColorPanel.FTOpened();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Couldn't read File. We apologize.", "Error", 0);
                    if (in == null) break block15;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void setStepSizeSlider(float value) {
        stepSizeSlider.setValue(Math.round(value * 2000.0f - 0.003f));
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        int value;
        if (ce.getSource().equals(this.sliceSlider)) {
            int value2 = this.sliceSlider.getValue();
            if (value2 > 0) {
                ArrowPlot.setDistance(value2);
            }
        } else if (ce.getSource().equals(this.leftPanel)) {
            this.vc.setRendering(this.leftPanel.getSelectedIndex());
        } else if (ce.getSource().equals(this.arrowSizeSlider)) {
            int value3 = this.arrowSizeSlider.getValue();
            if (value3 > 0) {
                ArrowPlot.setSize(value3);
            }
        } else if (ce.getSource().equals(this.dtestSlider)) {
            int value4 = this.dtestSlider.getValue();
            if (value4 > 0) {
                SpacedStreamlines.setDTest(value4);
            }
        } else if (ce.getSource().equals(this.stepSlider)) {
            int value5 = this.stepSlider.getValue();
            if (value5 > 0) {
                SpacedStreamlines.setStep(value5);
                Streamlines.setStep(value5);
            }
        } else if (ce.getSource().equals(this.dsepSlider) && (value = this.dsepSlider.getValue()) > 0) {
            SpacedStreamlines.setDSep(value);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (me.isControlDown()) {
            this.vc.rotateObject(me.getX(), me.getY());
        }
        if (me.isShiftDown()) {
            this.vc.translateObject(me.getX(), me.getY());
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        this.vc.zoomObject(mwe.getWheelRotation());
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 38) {
            this.vc.zoomObject(1);
        } else if (ke.getKeyCode() == 40) {
            this.vc.zoomObject(-1);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        ActionEvent event;
        if (e.getSource() == this.arrowsTranspTextField) {
            event = new ActionEvent(this, 23, "arrows transparency changed");
            this.actionPerformed(event);
        }
        if (e.getSource() == this.streamLinesTranspTextField) {
            event = new ActionEvent(this, 23, "streamlines transparency changed");
            this.actionPerformed(event);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

