/*
 * Decompiled with CFR 0.152.
 */
package gui;

import glcanvas.TextureReader;
import glcanvas.data.Vec4;
import gui.AlphaHist;
import gui.ColorHist;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GradientColorPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 5602858377933611827L;
    private LinkedList<ColorHist> colorPoints;
    private LinkedList<ColorHist> gradientPoints;
    private LinkedList<AlphaHist> alphaPoints;
    private static int colorRectHeight = 8;
    private static int colorRectWidth = 8;
    private static int colorRectTop = 14;
    private static int tolerance = 5;
    private static int offSet = 3;
    private static int offSetGP = 16;
    private static int heightGP = 25;
    private ColorHist selectedColorHist;
    private AlphaHist selectedAlphaHist;
    private ActionListener listener;
    private boolean colorPointsChanged;
    private TexturePaint tp;

    public GradientColorPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.gradientPoints = new LinkedList();
        Color co1 = new Color(0, 0, 0);
        ColorHist c1 = new ColorHist(0, co1);
        ColorHist c2 = new ColorHist(255, Color.WHITE);
        this.colorPoints = new LinkedList();
        this.colorPoints.add(c1);
        this.colorPoints.add(c2);
        AlphaHist a1 = new AlphaHist(0, 100);
        AlphaHist a3 = new AlphaHist(255, 100);
        this.alphaPoints = new LinkedList();
        this.alphaPoints.add(a1);
        this.alphaPoints.add(a3);
        BufferedImage img = null;
        try {
            img = TextureReader.readImage("image/gp_texture.jpg");
        }
        catch (IOException e) {
            System.out.println("Error while reading texture for gradientcolorpanel!");
        }
        this.tp = new TexturePaint(img, new Rectangle2D.Double(0.0, 0.0, img.getWidth(), img.getHeight()));
    }

    public void init() {
        this.colorPoints.clear();
        Color co1 = new Color(0, 0, 0, 0);
        ColorHist c1 = new ColorHist(0, co1);
        ColorHist c2 = new ColorHist(255, Color.WHITE);
        this.colorPoints.add(c1);
        this.colorPoints.add(c2);
        this.selectedColorHist = null;
        this.colorPointsChanged = true;
        this.repaint();
        this.tellListenerNoSelection();
    }

    private void updateColorPointsTransparency() {
        int indexAlpha = 1;
        int indexColor = 1;
        AlphaHist leftAlpha = this.alphaPoints.getFirst();
        AlphaHist rightAlpha = this.alphaPoints.get(indexAlpha);
        ColorHist leftColor = this.colorPoints.getFirst();
        ColorHist rightColor = this.colorPoints.get(indexColor);
        this.gradientPoints.clear();
        ColorHist colorHist = new ColorHist(leftColor.getGrayValue(), leftColor.getColor());
        colorHist.setTransparency(leftAlpha.getTransparency());
        this.gradientPoints.add(colorHist);
        int i = 0;
        while (i < 256) {
            if (i == rightAlpha.getGrayValue()) {
                colorHist = new ColorHist(i, this.interpolateColor(leftColor, rightColor, i - leftColor.getGrayValue()));
                colorHist.setTransparency(rightAlpha.getTransparency());
                this.gradientPoints.add(colorHist);
                leftAlpha = rightAlpha;
                if (this.alphaPoints.size() > ++indexAlpha) {
                    rightAlpha = this.alphaPoints.get(indexAlpha);
                }
            } else if (i == rightColor.getGrayValue()) {
                colorHist = new ColorHist(i, rightColor.getColor());
                int distance = rightAlpha.getGrayValue() - leftAlpha.getGrayValue();
                int pos = colorHist.getGrayValue() - leftAlpha.getGrayValue();
                double scaleRight = pos * 100 / distance;
                double scaleLeft = 100.0 - scaleRight;
                int transparency = (int)Math.round((double)leftAlpha.getTransparency() * scaleLeft / 100.0) + (int)Math.round((double)rightAlpha.getTransparency() * scaleRight / 100.0);
                colorHist.setTransparency(transparency);
                this.gradientPoints.add(colorHist);
                leftColor = rightColor;
                if (this.colorPoints.size() > ++indexColor) {
                    rightColor = this.colorPoints.get(indexColor);
                }
            }
            ++i;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int lastXValue;
        GeneralPath path;
        Graphics2D graphics = (Graphics2D)g;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.colorPoints.size() < 2) {
            return;
        }
        ColorHist lastColorHist = this.colorPoints.getFirst();
        ColorHist gradient = null;
        ColorHist rightColorHist = this.colorPoints.getLast();
        int leftP = this.convertColorHist(lastColorHist);
        int rightP = this.convertColorHist(rightColorHist);
        Rectangle r = new Rectangle(leftP, offSetGP, rightP, heightGP);
        graphics.setPaint(this.tp);
        graphics.fill(r);
        ColorHist colorHist = null;
        AlphaHist alphaHist = null;
        Rectangle rect = null;
        Rectangle colorRect = null;
        int xValue = 0;
        int i = 0;
        while (i < this.alphaPoints.size()) {
            alphaHist = this.alphaPoints.get(i);
            xValue = this.convertColorHist(alphaHist);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(xValue - colorRectWidth / 2, 0, colorRectWidth, colorRectHeight);
            path = new GeneralPath();
            path.moveTo(xValue - colorRectWidth / 2, colorRectHeight);
            path.lineTo(xValue, colorRectHeight + 5);
            path.lineTo(xValue + colorRectWidth / 2, colorRectHeight);
            graphics.draw(path);
            colorRect = new Rectangle(xValue - colorRectWidth / 2 + 1, 1, colorRectWidth - 1, colorRectHeight - 1);
            graphics.setPaint(alphaHist.getColor());
            graphics.fill(colorRect);
            if (alphaHist == this.selectedAlphaHist) {
                graphics.setColor(Color.BLACK);
                graphics.fill(path);
            }
            ++i;
        }
        this.updateColorPointsTransparency();
        Collections.sort(this.gradientPoints);
        ColorHist lastGradient = this.gradientPoints.getFirst();
        int i2 = 1;
        while (i2 < this.gradientPoints.size()) {
            gradient = this.gradientPoints.get(i2);
            xValue = this.convertColorHist(gradient);
            lastXValue = this.convertColorHist(lastGradient);
            rect = i2 == this.gradientPoints.size() - 1 ? new Rectangle(lastXValue, offSetGP, xValue + 5, heightGP) : new Rectangle(lastXValue, offSetGP, xValue - lastXValue, heightGP);
            GradientPaint gp = new GradientPaint(lastXValue, 1.0f, lastGradient.getTransparentColor(), xValue, 1.0f, gradient.getTransparentColor());
            graphics.setPaint(gp);
            graphics.fill(rect);
            lastGradient = gradient;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.colorPoints.size()) {
            colorHist = this.colorPoints.get(i2);
            xValue = this.convertColorHist(colorHist);
            lastXValue = this.convertColorHist(lastColorHist);
            int dist = Math.abs(colorRectTop / 2);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(xValue - colorRectWidth / 2, offSetGP + heightGP + dist, colorRectWidth, colorRectHeight);
            path = new GeneralPath();
            path.moveTo(xValue - colorRectWidth / 2, offSetGP + heightGP + dist);
            path.lineTo(xValue, offSetGP + heightGP + dist - colorRectWidth / 2);
            path.lineTo(xValue + colorRectWidth / 2, offSetGP + heightGP + dist);
            graphics.draw(path);
            colorRect = new Rectangle(xValue - colorRectWidth / 2 + 1, offSetGP + heightGP + dist + 1, colorRectWidth - 1, colorRectHeight - 1);
            graphics.setPaint(colorHist.getColor());
            graphics.fill(colorRect);
            if (colorHist == this.selectedColorHist) {
                graphics.setColor(Color.BLACK);
                graphics.fill(path);
            }
            lastColorHist = colorHist;
            ++i2;
        }
        if (this.colorPointsChanged) {
            this.tellListenerTFChanged();
            this.colorPointsChanged = false;
        }
    }

    public LinkedList<ColorHist> getColorPoints() {
        return this.colorPoints;
    }

    public void FTOpened() {
        this.colorPointsChanged = true;
        this.repaint();
        this.tellListenerNoSelection();
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void tellListenerSelectionChanged() {
        ActionEvent event = new ActionEvent(this, 23, "color selected");
        this.listener.actionPerformed(event);
    }

    public void tellListenerNoSelection() {
        ActionEvent event = new ActionEvent(this, 23, "color deselected");
        this.listener.actionPerformed(event);
    }

    public void tellListenerAlphaSelectionChanged() {
        ActionEvent event = new ActionEvent(this, 23, "alpha selected");
        this.listener.actionPerformed(event);
    }

    public void tellListenerNoAlphaSelection() {
        ActionEvent event = new ActionEvent(this, 23, "alpha deselected");
        this.listener.actionPerformed(event);
    }

    public void tellListenerTFChanged() {
        ActionEvent event = new ActionEvent(this, 24, "tf changed");
        this.listener.actionPerformed(event);
    }

    public Vec4[] getInterpolatedColorHist() {
        Vec4[] cHist = new Vec4[256];
        int curPoint = 1;
        ColorHist p1 = this.gradientPoints.getFirst();
        ColorHist p2 = this.gradientPoints.get(curPoint);
        float pointIdx = (float)p2.getGrayValue() / 255.0f;
        int i = 0;
        while (i < cHist.length) {
            float normIdx = (float)i / ((float)cHist.length - 1.0f);
            if (normIdx > pointIdx) {
                p1 = p2;
                if (++curPoint == this.gradientPoints.size()) {
                    System.out.println("fehler bei :" + i);
                }
                p2 = this.gradientPoints.get(curPoint);
                pointIdx = (float)p2.getGrayValue() / 255.0f;
            }
            cHist[i] = new Vec4();
            Color color = this.interpolatePoint(p1, p2, normIdx);
            cHist[i].setX((float)color.getRed() / 255.0f);
            cHist[i].setY((float)color.getGreen() / 255.0f);
            cHist[i].setZ((float)color.getBlue() / 255.0f);
            cHist[i].setAlpha((float)color.getAlpha() / 100.0f);
            ++i;
        }
        return cHist;
    }

    private Color interpolatePoint(ColorHist p1, ColorHist p2, float normIdx) {
        float normGrayP1 = (float)p1.getGrayValue() / 255.0f;
        float normGrayP2 = (float)p2.getGrayValue() / 255.0f;
        float weight = (normIdx - normGrayP1) / (normGrayP2 - normGrayP1);
        int red = Math.round((float)p1.getColor().getRed() * (1.0f - weight) + (float)p2.getColor().getRed() * weight);
        int green = Math.round((float)p1.getColor().getGreen() * (1.0f - weight) + (float)p2.getColor().getGreen() * weight);
        int blue = Math.round((float)p1.getColor().getBlue() * (1.0f - weight) + (float)p2.getColor().getBlue() * weight);
        int alpha = Math.round((float)p1.getTransparency() * (1.0f - weight) + (float)p2.getTransparency() * weight);
        return new Color(red, green, blue, alpha);
    }

    private int convertPoint(int x) {
        return Math.round((x - offSet) * 256 / (this.getWidth() - 2 * offSet));
    }

    private int convertColorHist(ColorHist colorHist) {
        return Math.round((this.getWidth() - 2 * offSet) * colorHist.getGrayValue() / 256) + offSet;
    }

    private int convertColorHist(AlphaHist colorHist) {
        return Math.round((this.getWidth() - 2 * offSet) * colorHist.getGrayValue() / 256) + offSet;
    }

    private ColorHist getNearestColorHist(Point point) {
        ColorHist nearestColorHist = null;
        int posX = this.convertPoint(point.x);
        int i = 0;
        while (i < this.colorPoints.size()) {
            ColorHist colorHist = this.colorPoints.get(i);
            if (colorHist.getGrayValue() + tolerance > posX & colorHist.getGrayValue() - tolerance < posX) {
                if (nearestColorHist == null) {
                    nearestColorHist = colorHist;
                } else if (Math.abs(nearestColorHist.getGrayValue() - posX) > Math.abs(colorHist.getGrayValue() - posX)) {
                    nearestColorHist = colorHist;
                }
            }
            ++i;
        }
        return nearestColorHist;
    }

    private AlphaHist getNearestAlphaHist(Point point) {
        AlphaHist nearestColorHist = null;
        int posX = this.convertPoint(point.x);
        int i = 0;
        while (i < this.alphaPoints.size()) {
            AlphaHist colorHist = this.alphaPoints.get(i);
            if (colorHist.getGrayValue() + tolerance > posX & colorHist.getGrayValue() - tolerance < posX) {
                if (nearestColorHist == null) {
                    nearestColorHist = colorHist;
                } else if (Math.abs(nearestColorHist.getGrayValue() - posX) > Math.abs(colorHist.getGrayValue() - posX)) {
                    nearestColorHist = colorHist;
                }
            }
            ++i;
        }
        return nearestColorHist;
    }

    public int getSelectedGrayValue() {
        return this.selectedColorHist.getGrayValue();
    }

    public int getSelectedAlphaGrayValue() {
        return this.selectedAlphaHist.getGrayValue();
    }

    public int getSelectedAlphaTransparency() {
        return this.selectedAlphaHist.getTransparency();
    }

    public int getSelectedRed() {
        return this.selectedColorHist.getColor().getRed();
    }

    public int getSelectedGreen() {
        return this.selectedColorHist.getColor().getGreen();
    }

    public int getSelectedBlue() {
        return this.selectedColorHist.getColor().getBlue();
    }

    public void setAlpha(int grayValue, int transparency) {
        if (grayValue < 0 || grayValue > 255) {
            JOptionPane.showMessageDialog(null, "Grayvalues must be in the ranges from 0 to 255", "Error", 0);
            return;
        }
        if (this.selectedAlphaHist == this.alphaPoints.getFirst() & grayValue != 0 | this.selectedAlphaHist == this.alphaPoints.getLast() & grayValue != 255) {
            JOptionPane.showMessageDialog(null, "The grayvalues of the first and the last gradient-points can't be changed.", "Error", 0);
            return;
        }
        int i = 0;
        while (i < this.alphaPoints.size()) {
            if (this.alphaPoints.get(i).getGrayValue() == grayValue & this.alphaPoints.get(i) != this.selectedAlphaHist) {
                JOptionPane.showMessageDialog(null, "There is already a gradient-point existing with this grayvalue. Please enter another grayValue.", "Error", 0);
                return;
            }
            ++i;
        }
        if (transparency < 0 || transparency > 100) {
            JOptionPane.showMessageDialog(null, "Transparency must be in the range from 0 to 255", "Error", 0);
            return;
        }
        this.selectedAlphaHist.setGrayValue(grayValue);
        this.selectedAlphaHist.setTransparency(transparency);
        this.colorPointsChanged = true;
        this.repaint();
    }

    public void setColor(int grayValue) {
        if (grayValue < 0 || grayValue > 255) {
            JOptionPane.showMessageDialog(null, "Grayvalues must be in the ranges from 0 to 255", "Error", 0);
            return;
        }
        if (this.selectedColorHist == this.colorPoints.getFirst() & grayValue != 0 | this.selectedColorHist == this.colorPoints.getLast() & grayValue != 255) {
            JOptionPane.showMessageDialog(null, "The grayvalues of the first and the last gradient-points can't be changed.", "Error", 0);
            return;
        }
        int i = 0;
        while (i < this.colorPoints.size()) {
            if (this.colorPoints.get(i).getGrayValue() == grayValue & this.colorPoints.get(i) != this.selectedColorHist) {
                JOptionPane.showMessageDialog(null, "There is already a gradient-point existing with this grayvalue. Please enter another grayValue.", "Error", 0);
                return;
            }
            ++i;
        }
        this.selectedColorHist.setGrayValue(grayValue);
        this.colorPointsChanged = true;
        this.repaint();
    }

    public void deleteSelectedColorHist() {
        if (this.selectedColorHist == this.colorPoints.getFirst() || this.selectedColorHist == this.colorPoints.getLast()) {
            JOptionPane.showMessageDialog(null, "The first and the last gradient-points can't be deleted.", "Error", 0);
        } else {
            this.colorPoints.remove(this.selectedColorHist);
            this.selectedColorHist = null;
            this.tellListenerNoSelection();
            this.colorPointsChanged = true;
            this.repaint();
        }
    }

    public void deleteSelectedAlphaHist() {
        if (this.selectedAlphaHist == this.alphaPoints.getFirst() || this.selectedAlphaHist == this.alphaPoints.getLast()) {
            JOptionPane.showMessageDialog(null, "The first and the last gradient-points can't be deleted.", "Error", 0);
        } else {
            this.alphaPoints.remove(this.selectedAlphaHist);
            this.selectedAlphaHist = null;
            this.tellListenerNoAlphaSelection();
            this.colorPointsChanged = true;
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        ColorHist lastSelectedColorHist = this.selectedColorHist;
        AlphaHist lastSelectedAlphaHist = this.selectedAlphaHist;
        if (me.isControlDown()) {
            if (me.getPoint().y < offSetGP) {
                int mousePos = this.convertPoint(me.getPoint().x);
                AlphaHist chLeft = null;
                AlphaHist chRight = null;
                int i = 0;
                while (i < this.alphaPoints.size()) {
                    if (this.alphaPoints.get(i).getGrayValue() == mousePos) {
                        JOptionPane.showMessageDialog(null, "At this grayvalue there is an gradient-point already existing. You can't add a point at this grayvalue.", "Error", 0);
                        return;
                    }
                    chRight = this.alphaPoints.get(i);
                    if (chRight.getGrayValue() > mousePos) {
                        chLeft = this.alphaPoints.get(i - 1);
                        break;
                    }
                    ++i;
                }
                int distance = chRight.getGrayValue() - chLeft.getGrayValue();
                int pos = mousePos - chLeft.getGrayValue();
                double scaleRight = pos * 100 / distance;
                double scaleLeft = 100.0 - scaleRight;
                int transparency = (int)Math.round((double)chLeft.getTransparency() * scaleLeft / 100.0) + (int)Math.round((double)chRight.getTransparency() * scaleRight / 100.0);
                AlphaHist alphaHist = new AlphaHist(mousePos, transparency);
                this.alphaPoints.add(alphaHist);
                Collections.sort(this.alphaPoints);
                this.selectedColorHist = null;
                this.selectedAlphaHist = alphaHist;
                this.colorPointsChanged = true;
            } else if (me.getPoint().y > offSetGP + heightGP) {
                int mousePos = this.convertPoint(me.getPoint().x);
                ColorHist chLeft = null;
                ColorHist chRight = null;
                int i = 0;
                while (i < this.colorPoints.size()) {
                    if (this.colorPoints.get(i).getGrayValue() == mousePos) {
                        JOptionPane.showMessageDialog(null, "At this grayvalue there is an gradient-point already existing. You can't add a point at this grayvalue.", "Error", 0);
                        return;
                    }
                    chRight = this.colorPoints.get(i);
                    if (chRight.getGrayValue() > mousePos) {
                        chLeft = this.colorPoints.get(i - 1);
                        break;
                    }
                    ++i;
                }
                int pos = mousePos - chLeft.getGrayValue();
                Color color = this.interpolateColor(chLeft, chRight, pos);
                ColorHist colorHist = new ColorHist(this.convertPoint(me.getPoint().x), color);
                this.colorPoints.add(colorHist);
                Collections.sort(this.colorPoints);
                this.selectedColorHist = colorHist;
                this.colorPointsChanged = true;
            }
        } else if (me.getPoint().y < offSetGP) {
            this.selectedAlphaHist = this.getNearestAlphaHist(me.getPoint());
        } else if (me.getPoint().y > offSetGP + heightGP) {
            Color c;
            this.selectedColorHist = this.getNearestColorHist(me.getPoint());
            if (me.getClickCount() == 2 & this.selectedColorHist != null && (c = JColorChooser.showDialog(new JFrame(), "Select color...", this.selectedColorHist.getColor())) != null) {
                this.selectedColorHist.setColor(c);
                this.colorPointsChanged = true;
                this.tellListenerSelectionChanged();
            }
        }
        if (this.selectedColorHist != lastSelectedColorHist) {
            if (this.selectedColorHist == null) {
                this.tellListenerNoSelection();
            } else {
                this.tellListenerSelectionChanged();
            }
        }
        if (this.selectedAlphaHist != lastSelectedAlphaHist) {
            if (this.selectedAlphaHist == null) {
                this.tellListenerNoAlphaSelection();
            } else {
                this.tellListenerAlphaSelectionChanged();
            }
        }
        this.repaint();
    }

    private Color interpolateColor(ColorHist chLeft, ColorHist chRight, int pos) {
        Color leftColor = chLeft.getColor();
        Color rightColor = chRight.getColor();
        int distance = chRight.getGrayValue() - chLeft.getGrayValue();
        double scaleRight = pos * 100 / distance;
        double scaleLeft = 100.0 - scaleRight;
        int colorR = (int)Math.round((double)leftColor.getRed() * scaleLeft / 100.0) + (int)Math.round((double)rightColor.getRed() * scaleRight / 100.0);
        int colorG = (int)Math.round((double)leftColor.getGreen() * scaleLeft / 100.0) + (int)Math.round((double)rightColor.getGreen() * scaleRight / 100.0);
        int colorB = (int)Math.round((double)leftColor.getBlue() * scaleLeft / 100.0) + (int)Math.round((double)rightColor.getBlue() * scaleRight / 100.0);
        if (colorR > 255) {
            colorR = 255;
        }
        if (colorG > 255) {
            colorG = 255;
        }
        if (colorB > 255) {
            colorB = 255;
        }
        return new Color(colorR, colorG, colorB);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int pos = this.convertPoint(e.getPoint().x);
        if (e.getPoint().y < offSetGP) {
            int index = this.alphaPoints.indexOf(this.selectedAlphaHist);
            if (this.selectedAlphaHist != null & this.selectedAlphaHist != this.alphaPoints.getFirst() & this.selectedAlphaHist != this.alphaPoints.getLast()) {
                if (pos <= this.alphaPoints.get(index - 1).getGrayValue() + 1) {
                    pos = this.alphaPoints.get(index - 1).getGrayValue() + 1;
                } else if (pos >= this.alphaPoints.get(index + 1).getGrayValue() - 1) {
                    pos = this.alphaPoints.get(index + 1).getGrayValue() - 1;
                }
                this.selectedAlphaHist.setGrayValue(pos);
                this.colorPointsChanged = true;
                this.repaint();
                this.tellListenerAlphaSelectionChanged();
            }
        } else if (e.getPoint().y > offSetGP + heightGP) {
            int index = this.colorPoints.indexOf(this.selectedColorHist);
            if (this.selectedColorHist != null & this.selectedColorHist != this.colorPoints.getFirst() & this.selectedColorHist != this.colorPoints.getLast()) {
                if (pos <= this.colorPoints.get(index - 1).getGrayValue() + 1) {
                    pos = this.colorPoints.get(index - 1).getGrayValue() + 1;
                } else if (pos >= this.colorPoints.get(index + 1).getGrayValue() - 1) {
                    pos = this.colorPoints.get(index + 1).getGrayValue() - 1;
                }
                this.selectedColorHist.setGrayValue(pos);
                this.colorPointsChanged = true;
                this.repaint();
                this.tellListenerSelectionChanged();
            }
        }
    }

    public void mouseDragMoved(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public FloatBuffer getTransferFunction() {
        return null;
    }
}

