/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;

class ColorHist
implements Comparable<ColorHist> {
    private int grayValue;
    private int transparency;
    private Color color;

    public ColorHist(int grayValue, Color color) {
        this.grayValue = grayValue;
        this.color = color;
    }

    @Override
    public int compareTo(ColorHist colorHist) {
        int result = this.grayValue - colorHist.grayValue;
        return result;
    }

    public int getGrayValue() {
        return this.grayValue;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getTransparentColor() {
        int trans = Math.round(this.transparency * 255 / 100);
        if (trans < 1) {
            trans = 1;
        }
        if (trans > 255) {
            trans = 255;
        }
        return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), trans);
    }

    public int getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int transparency) {
        this.transparency = transparency;
    }

    public void setGrayValue(int grayValue) {
        this.grayValue = grayValue;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

