/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ColorChooserPanel
extends JPanel
implements MouseListener {
    private Color color = Color.white;
    private ActionListener listener;

    public ColorChooserPanel() {
        this.addMouseListener(this);
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setBackground(this.color);
    }

    public Color getColor() {
        return this.color;
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b) {
            this.setBackground(this.color);
        } else {
            this.setBackground(Color.LIGHT_GRAY);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        Color newColor;
        if (me.getClickCount() == 2 && (newColor = JColorChooser.showDialog(new JFrame(), "Select color...", this.color)) != null) {
            this.color = newColor;
            ActionEvent event = new ActionEvent(this, 23, "colorchooser changed");
            this.listener.actionPerformed(event);
            this.setBackground(this.color);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

