/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;

class AlphaHist
implements Comparable<AlphaHist> {
    private int grayValue;
    private int transparency;
    private Color color;

    public AlphaHist(int grayValue, int transparency) {
        this.grayValue = grayValue;
        this.transparency = transparency;
        this.color = this.getColor(transparency);
    }

    private Color getColor(int transparency) {
        transparency = 100 - transparency;
        Color leftColor = Color.BLACK;
        Color rightColor = Color.WHITE;
        int distance = 100;
        double scaleRight = transparency * 100 / distance;
        double scaleLeft = 100.0 - scaleRight;
        int colorR = (int)Math.round((double)leftColor.getRed() * scaleLeft / 100.0) + (int)Math.round((double)rightColor.getRed() * scaleRight / 100.0);
        int colorG = (int)Math.round((double)leftColor.getGreen() * scaleLeft / 100.0) + (int)Math.round((double)rightColor.getGreen() * scaleRight / 100.0);
        int colorB = (int)Math.round((double)leftColor.getBlue() * scaleLeft / 100.0) + (int)Math.round((double)rightColor.getBlue() * scaleRight / 100.0);
        return new Color(colorR, colorG, colorB);
    }

    @Override
    public int compareTo(AlphaHist colorHist) {
        int result = this.grayValue - colorHist.grayValue;
        return result;
    }

    public int getGrayValue() {
        return this.grayValue;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public Color getColor() {
        return this.color;
    }

    public void setGrayValue(int grayValue) {
        this.grayValue = grayValue;
    }

    public void setTransparency(int transparency) {
        this.transparency = transparency;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

