/*
 * Decompiled with CFR 0.152.
 */
package glcanvas.data;

public class Vec3 {
    private float x;
    private float y;
    private float z;

    public Vec3() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vec3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3(Vec3 vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public float get(int i) {
        if (i == 0) {
            return this.x;
        }
        if (i == 1) {
            return this.y;
        }
        return this.z;
    }

    public void add(Vec3 vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
    }

    public void subtract(Vec3 vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
    }

    public void subtract(Vec3 vec1, Vec3 vec2) {
        this.x = vec1.x - vec2.x;
        this.y = vec1.y - vec2.y;
        this.z = vec1.z - vec2.z;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public static Vec3 addVec3(Vec3 vec1, Vec3 vec2) {
        Vec3 result = new Vec3();
        result.x = vec1.x + vec2.x;
        result.y = vec1.y + vec2.y;
        result.z = vec1.z + vec2.z;
        return result;
    }

    public Vec3 normalize() {
        float l = this.length();
        return new Vec3(this.x / l, this.y / l, this.z / l);
    }

    public void norm() {
        float l = this.length();
        this.x /= l;
        this.y /= l;
        this.z /= l;
    }

    public float length() {
        return (float)Math.sqrt(this.sqLength());
    }

    public float sqLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distance(Vec3 vec) {
        Vec3 diff = new Vec3(this.x - vec.x, this.y - vec.y, this.z - vec.z);
        return diff.length();
    }

    public Vec3 minus(Vec3 pos2) {
        return new Vec3(this.x - pos2.x, this.y - pos2.y, this.z - pos2.z);
    }

    public void multiply(float num) {
        this.x *= num;
        this.y *= num;
        this.z *= num;
    }

    public static Vec3 multiply(Vec3 vec, float num) {
        return new Vec3(vec.x *= num, vec.y *= num, vec.z *= num);
    }
}

