/*
 * Decompiled with CFR 0.152.
 */
package glcanvas.data;

public class Interpolation {
    public static final byte NW = 0;
    public static final byte SW = 1;
    public static final byte SE = 2;
    public static final byte NE = 3;
    private int[] neighbors;
    private float[] coeffs;

    public Interpolation() {
        this.neighbors = new int[4];
        this.neighbors[0] = -1;
        this.neighbors[1] = -1;
        this.neighbors[2] = -1;
        this.neighbors[3] = -1;
        this.coeffs = new float[4];
        this.coeffs[0] = 0.0f;
        this.coeffs[1] = 0.0f;
        this.coeffs[2] = 0.0f;
        this.coeffs[3] = 0.0f;
    }

    public Interpolation(int[] neighbors, float[] coeffs) {
        this.neighbors = neighbors;
        this.coeffs = coeffs;
    }

    public void setNorthWestNeighbor(int id) {
        this.neighbors[0] = id;
    }

    public void setSouthWestNeighbor(int id) {
        this.neighbors[1] = id;
    }

    public void setSouthEastNeighbor(int id) {
        this.neighbors[2] = id;
    }

    public void setNorthEastNeighbor(int id) {
        this.neighbors[3] = id;
    }

    public void setNorthWestCoeff(float weight) {
        this.coeffs[0] = weight;
    }

    public void setSouthWestCoeff(float weight) {
        this.coeffs[1] = weight;
    }

    public void setSouthEastCoeff(float weight) {
        this.coeffs[2] = weight;
    }

    public void setNorthEastCoeff(float weight) {
        this.coeffs[3] = weight;
    }

    public void setNeighbors(int[] neighbors) {
        this.neighbors = neighbors;
    }

    public void setCoeffs(float[] coeffs) {
        this.coeffs = coeffs;
    }

    public int getNorthWestNeighbor() {
        return this.neighbors[0];
    }

    public int getSouthWestNeighbor() {
        return this.neighbors[1];
    }

    public int getSouthEastNeighbor() {
        return this.neighbors[2];
    }

    public int getNorthEastNeighbor() {
        return this.neighbors[3];
    }

    public float getNorthWestCoeff() {
        return this.coeffs[0];
    }

    public float getSouthWestCoeff() {
        return this.coeffs[1];
    }

    public float getSouthEastCoeff() {
        return this.coeffs[2];
    }

    public float getNorthEastCoeff() {
        return this.coeffs[3];
    }

    public int[] getNeighbors() {
        return this.neighbors;
    }

    public float[] getCoeffs() {
        return this.coeffs;
    }
}

