/*
 * Decompiled with CFR 0.152.
 */
package glcanvas.data;

import glcanvas.data.Interpolation;
import glcanvas.data.Vec3;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Scanner;

public class FlowGeometry {
    private static final int X_DIM = 0;
    private static final int Y_DIM = 1;
    private static final int Z_DIM = 2;
    public boolean isFlipped = false;
    private int[] dim = new int[3];
    private int numChannels;
    private int nt;
    private float dt;
    private Vec3[] geometryData = null;
    private Vec3 boundaryMin;
    private Vec3 boundaryMax;
    private Vec3 boundarySize;

    public FlowGeometry(File file, boolean bigEndian) throws FileNotFoundException, IOException {
        System.out.println("Reading file: " + file.getAbsolutePath() + "...");
        this.readHeader(file);
        this.readDataFile(file);
        this.flippedData();
    }

    private void readHeader(File file) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        byte[] bytes = new byte[28];
        stream.read(bytes);
        Scanner scan = new Scanner(new String(bytes));
        scan.next();
        this.dim[0] = scan.nextInt();
        this.dim[1] = scan.nextInt();
        this.dim[2] = scan.nextInt();
        this.numChannels = scan.nextInt();
        this.nt = scan.nextInt();
        try {
            this.dt = Float.parseFloat(scan.next());
        }
        catch (NumberFormatException nfe) {
            this.dt = 0.01f;
            System.out.println("Invalid value " + nfe.getMessage());
        }
        scan.close();
        System.out.println("x: " + this.dim[0] + " y: " + this.dim[1] + " z: " + this.dim[2]);
        System.out.println("NF: " + this.numChannels + " NT: " + this.nt + " DT " + this.dt);
        if (this.dim[2] != 1) {
            throw new IOException("The Z-Dimension is invalid!");
        }
    }

    private void readDataFile(File file) throws IOException {
        this.geometryData = new Vec3[this.dim[0] * this.dim[1]];
        byte[] bytes = new byte[4];
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        stream.skip(40L);
        int i = 0;
        while (i < this.geometryData.length) {
            this.geometryData[i] = new Vec3();
            stream.read(bytes);
            this.geometryData[i].setX(this.convertToFloat(bytes));
            stream.read(bytes);
            this.geometryData[i].setY(this.convertToFloat(bytes));
            stream.read(bytes);
            this.geometryData[i].setZ(this.convertToFloat(bytes));
            ++i;
        }
        this.boundaryMin = this.geometryData[0];
        this.boundaryMax = this.geometryData[this.geometryData.length - 1];
        System.out.println("min x: " + this.boundaryMin.getX() + " min y: " + this.boundaryMin.getY() + " min z: " + this.boundaryMin.getZ());
        System.out.println("max x: " + this.boundaryMax.getX() + " max y: " + this.boundaryMax.getY() + " max z: " + this.boundaryMax.getZ());
    }

    private void flippedData() throws IOException {
        this.boundarySize = new Vec3();
        if (this.boundaryMin == null) {
            throw new IOException("Boundary min is null.");
        }
        if (this.boundaryMax == null) {
            throw new IOException("Boundary max is null.");
        }
        this.boundarySize.subtract(this.boundaryMin, this.boundaryMax);
        System.out.println(this.boundarySize);
        if ((double)this.geometryData[this.dim[0] - 1].getY() > (double)(this.boundaryMin.getY() + this.boundaryMax.getY()) * 0.5) {
            this.isFlipped = true;
            System.out.println("X and Y dimensions are flipped!");
        } else {
            this.isFlipped = false;
        }
    }

    private float convertToFloat(byte[] bytes) {
        byte[] swapedBytes = new byte[]{bytes[3], bytes[2], bytes[1], bytes[0]};
        ByteBuffer bb = ByteBuffer.wrap(swapedBytes);
        return bb.getFloat();
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public int[] getBounds() {
        return this.dim;
    }

    public int getDimX() {
        return this.dim[0];
    }

    public int getDimY() {
        return this.dim[1];
    }

    public Vec3 getMin() {
        return this.geometryData[0];
    }

    public Vec3 getMax() {
        return this.geometryData[this.geometryData.length - 1];
    }

    public Vec3 getValueAt(int id) {
        if (id == -1 || id >= this.geometryData.length) {
            return null;
        }
        return this.geometryData[id];
    }

    public Vec3 getValueAt(int x, int y) {
        int id = this.getVtxIdx(x, y);
        return this.getValueAt(id);
    }

    public int getVtxIdx(int x, int y) {
        if (x < 0 || x >= this.dim[0]) {
            return -1;
        }
        if (y < 0 || y >= this.dim[1]) {
            return -1;
        }
        return this.isFlipped ? x * this.dim[0] + y : y * this.dim[0] + x;
    }

    public Interpolation getNeighbors(Vec3 pos) {
        float xC = pos.getX();
        float yC = pos.getY();
        float dist = 0.0f;
        float minDist = Float.MAX_VALUE;
        int vtxX = 0;
        int vtxY = 0;
        int x = 0;
        while (x < this.getDimX()) {
            dist = xC - this.getValueAt(x, 0).getX();
            if (dist >= 0.0f && dist < minDist) {
                minDist = dist;
                vtxX = x;
            }
            ++x;
        }
        minDist = Float.MAX_VALUE;
        int y = 0;
        while (y < this.getDimY()) {
            dist = yC - this.getValueAt(vtxX, y).getY();
            if (dist >= 0.0f && dist < minDist) {
                minDist = dist;
                vtxY = y;
            }
            ++y;
        }
        int[] neigh = new int[]{this.getVtxIdx(vtxX, vtxY), this.getVtxIdx(vtxX, vtxY + 1), this.getVtxIdx(vtxX + 1, vtxY + 1), this.getVtxIdx(vtxX + 1, vtxY)};
        float[] coeffs = this.getInterpolationCoeffsAt(pos, neigh);
        return new Interpolation(neigh, coeffs);
    }

    public float[] getInterpolationCoeffsAt(Vec3 pos, int[] neighbors) {
        float[] coeffs = new float[4];
        float xi = 1.0f;
        float yi = 1.0f;
        Vec3 nw = this.getValueAt(neighbors[0]);
        if (neighbors[1] != -1) {
            Vec3 sw = this.getValueAt(neighbors[1]);
            yi = (pos.getY() - nw.getY()) / (sw.getY() - nw.getY());
        }
        if (neighbors[3] != -1) {
            Vec3 ne = this.getValueAt(neighbors[3]);
            xi = (pos.getX() - nw.getX()) / (ne.getX() - nw.getX());
        }
        if (0.0f > xi || 1.0f < xi) {
            System.out.println("weight of x is out of bounds: " + xi);
        }
        if (0.0f > yi || 1.0f < yi) {
            System.out.println("weight of y is out of bounds: " + yi);
        }
        coeffs[0] = xi * yi;
        coeffs[1] = xi * (1.0f - yi);
        coeffs[2] = (1.0f - xi) * (1.0f - yi);
        coeffs[3] = (1.0f - xi) * yi;
        return coeffs;
    }

    public Vec3 getNormCoords(Vec3 pos) {
        Vec3 min = this.geometryData[0];
        Vec3 max = this.geometryData[this.geometryData.length - 1];
        pos.setX((pos.getX() - min.getX()) / (max.getX() - min.getX()));
        pos.setY((pos.getY() - min.getY()) / (max.getY() - min.getY()));
        pos.setZ((pos.getZ() - min.getZ()) / (max.getZ() - min.getZ()));
        return pos;
    }

    public boolean within(Vec3 pos) {
        return !(pos.getX() < this.boundaryMin.getX() || pos.getX() > this.boundaryMax.getX() || pos.getY() < this.boundaryMin.getY()) && !(pos.getY() > this.boundaryMax.getY());
    }
}

