/*
 * Decompiled with CFR 0.152.
 */
package glcanvas.data;

import glcanvas.data.FlowChannel;
import glcanvas.data.FlowGeometry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FlowData {
    FlowChannel[] channels = null;
    FlowGeometry geometry = null;

    public FlowData(File file, boolean bigEndian) throws IOException {
        String dir = file.getParent();
        String filename = file.getName();
        String gridFilename = String.valueOf(filename.substring(0, filename.indexOf("."))) + ".gri";
        File gridFile = new File(String.valueOf(dir) + File.separatorChar + gridFilename);
        if (!gridFile.exists()) {
            throw new IOException("Gridfile: " + gridFilename + " does not exist.");
        }
        this.geometry = new FlowGeometry(gridFile, bigEndian);
        this.channels = new FlowChannel[this.geometry.getNumChannels() + 3];
        int i = 0;
        while (i < this.channels.length) {
            this.channels[i] = new FlowChannel(this.geometry);
            ++i;
        }
        this.readDataFile(file, this.geometry);
    }

    private void readDataFile(File file, FlowGeometry geometry) throws IOException {
        byte[] bytes = new byte[4];
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        int dim = geometry.getDimX() * geometry.getDimY();
        int i = 0;
        while (i < dim) {
            int cn = 0;
            while (cn < this.channels.length) {
                stream.read(bytes);
                this.channels[cn].setValue(i, this.convertToFloat(bytes));
                ++cn;
            }
            ++i;
        }
        i = 0;
        while (i < this.channels.length) {
            System.out.println("Channel " + (i + 1) + " min: " + this.channels[i].getMin() + " max: " + this.channels[i].getMax());
            ++i;
        }
    }

    private float convertToFloat(byte[] bytes) {
        byte[] swapedBytes = new byte[]{bytes[3], bytes[2], bytes[1], bytes[0]};
        ByteBuffer bb = ByteBuffer.wrap(swapedBytes);
        return bb.getFloat();
    }

    public FlowGeometry getGeometry() {
        return this.geometry;
    }

    public FlowChannel[] getChannels() {
        return this.channels;
    }

    public FlowChannel getChannelAt(int idx) {
        if (idx < 0 || idx > this.channels.length) {
            return null;
        }
        return this.channels[idx];
    }
}

