/*
 * Decompiled with CFR 0.152.
 */
package glcanvas.data;

import glcanvas.data.FlowGeometry;
import glcanvas.data.Interpolation;

public class FlowChannel {
    private float[] values = null;
    private float min;
    private float max;
    private FlowGeometry geometry;

    public FlowChannel() {
        this.geometry = null;
        this.min = Float.MAX_VALUE;
        this.max = -3.4028235E38f;
    }

    public FlowChannel(FlowGeometry geometry) {
        this.geometry = geometry;
        this.values = new float[geometry.getDimX() * geometry.getDimY()];
        this.min = Float.MAX_VALUE;
        this.max = -3.4028235E38f;
    }

    public void setValue(int vtxID, float value) {
        if (vtxID > this.values.length) {
            System.out.println("Vertex index: " + vtxID + " outside the grid dimensions");
            return;
        }
        this.values[vtxID] = value;
        this.updateMinMax(value);
    }

    public void copyValues(float[] rawData, int vtxSize, int offset) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = rawData[i * vtxSize + offset];
            this.updateMinMax(this.values[i]);
            ++i;
        }
    }

    public float getValueAt(int pos) {
        return this.values[pos];
    }

    public float getValueAt(int x, int y) {
        int id = this.getVtxID(x, y);
        if (id == -1) {
            return -1.0f;
        }
        return this.values[id];
    }

    public int getVtxID(int x, int y) {
        if (x < 0 || x >= this.geometry.getDimX()) {
            System.out.println("x: " + x + " is out of bounds (max): " + this.geometry.getDimX());
            return -1;
        }
        if (y < 0 || y >= this.geometry.getDimY()) {
            System.out.println("y: " + y + " is out of bounds (max): " + this.geometry.getDimY());
            return -1;
        }
        return this.geometry.isFlipped ? x * this.geometry.getDimX() + y : y * this.geometry.getDimX() + x;
    }

    public float getNormValueAt(int x, int y) {
        return (this.getValueAt(x, y) - this.min) / (this.max - this.min);
    }

    public float getNormValueAt(int pos) {
        return (this.getValueAt(pos) - this.min) / (this.max - this.min);
    }

    public float getInterpolatedValue(Interpolation ipol) {
        int[] neighbors = ipol.getNeighbors();
        float[] coeffs = ipol.getCoeffs();
        float val = coeffs[0] == 0.0f ? 0.0f : this.getValueAt(neighbors[0]) * coeffs[0];
        val += coeffs[1] == 0.0f ? 0.0f : this.getValueAt(neighbors[1]) * coeffs[1];
        val += coeffs[2] == 0.0f ? 0.0f : this.getValueAt(neighbors[2]) * coeffs[2];
        return val += coeffs[3] == 0.0f ? 0.0f : this.getValueAt(neighbors[3]) * coeffs[3];
    }

    public float getNormInterpolatedValue(Interpolation ipol) {
        int[] neighbors = ipol.getNeighbors();
        float[] coeffs = ipol.getCoeffs();
        float val = coeffs[0] == 0.0f ? 0.0f : this.getNormValueAt(neighbors[0]) * coeffs[0];
        val += coeffs[1] == 0.0f ? 0.0f : this.getNormValueAt(neighbors[1]) * coeffs[1];
        val += coeffs[2] == 0.0f ? 0.0f : this.getNormValueAt(neighbors[2]) * coeffs[2];
        return val += coeffs[3] == 0.0f ? 0.0f : this.getNormValueAt(neighbors[3]) * coeffs[3];
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public float getRange() {
        return this.max - this.min;
    }

    public FlowGeometry getGeometry() {
        return this.geometry;
    }

    private void updateMinMax(float value) {
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
    }
}

