/*
 * Decompiled with CFR 0.152.
 */
package glcanvas;

import glcanvas.ArrowPlot;
import glcanvas.ChannelVisualisation;
import glcanvas.SpacedStreamlines;
import glcanvas.Streamlines;
import glcanvas.data.FlowData;
import glcanvas.data.Vec3;
import glcanvas.data.Vec4;
import gui.ImageSaver;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;

public class VisCanvas
implements GLEventListener {
    private static final long serialVersionUID = 4522753397996321426L;
    public static final int X_DIR = 0;
    public static final int Y_DIR = 1;
    public static final int Z_DIR = 2;
    public static final int SLICING = 0;
    public static final int MIP = 1;
    public static final int ACCUMULATE = 2;
    public static final float EYE_X_INIT = 0.0f;
    public static final float EYE_Y_INIT = 0.0f;
    public static final float EYE_Z_INIT = 10.0f;
    public static final float ROTATE_X_INIT = 0.0f;
    public static final float ROTATE_Y_INIT = 0.0f;
    public static final float ROTATE_Z_INIT = 0.0f;
    public static final int VOLUME_TEX = 0;
    public static final int GRADIENT_TEX = 1;
    public static final float BG = 0.0f;
    public static int canvasPOTWidth;
    public static int canvasPOTHeight;
    public static int canvasWidth;
    public static int canvasHeight;
    private static FlowData flowData;
    private static boolean newFlowData;
    private static ArrowPlot arrowPlot;
    private static Streamlines streamlines;
    private static SpacedStreamlines spacedLines;
    private static ChannelVisualisation chVis;
    private boolean showBackground = true;
    private boolean showArrows = true;
    private boolean showStreamlines = false;
    private boolean showEvenlySpaced = true;
    private static Vec3 sizeFlowData;
    private int[] volumeTex = new int[2];
    private static int[] transTex;
    private int rendering;
    private float[] texCoord = new float[3];
    private float[] sliceCoord = new float[3];
    private float[] texSize = new float[3];
    private float[] eye = new float[3];
    private float[] camOffset = new float[3];
    private static float[] rotate;
    private int currentDir;
    private float canvasRatio;
    private int lastMouseX;
    private int lastMouseY;
    private GLU glu;
    private int glError;
    private boolean saveImage;
    private String fileName;

    static {
        flowData = null;
        arrowPlot = null;
        streamlines = null;
        spacedLines = null;
        chVis = null;
        transTex = new int[1];
        rotate = new float[3];
    }

    public VisCanvas() {
        this.volumeTex[0] = 0;
        this.glu = new GLU();
        newFlowData = false;
        this.texCoord[0] = 0.0f;
        this.texCoord[1] = 0.0f;
        this.texCoord[2] = 0.0f;
        this.sliceCoord[0] = 0.0f;
        this.sliceCoord[1] = 0.0f;
        this.sliceCoord[2] = 0.0f;
        this.texSize[0] = 1.0f;
        this.texSize[1] = 1.0f;
        this.texSize[2] = 1.0f;
        this.eye[0] = 0.0f;
        this.eye[1] = 0.0f;
        this.eye[2] = 10.0f;
        this.camOffset[0] = 0.0f;
        this.camOffset[1] = 0.0f;
        this.camOffset[2] = 0.0f;
        VisCanvas.rotate[0] = 0.0f;
        VisCanvas.rotate[1] = 0.0f;
        VisCanvas.rotate[2] = 0.0f;
        this.lastMouseX = 0;
        this.lastMouseY = 0;
        this.currentDir = 2;
        this.rendering = 0;
        this.glError = 0;
    }

    public static void setFlowData(FlowData fData) {
        System.out.println("Flow Data added...");
        flowData = fData;
        newFlowData = true;
        arrowPlot = new ArrowPlot(fData.getChannels());
        chVis = new ChannelVisualisation(fData.getChannels());
        streamlines = new Streamlines(fData.getChannels());
        spacedLines = new SpacedStreamlines(fData.getChannels());
        sizeFlowData = flowData.getGeometry().getMax();
    }

    public void setTexCoord(int coord) {
        this.texCoord[0] = 0.0f;
        this.texCoord[1] = 0.0f;
        this.texCoord[2] = 0.0f;
        this.sliceCoord[0] = 0.0f;
        this.sliceCoord[1] = 0.0f;
        this.sliceCoord[2] = 0.0f;
        this.texCoord[this.currentDir] = (float)coord / 100.0f * this.texSize[this.currentDir];
        this.sliceCoord[this.currentDir] = (float)coord / 50.0f - 1.0f;
    }

    public void setRendering(int rendering) {
        this.rendering = rendering;
    }

    public void saveImage(String fileName) {
        this.saveImage = true;
        this.fileName = fileName;
    }

    public void flushCamera() {
        this.eye[0] = 0.0f;
        this.eye[1] = 0.0f;
        this.eye[2] = 10.0f;
        VisCanvas.rotate[0] = 0.0f;
        VisCanvas.rotate[1] = 0.0f;
        VisCanvas.rotate[2] = 0.0f;
        this.camOffset[0] = 0.0f;
        this.camOffset[1] = 0.0f;
        this.camOffset[2] = 0.0f;
    }

    private int getNextPowerOfTwo(int number) {
        int power = 1;
        while (power < number) {
            power *= 2;
        }
        return power;
    }

    public void changeDirection(int direction) {
        if (direction < 0 || direction > 2) {
            System.out.println("The direction: " + direction + " is not defined!");
        } else {
            this.currentDir = direction;
        }
    }

    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        gl.glClear(16640);
        gl.glPushMatrix();
        gl.glRotatef(rotate[0], 0.0f, 1.0f, 0.0f);
        gl.glRotatef(rotate[1], 1.0f, 0.0f, 0.0f);
        gl.glRotatef(rotate[2], 0.0f, 0.0f, 1.0f);
        if (flowData != null && newFlowData) {
            if (VisCanvas.flowData.getGeometry().isFlipped) {
                gl.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
            }
            gl.glTranslatef(-sizeFlowData.getX() / 2.0f, -sizeFlowData.getY() / 2.0f, 0.0f);
            if (this.showBackground) {
                chVis.drawChannelData(gl);
            }
            if (this.showArrows) {
                arrowPlot.drawPointsSoftware(gl);
            }
            if (this.showStreamlines) {
                if (this.showEvenlySpaced) {
                    spacedLines.drawSpacedStreamlines(gl);
                } else {
                    streamlines.drawStreamlines(gl);
                }
            }
        }
        gl.glPopMatrix();
        gl.glFlush();
        gl.glLoadIdentity();
        this.glu.gluLookAt((double)this.eye[0], (double)this.eye[1], (double)this.eye[2], (double)this.camOffset[0], (double)this.camOffset[1], (double)this.camOffset[0], 0.0, 1.0, 0.0);
        if (this.saveImage) {
            new ImageSaver(gl, this.fileName, canvasWidth, canvasHeight);
            this.saveImage = false;
        }
    }

    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    public void init(GLAutoDrawable drawable) {
        System.out.println("initializing GL...");
        GL gl = drawable.getGL();
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glShadeModel(7425);
        gl.glHint(3152, 4354);
        this.glError = 0;
        this.glError = gl.glGetError();
        if (this.glError != 0) {
            System.out.println("Error while initializing GL: " + this.glu.gluErrorString(this.glError));
        } else {
            System.out.println("GL initialized CORRECTLY...");
        }
    }

    public void zoomObject(int direction) {
        this.eye[2] = (float)((double)this.eye[2] + (double)direction * 0.2);
    }

    public void translateObject(int x, int y) {
        int diffX = x - this.lastMouseX;
        int diffY = y - this.lastMouseY;
        float addX = 0.0f;
        float addY = 0.0f;
        if (Math.abs(diffX) < 50) {
            addX = (float)diffX * 0.01f;
        }
        if (Math.abs(diffY) < 50) {
            addY = (float)diffY * 0.01f;
        }
        this.eye[0] = this.eye[0] - addX;
        this.eye[1] = this.eye[1] + addY;
        this.camOffset[0] = this.camOffset[0] - addX;
        this.camOffset[1] = this.camOffset[1] + addY;
        this.lastMouseX = x;
        this.lastMouseY = y;
    }

    public void rotateObject(int x, int y) {
        int diffX = x - this.lastMouseX;
        int diffY = y - this.lastMouseY;
        float addX = 0.0f;
        float addY = 0.0f;
        if (Math.abs(diffX) < 50) {
            addX = (float)diffX * 0.4f;
        }
        if (Math.abs(diffY) < 50) {
            addY = (float)diffY * 0.4f;
        }
        rotate[0] = rotate[0] + addX;
        rotate[1] = rotate[1] + addY;
        this.lastMouseX = x;
        this.lastMouseY = y;
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL gl = drawable.getGL();
        canvasWidth = width;
        canvasHeight = height;
        canvasPOTWidth = this.getNextPowerOfTwo(width);
        canvasPOTHeight = this.getNextPowerOfTwo(height);
        if (canvasHeight == 0) {
            canvasHeight = 1;
        }
        this.canvasRatio = 1.0f * (float)canvasWidth / (float)canvasHeight;
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glViewport(0, 0, canvasWidth, canvasHeight);
        this.glu.gluPerspective(50.0, (double)this.canvasRatio, 0.0, 20.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.glu.gluLookAt((double)this.eye[0], (double)this.eye[1], (double)this.eye[2], 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        System.out.println("canvas reshaped...");
    }

    public void setPlanarView(boolean planarView) {
        this.flushCamera();
    }

    public static void setTransTex(int[] tt) {
        transTex = tt;
    }

    public void transferFunctionChanged(int index, Vec4[] array) {
        chVis.setTransferFunction(index, array);
        System.out.println("transfer changed...");
    }

    public void showBackground(boolean sb) {
        this.showBackground = sb;
    }

    public void showArrows(boolean sa) {
        this.showArrows = sa;
    }

    public void showStreamlines(boolean ss) {
        this.showStreamlines = ss;
    }

    public void showEvenlySpaced(boolean es) {
        this.showEvenlySpaced = es;
    }

    public void updateRenderChannel(int index, boolean visible) {
        chVis.updateRenderChannel(index, visible);
    }
}

