/*
 * Decompiled with CFR 0.152.
 */
package glcanvas;

import com.sun.opengl.util.BufferUtil;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;

public class TextureReader {
    public static ByteBuffer readTexture(String filename) throws IOException {
        return TextureReader.readTexture(filename, false);
    }

    public static ByteBuffer readTexture(String filename, boolean alphaChannel) throws IOException {
        BufferedImage image = TextureReader.readImage(filename);
        return TextureReader.readData(image, alphaChannel);
    }

    public static BufferedImage readImage(String filename) throws IOException {
        return ImageIO.read(TextureReader.getResourceAsStream(filename));
    }

    public static InputStream getResourceAsStream(String filename) throws IOException {
        String convertedFileName = filename.replace('\\', '/');
        InputStream stream = TextureReader.class.getClassLoader().getResourceAsStream(convertedFileName);
        if (stream == null) {
            return new FileInputStream(convertedFileName);
        }
        return stream;
    }

    public static ByteBuffer readData(BufferedImage image, boolean alphaChannel) {
        int[] packedPixels = new int[image.getWidth() * image.getHeight()];
        PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, image.getWidth(), image.getHeight(), packedPixels, 0, image.getWidth());
        try {
            pixelgrabber.grabPixels();
        }
        catch (InterruptedException e) {
            throw new RuntimeException();
        }
        int bytesPerPixel = alphaChannel ? 4 : 3;
        ByteBuffer unpackedPixels = BufferUtil.newByteBuffer((int)(packedPixels.length * bytesPerPixel));
        int row = image.getHeight() - 1;
        while (row >= 0) {
            int col = 0;
            while (col < image.getWidth()) {
                int packedPixel = packedPixels[row * image.getWidth() + col];
                unpackedPixels.put((byte)(packedPixel >> 16 & 0xFF));
                unpackedPixels.put((byte)(packedPixel >> 8 & 0xFF));
                unpackedPixels.put((byte)(packedPixel >> 0 & 0xFF));
                if (alphaChannel) {
                    unpackedPixels.put((byte)(packedPixel >> 24 & 0xFF));
                }
                ++col;
            }
            --row;
        }
        unpackedPixels.flip();
        return unpackedPixels;
    }
}

