/*
 * Decompiled with CFR 0.152.
 */
package glcanvas;

import glcanvas.data.FlowChannel;
import glcanvas.data.FlowGeometry;
import glcanvas.data.Interpolation;
import glcanvas.data.Vec3;
import glcanvas.data.Vec4;
import javax.media.opengl.GL;

public class Streamlines {
    private static float step;
    private static float maxLine;
    private static Vec4 color;
    private static boolean changes;
    private float maxLength;
    private float[] startPos;
    private int lineList;
    private FlowGeometry geometry;
    private FlowChannel[] channels;
    private Vec3 minG;
    private Vec3 maxG;

    public Streamlines(FlowChannel[] channels) {
        this.channels = channels;
        this.geometry = channels[0].getGeometry();
        this.minG = this.geometry.getMin();
        this.maxG = this.geometry.getMax();
        step = 0.1f;
        maxLine = 1000.0f;
        changes = true;
        color = new Vec4(1.0f, 1.0f, 1.0f, 1.0f);
        float range = this.maxG.getX() - this.minG.getX();
        this.startPos = new float[Math.round(range / step)];
        float pos = this.minG.getX();
        int i = 0;
        while (i < this.startPos.length) {
            this.startPos[i] = pos;
            ++i;
            pos += step * 2.0f;
        }
        Vec3 vec = new Vec3();
        float l = 0.0f;
        int x = 0;
        while (x < this.geometry.getDimX()) {
            int y = 0;
            while (y < this.geometry.getDimY()) {
                vec.setX(channels[0].getValueAt(x, y));
                vec.setY(channels[1].getValueAt(x, y));
                vec.setZ(channels[2].getValueAt(x, y));
                l = vec.length();
                if (this.maxLength < l) {
                    this.maxLength = l;
                }
                ++y;
            }
            ++x;
        }
        System.out.println("Number of start positions: " + this.startPos.length);
    }

    public void drawStreamlines(GL gl) {
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        if (changes) {
            this.drawLines(gl);
            changes = false;
        } else {
            gl.glCallList(this.lineList);
        }
        gl.glDisable(3042);
    }

    private void drawLines(GL gl) {
        this.lineList = gl.glGenLists(1);
        gl.glNewList(this.lineList, 4864);
        Vec3 mean = this.maxG.minus(this.minG);
        mean.multiply(0.5f);
        int i = 0;
        while (i < this.startPos.length) {
            this.drawEulerLine(gl, new Vec3(this.startPos[i], this.minG.getY(), this.minG.getZ()), -1);
            this.drawEulerLine(gl, new Vec3(this.startPos[i], this.minG.getY(), this.minG.getZ()), 1);
            this.drawEulerLine(gl, new Vec3(this.startPos[i], mean.getY(), this.minG.getZ()), 1);
            this.drawEulerLine(gl, new Vec3(this.startPos[i], mean.getY(), this.minG.getZ()), -1);
            this.drawEulerLine(gl, new Vec3(mean.getX(), this.startPos[i], this.minG.getZ()), 1);
            this.drawEulerLine(gl, new Vec3(mean.getX(), this.startPos[i], this.minG.getZ()), -1);
            ++i;
        }
        gl.glEndList();
    }

    private void drawEulerLine(GL gl, Vec3 pos, int fwd) {
        Interpolation ipol = this.geometry.getNeighbors(pos);
        Vec3 dir = new Vec3();
        gl.glLineWidth(2.0f);
        gl.glBegin(3);
        float l = 0.5f;
        int i = 0;
        while ((float)i < maxLine) {
            dir = new Vec3(this.channels[0].getInterpolatedValue(ipol), this.channels[1].getInterpolatedValue(ipol), this.channels[2].getInterpolatedValue(ipol));
            l = dir.length() / this.maxLength;
            gl.glColor4f(color.getX(), color.getY(), color.getZ(), l);
            gl.glVertex3f(pos.getX(), pos.getY(), pos.getZ());
            dir.norm();
            dir.multiply(step * (float)fwd);
            pos.add(dir);
            if (!this.geometry.within(pos)) break;
            ipol = this.geometry.getNeighbors(pos);
            ++i;
        }
        gl.glEnd();
    }

    public static void setColor(Vec4 col) {
        color = col;
        Streamlines.update();
    }

    public static void setStep(int val) {
        step = (float)val / 1000.0f;
        Streamlines.update();
    }

    private static void update() {
        changes = true;
    }
}

