/*
 * Decompiled with CFR 0.152.
 */
package glcanvas;

import glcanvas.data.FlowChannel;
import glcanvas.data.FlowGeometry;
import glcanvas.data.Interpolation;
import glcanvas.data.Vec3;
import glcanvas.data.Vec4;
import java.util.Iterator;
import java.util.LinkedList;
import javax.media.opengl.GL;

public class SpacedStreamlines {
    private static final int MAX_TIMEOUT = 5;
    private static final int EULER = 0;
    private static final int RUNGE = 1;
    private static final int BOTH = 2;
    private static float dsep;
    private static float dtest;
    private static float step;
    private static float maxLine;
    private static float maxVecLength;
    private static int timeout;
    private static int integrationMethod;
    private static boolean changes;
    private static boolean showSeeds;
    private static Vec4 color;
    private int lineList;
    private int xdim;
    private int ydim;
    private Vec3[][] grid;
    private Vec3 range;
    private FlowGeometry geometry;
    private FlowChannel[] channels;
    private LinkedList<LinkedList<Vec3>> seedPoints;
    private Vec3 minG;
    private Vec3 maxG;

    public SpacedStreamlines(FlowChannel[] channels) {
        this.channels = channels;
        this.geometry = channels[0].getGeometry();
        this.minG = this.geometry.getMin();
        this.range = this.maxG = this.geometry.getMax();
        this.range.subtract(this.minG);
        dsep = 0.5f;
        dtest = 0.5f;
        step = 0.05f;
        maxLine = 500.0f;
        changes = true;
        showSeeds = false;
        timeout = 5;
        integrationMethod = 0;
        color = new Vec4(1.0f, 1.0f, 1.0f, 1.0f);
        this.xdim = (int)Math.ceil(this.range.getX() / dsep);
        this.ydim = (int)Math.ceil(this.range.getY() / dsep);
        this.seedPoints = new LinkedList();
        Vec3 vec = new Vec3();
        float l = 0.0f;
        int x = 0;
        while (x < this.geometry.getDimX()) {
            int y = 0;
            while (y < this.geometry.getDimY()) {
                vec.setX(channels[0].getValueAt(x, y));
                vec.setY(channels[1].getValueAt(x, y));
                vec.setZ(channels[2].getValueAt(x, y));
                l = vec.length();
                if (maxVecLength < l) {
                    maxVecLength = l;
                }
                ++y;
            }
            ++x;
        }
    }

    public void drawSpacedStreamlines(GL gl) {
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        if (changes) {
            if (timeout == 0) {
                this.lineList = gl.glGenLists(1);
                gl.glNewList(this.lineList, 4864);
            }
            this.createGrid();
            this.seedPoints = new LinkedList();
            Vec3 start = Vec3.multiply(this.maxG.minus(this.minG), 0.5f);
            this.drawSpacedLines(gl, start);
            if (timeout > 0) {
                --timeout;
            } else {
                gl.glEndList();
                System.out.println("Streamlines list created...");
                changes = false;
                timeout = 5;
            }
        } else {
            gl.glCallList(this.lineList);
        }
        gl.glDisable(3042);
    }

    private void drawSpacedLines(GL gl, Vec3 init) {
        System.out.println("Drawing spaced lines...");
        LinkedList<Object> cSeeds = new LinkedList<Vec3>();
        cSeeds.add(new Vec3(init));
        this.seedPoints.add(cSeeds);
        Vec3 drawSeed = new Vec3();
        System.out.println("SeedPoints size: " + this.seedPoints.size());
        int si = 0;
        while (si < this.seedPoints.size()) {
            cSeeds = this.seedPoints.get(si);
            int i = 0;
            while (i < cSeeds.size()) {
                drawSeed = (Vec3)cSeeds.get(i);
                if (this.isValidPoint(drawSeed, true)) {
                    Iterator<Vec3> rewIter;
                    Iterator<Vec3> fwdIter;
                    if (integrationMethod == 0 || integrationMethod == 2) {
                        fwdIter = this.drawEulerLine(gl, new Vec3(drawSeed), 1);
                        rewIter = this.drawEulerLine(gl, new Vec3(drawSeed), -1);
                        if (integrationMethod != 2) {
                            while (fwdIter.hasNext()) {
                                this.writePos(fwdIter.next());
                            }
                            while (rewIter.hasNext()) {
                                this.writePos(rewIter.next());
                            }
                        }
                    }
                    if (integrationMethod == 1 || integrationMethod == 2) {
                        fwdIter = this.drawRungeKuttaLine(gl, new Vec3(drawSeed), 1);
                        rewIter = this.drawRungeKuttaLine(gl, new Vec3(drawSeed), -1);
                        while (fwdIter.hasNext()) {
                            this.writePos(fwdIter.next());
                        }
                        while (rewIter.hasNext()) {
                            this.writePos(rewIter.next());
                        }
                    }
                }
                ++i;
            }
            ++si;
        }
        if (showSeeds) {
            this.drawSeedPoints(gl);
        }
        System.out.println("End spaced lines...");
    }

    private Iterator<Vec3> drawEulerLine(GL gl, Vec3 seed, int forward) {
        LinkedList<Vec3> linePos = new LinkedList<Vec3>();
        Interpolation ipol = this.geometry.getNeighbors(seed);
        Vec3 dir = new Vec3();
        Vec3 pos = new Vec3(seed.getX(), seed.getY(), seed.getZ());
        Vec3 normalVec = new Vec3();
        LinkedList<Vec3> cSeeds = new LinkedList<Vec3>();
        int left = 1;
        pos.setZ(0.0f);
        gl.glLineWidth(2.0f);
        gl.glBegin(3);
        if (this.geometry.within(pos)) {
            gl.glColor4f(color.getX(), color.getY(), color.getZ(), color.getAlpha());
            gl.glVertex3f(pos.getX(), pos.getY(), 0.0f);
        }
        int i = 0;
        while ((float)i < maxLine) {
            dir = new Vec3(this.channels[0].getInterpolatedValue(ipol), this.channels[1].getInterpolatedValue(ipol), this.channels[2].getInterpolatedValue(ipol));
            dir.norm();
            dir.multiply(step * (float)forward);
            pos.add(dir);
            if (!this.isValidPoint(pos, false) || pos.getX() < this.minG.getX() || pos.getX() > this.maxG.getX() || pos.getY() < this.minG.getY() || pos.getY() > this.maxG.getY()) break;
            gl.glColor4f(color.getX(), color.getY(), color.getZ(), color.getAlpha());
            gl.glVertex3f(pos.getX(), pos.getY(), 0.0f);
            linePos.add(new Vec3(pos));
            if (pos.distance(seed) > dsep * 2.0f) {
                seed = new Vec3(pos.getX(), pos.getY(), pos.getZ());
                normalVec = new Vec3(-dir.getY(), dir.getX(), 0.0f);
                normalVec.norm();
                normalVec.multiply(dsep * (float)left * 1.1f);
                normalVec.add(pos);
                normalVec.setZ(0.0f);
                cSeeds.add(normalVec);
                left = left == 1 ? -1 : 1;
            }
            ipol = this.geometry.getNeighbors(pos);
            ++i;
        }
        gl.glEnd();
        this.seedPoints.add(cSeeds);
        return linePos.iterator();
    }

    private Iterator<Vec3> drawRungeKuttaLine(GL gl, Vec3 seed, int forward) {
        LinkedList<Vec3> linePos = new LinkedList<Vec3>();
        Interpolation ipol = this.geometry.getNeighbors(seed);
        Vec3 dir1 = new Vec3();
        Vec3 dir2 = new Vec3();
        Vec3 euler = new Vec3();
        Vec3 pos = new Vec3(seed.getX(), seed.getY(), seed.getZ());
        Vec3 normalVec = new Vec3();
        LinkedList<Vec3> cSeeds = new LinkedList<Vec3>();
        Vec4 col = new Vec4();
        col = integrationMethod == 2 ? new Vec4(1.0f, 0.0f, 0.0f, 0.7f) : color;
        int left = 1;
        pos.setZ(0.0f);
        gl.glLineWidth(2.0f);
        gl.glBegin(3);
        if (this.geometry.within(pos)) {
            gl.glColor4f(col.getX(), col.getY(), col.getZ(), col.getAlpha());
            gl.glVertex3f(pos.getX(), pos.getY(), 0.0f);
        }
        dir1 = new Vec3(this.channels[0].getInterpolatedValue(ipol), this.channels[1].getInterpolatedValue(ipol), this.channels[2].getInterpolatedValue(ipol));
        dir1.norm();
        int i = 0;
        while ((float)i < maxLine) {
            euler = Vec3.addVec3(pos, Vec3.multiply(dir1, step * (float)forward));
            if (!this.geometry.within(euler)) break;
            ipol = this.geometry.getNeighbors(euler);
            dir2 = new Vec3(this.channels[0].getInterpolatedValue(ipol), this.channels[1].getInterpolatedValue(ipol), this.channels[2].getInterpolatedValue(ipol));
            dir2.norm();
            dir2.add(dir1);
            dir2.multiply(step * (float)forward * 0.5f);
            pos.add(dir2);
            if (!this.isValidPoint(pos, false) || !this.geometry.within(pos)) break;
            gl.glColor4f(col.getX(), col.getY(), col.getZ(), col.getAlpha());
            gl.glVertex3f(pos.getX(), pos.getY(), 0.0f);
            linePos.add(new Vec3(pos));
            if (pos.distance(seed) > dsep) {
                seed = new Vec3(pos.getX(), pos.getY(), pos.getZ());
                normalVec = new Vec3(-dir2.getY(), dir2.getX(), 0.0f);
                normalVec.norm();
                normalVec.multiply(dsep * (float)left);
                normalVec.add(pos);
                normalVec.setZ(0.0f);
                cSeeds.add(normalVec);
                left = left == 1 ? -1 : 1;
            }
            dir1 = dir2;
            ++i;
        }
        gl.glEnd();
        this.seedPoints.add(cSeeds);
        return linePos.iterator();
    }

    private void drawSeedPoints(GL gl) {
        Vec3 currentPoint = new Vec3();
        LinkedList<Object> seeds = new LinkedList();
        gl.glEnable(34913);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        gl.glPointSize(5.0f);
        gl.glBegin(0);
        int i = 0;
        while (i < this.seedPoints.size()) {
            seeds = this.seedPoints.get(i);
            int j = 0;
            while (j < seeds.size()) {
                currentPoint = (Vec3)seeds.get(j);
                gl.glColor4f(0.4f, 0.4f, 1.0f, 0.5f);
                gl.glVertex3f(currentPoint.getX(), currentPoint.getY(), currentPoint.getZ());
                ++j;
            }
            ++i;
        }
        gl.glEnd();
        gl.glDisable(3042);
        gl.glDisable(34913);
        gl.glDisable(3553);
    }

    private void createGrid() {
        this.xdim = Math.round(this.range.getX() / dsep);
        this.ydim = Math.round(this.range.getY() / dsep);
        this.grid = new Vec3[this.xdim * this.ydim][100];
        System.out.println("Grid created: " + this.xdim + " x " + this.ydim);
    }

    private void writePos(Vec3 pos) {
        int id = this.getCell(pos);
        if (id == -1) {
            return;
        }
        int i = 0;
        while (i < this.grid[0].length) {
            if (this.grid[id][i] == null) {
                this.grid[id][i] = pos;
                break;
            }
            ++i;
        }
    }

    private boolean isValidPoint(Vec3 pos, boolean isSeed) {
        if (pos == null) {
            return false;
        }
        int id = this.getCell(pos);
        if (id == -1) {
            return false;
        }
        boolean valid = true;
        int[] xy = this.getXY(pos);
        int i = 0;
        while (i < this.grid[0].length && valid) {
            int xo = -1;
            while (xo <= 1 && valid) {
                int yo = -1;
                while (yo <= 1 && valid) {
                    valid = this.isGreaterDsep(pos, this.getCell(xy[0] + xo, xy[1] + yo), i, isSeed);
                    ++yo;
                }
                ++xo;
            }
            ++i;
        }
        return valid;
    }

    private boolean isGreaterDsep(Vec3 pos, int id, int i, boolean isSeed) {
        boolean valid = true;
        if (id == -1) {
            return true;
        }
        float maxDist = isSeed ? dsep : dsep * dtest;
        float dist = 0.0f;
        if (this.grid[id][i] != null && (dist = pos.distance(this.grid[id][i])) <= maxDist) {
            valid = false;
        }
        return valid;
    }

    private int getCell(int x, int y) {
        int id = x * this.xdim + y;
        if (id < 0 || id >= this.grid.length) {
            return -1;
        }
        return id;
    }

    private int getCell(Vec3 pos) {
        int y;
        int x = (int)Math.floor((pos.getX() - this.minG.getX()) / (this.maxG.getX() - this.minG.getX()) * (float)(this.xdim - 1));
        int id = x * this.xdim + (y = (int)Math.floor((pos.getY() - this.minG.getY()) / (this.maxG.getY() - this.minG.getY()) * (float)(this.ydim - 1)));
        if (id < 0 || id >= this.grid.length) {
            return -1;
        }
        return id;
    }

    private int[] getXY(Vec3 pos) {
        int[] xy = new int[]{(int)Math.floor((pos.getX() - this.minG.getX()) / (this.maxG.getX() - this.minG.getX()) * (float)(this.xdim - 1)), (int)Math.floor((pos.getY() - this.minG.getY()) / (this.maxG.getY() - this.minG.getY()) * (float)(this.ydim - 1))};
        return xy;
    }

    public static void setStep(int val) {
        step = (float)val / 1000.0f;
        SpacedStreamlines.update();
    }

    public static void setDSep(int val) {
        dsep = (float)val / 100.0f;
        SpacedStreamlines.update();
    }

    public static void setDTest(int val) {
        dtest = (float)val / 100.0f;
        SpacedStreamlines.update();
    }

    public static void setColor(Vec4 col) {
        if (color != col) {
            color = col;
            SpacedStreamlines.update();
        }
    }

    public static void setShowSeeds(boolean val) {
        showSeeds = val;
        SpacedStreamlines.update();
    }

    public static void setIntegrationMethod(int method) {
        integrationMethod = method;
        SpacedStreamlines.update();
    }

    private static void update() {
        changes = true;
        timeout = 5;
    }
}

