/*
 * Decompiled with CFR 0.152.
 */
package glcanvas;

import com.sun.opengl.util.BufferUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.swing.JOptionPane;

public class ShaderUtil {
    private static int vertShader;
    private static int fragShader;
    private static int fvProgram;
    private static GLU glu;

    static {
        glu = new GLU();
    }

    public static void initShader(GL gl) {
        String vertFile = "Shader/arrowplot.vsh";
        String fragFile = "Shader/arrowplot.fsh";
        vertShader = gl.glCreateShaderObjectARB(35633);
        fragShader = gl.glCreateShaderObjectARB(35632);
        fvProgram = gl.glCreateProgramObjectARB();
        String shaderSource = ShaderUtil.getShaderSource(vertFile);
        gl.glShaderSourceARB(vertShader, 1, new String[]{shaderSource}, null, 0);
        ShaderUtil.compileShader(gl, vertShader, fvProgram);
        int glError = 0;
        glError = gl.glGetError();
        if (glError != 0) {
            System.out.println("Error while compiling vertex shader: " + glu.gluErrorString(glError));
        } else {
            System.out.println("Shader compiled...");
        }
        shaderSource = ShaderUtil.getShaderSource(fragFile);
        gl.glShaderSourceARB(fragShader, 1, new String[]{shaderSource}, null, 0);
        ShaderUtil.compileShader(gl, fragShader, fvProgram);
        glError = 0;
        glError = gl.glGetError();
        if (glError != 0) {
            System.out.println("Error while compiling fragment shader: " + glu.gluErrorString(glError));
        } else {
            System.out.println("Shader compiled...");
        }
    }

    private static void compileShader(GL gl, int shader, int programObject) {
        gl.glCompileShaderARB(shader);
        ShaderUtil.checkLogInfo(gl, shader);
        gl.glAttachObjectARB(programObject, shader);
    }

    public static void checkLogInfo(GL gl, int shader) {
        IntBuffer iVal = BufferUtil.newIntBuffer((int)1);
        gl.glGetObjectParameterivARB(shader, 35716, iVal);
        int length = iVal.get();
        if (length <= 1) {
            return;
        }
        ByteBuffer infoLog = BufferUtil.newByteBuffer((int)length);
        iVal.flip();
        gl.glGetInfoLogARB(shader, length, iVal, infoLog);
        byte[] infoBytes = new byte[length];
        infoLog.get(infoBytes);
        System.out.println("GLSL Validation >> " + new String(infoBytes));
    }

    private static String getShaderSource(String filename) {
        String shaderSource = "";
        try {
            BufferedReader shaderReader = new BufferedReader(new FileReader(filename));
            StringWriter shaderWriter = new StringWriter();
            String line = shaderReader.readLine();
            while (line != null) {
                shaderWriter.write(line);
                shaderWriter.write("\n");
                line = shaderReader.readLine();
            }
            shaderSource = shaderWriter.getBuffer().toString();
        }
        catch (IOException ioe) {
            System.out.println("I could not read from the file: " + filename);
            JOptionPane.showMessageDialog(null, "I couldn't read from the file: " + filename, "Error", 0);
        }
        return shaderSource;
    }

    public static int getProgram() {
        return fvProgram;
    }

    public static void linkProgam(GL gl) {
        gl.glLinkProgram(fvProgram);
        gl.glValidateProgramARB(fvProgram);
        ShaderUtil.checkLogInfo(gl, fvProgram);
    }
}

