/*
 * Decompiled with CFR 0.152.
 */
package glcanvas;

import glcanvas.data.FlowChannel;
import glcanvas.data.FlowGeometry;
import glcanvas.data.Vec3;
import glcanvas.data.Vec4;
import java.util.LinkedList;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class ChannelVisualisation {
    public static final int POINT_TEX = 0;
    private FlowChannel[] channels;
    private FlowGeometry geometry;
    private GLU glu;
    private LinkedList<Vec4[]> transfer;
    private boolean[] renderChannel;

    public ChannelVisualisation(FlowChannel[] channels) {
        this.channels = channels;
        this.geometry = channels[0].getGeometry();
        this.glu = new GLU();
        this.transfer = new LinkedList();
        Vec4[] defCol = new Vec4[256];
        int i = 0;
        while (i < 256) {
            defCol[i] = new Vec4((float)i / 255.0f, (float)i / 255.0f, (float)i / 255.0f, 1.0f);
            ++i;
        }
        i = 0;
        while (i < this.geometry.getNumChannels()) {
            this.transfer.add(defCol);
            ++i;
        }
        this.renderChannel = new boolean[this.geometry.getNumChannels() + 3];
        i = 0;
        while (i < this.geometry.getNumChannels()) {
            this.renderChannel[i] = false;
            ++i;
        }
        System.out.println("channel 5: " + channels[4].getNormValueAt(0, 0));
    }

    public void drawChannelData(GL gl) {
        int i = 0;
        while (i < this.geometry.getNumChannels() + 3) {
            if (this.renderChannel[i]) {
                this.drawChannel(gl, i);
            }
            ++i;
        }
    }

    private void drawChannel(GL gl, int chIdx) {
        int sizeX = this.geometry.getDimX();
        int sizeY = this.geometry.getDimY();
        Vec4[] cTransfer = this.transfer.get(chIdx - 3);
        Vec3 cPos1 = new Vec3();
        Vec3 cPos2 = new Vec3();
        Vec3 cPos3 = new Vec3();
        Vec3 cPos4 = new Vec3();
        int nxs = 2;
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        int y = 1;
        while (y < sizeY - nxs) {
            gl.glBegin(8);
            int x = 0;
            while (x < sizeX - nxs) {
                Vec4 cValue1 = cTransfer[Math.round(this.channels[chIdx].getNormValueAt(x, y) * 255.0f)];
                cPos1 = this.geometry.getValueAt(x, y);
                Vec4 cValue2 = cTransfer[Math.round(this.channels[chIdx].getNormValueAt(x, y + nxs) * 255.0f)];
                cPos2 = this.geometry.getValueAt(x, y + nxs);
                Vec4 cValue3 = cTransfer[Math.round(this.channels[chIdx].getNormValueAt(x + nxs, y) * 255.0f)];
                cPos3 = this.geometry.getValueAt(x + nxs, y);
                Vec4 cValue4 = cTransfer[Math.round(this.channels[chIdx].getNormValueAt(x + nxs, y + nxs) * 255.0f)];
                cPos4 = this.geometry.getValueAt(x + nxs, y + nxs);
                gl.glColor4f(cValue1.getX(), cValue1.getY(), cValue1.getZ(), cValue1.getAlpha());
                gl.glVertex3f(cPos1.getX(), cPos1.getY(), cPos1.getZ());
                gl.glColor4f(cValue2.getX(), cValue2.getY(), cValue2.getZ(), cValue2.getAlpha());
                gl.glVertex3f(cPos2.getX(), cPos2.getY(), cPos2.getZ());
                gl.glColor4f(cValue3.getX(), cValue3.getY(), cValue3.getZ(), cValue3.getAlpha());
                gl.glVertex3f(cPos3.getX(), cPos3.getY(), cPos3.getZ());
                gl.glColor4f(cValue4.getX(), cValue4.getY(), cValue4.getZ(), cValue4.getAlpha());
                gl.glVertex3f(cPos4.getX(), cPos4.getY(), cPos4.getZ());
                x += nxs * 2;
            }
            gl.glEnd();
            y += nxs;
        }
        gl.glDisable(3042);
        int glError = 0;
        glError = gl.glGetError();
        if (glError != 0) {
            System.out.println("Error while drawing CHANNELS: " + this.glu.gluErrorString(glError));
        }
    }

    public void setTransferFunction(int index, Vec4[] array) {
        this.transfer.set(index, array);
    }

    public void updateRenderChannel(int index, boolean visible) {
        this.renderChannel[index + 3] = visible;
        System.out.println("channel: " + (index + 3));
    }
}

