/*
 * Decompiled with CFR 0.152.
 */
package glcanvas;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import glcanvas.TextureReader;
import glcanvas.data.FlowChannel;
import glcanvas.data.FlowGeometry;
import glcanvas.data.Interpolation;
import glcanvas.data.Vec3;
import glcanvas.data.Vec4;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.swing.JOptionPane;

public class ArrowPlot {
    public static final int POINT_TEX = 0;
    public static final int MAX_TIMEOUT = 100;
    private static int distance;
    private static int scaleGlobal;
    private static boolean isEqualLength;
    private static boolean changes;
    private static int timeout;
    private static Vec4 color;
    private FlowChannel[] channels;
    private FlowGeometry geometry;
    private static Texture tex;
    private int[] pointTexID = new int[1];
    private int arrowList;
    private GLU glu;

    public ArrowPlot(FlowChannel[] channels) {
        this.pointTexID[0] = -1;
        this.channels = channels;
        this.geometry = channels[0].getGeometry();
        tex = null;
        this.glu = new GLU();
        distance = 20;
        scaleGlobal = 30;
        color = new Vec4(1.0f, 1.0f, 1.0f, 1.0f);
        isEqualLength = true;
        changes = true;
        timeout = 100;
    }

    public void drawPointsSoftware(GL gl) {
        if (tex == null) {
            this.createPointTexture(gl);
        }
        if (changes) {
            Vec3 minG = this.geometry.getMin();
            Vec3 maxG = this.geometry.getMax();
            float distx = (maxG.getX() - minG.getX()) / (float)distance;
            float disty = (maxG.getY() - minG.getY()) / (float)distance;
            if (timeout == 0) {
                this.arrowList = gl.glGenLists(1);
                gl.glNewList(this.arrowList, 4864);
            }
            float x = minG.getX();
            while (x < maxG.getX()) {
                float y = minG.getY();
                while (y < maxG.getY()) {
                    this.drawSinglePoint(gl, new Vec3(x, y, 0.0f));
                    y += disty;
                }
                x += distx;
            }
            if (timeout > 0) {
                --timeout;
            } else {
                gl.glEndList();
                System.out.println("List created...");
                changes = false;
                timeout = 100;
            }
        } else {
            gl.glCallList(this.arrowList);
        }
        int glError = 0;
        glError = gl.glGetError();
        if (glError != 0) {
            System.out.println("Error while drawing POINTS (Software): " + this.glu.gluErrorString(glError));
        }
    }

    private void drawSinglePoint(GL gl, Vec3 cPoint) {
        Interpolation ipol = this.geometry.getNeighbors(cPoint);
        Vec3 vel = new Vec3(this.channels[0].getInterpolatedValue(ipol), this.channels[1].getInterpolatedValue(ipol), this.channels[2].getInterpolatedValue(ipol));
        float scale = 1.0f;
        float b = 2.0f * scale;
        float as = vel.sqLength();
        float a = vel.length();
        float cs = (2.0f * scale + vel.getX()) * (2.0f * scale + vel.getX()) + vel.getY() * vel.getY();
        scale *= (float)scaleGlobal / 100.0f;
        if (!isEqualLength) {
            scale *= vel.length() * 0.1f;
        }
        float angle = (float)Math.acos((as + b * b - cs) / (2.0f * a * b)) * 57.29578f;
        if (vel.getY() > 0.0f) {
            angle *= -1.0f;
        }
        gl.glEnable(3553);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        tex.bind();
        gl.glPushMatrix();
        gl.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
        gl.glTranslatef(-cPoint.getX(), -cPoint.getY(), 0.0f);
        gl.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
        gl.glRotatef(angle, 0.0f, 0.0f, 1.0f);
        gl.glColor4f(color.getX(), color.getY(), color.getZ(), color.getAlpha());
        gl.glBegin(7);
        gl.glVertex3f(-scale, -scale, cPoint.getZ());
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(-scale, scale, cPoint.getZ());
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(scale, scale, cPoint.getZ());
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(scale, -scale, cPoint.getZ());
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glEnd();
        gl.glPopMatrix();
        gl.glDisable(3042);
        gl.glDisable(3553);
        int glError = 0;
        glError = gl.glGetError();
        if (glError != 0) {
            System.out.println("Error while drawing SINGLE POINT (Software): " + this.glu.gluErrorString(glError));
            System.out.println("angle: " + angle + " scale: " + scale + " cPoint x: " + cPoint.getX() + " cPoint y: " + cPoint.getY());
        }
    }

    public void drawPoints(GL gl) {
        Vec3 currentPoint = new Vec3();
        if (tex == null) {
            this.createPointTexture(gl);
        }
        gl.glEnable(3553);
        gl.glEnable(34913);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        tex.bind();
        gl.glTexEnvi(34913, 34914, 1);
        gl.glPointSize(32.0f);
        gl.glBegin(0);
        int x = 0;
        while (x < this.geometry.getDimX()) {
            int y = 0;
            while (y < this.geometry.getDimY()) {
                currentPoint = this.geometry.getValueAt(x, y);
                gl.glVertex3f(currentPoint.getX(), currentPoint.getY(), currentPoint.getZ());
                y += 20;
            }
            x += 20;
        }
        gl.glEnd();
        gl.glDisable(3042);
        gl.glDisable(34913);
        gl.glDisable(3553);
        int glError = 0;
        glError = gl.glGetError();
        if (glError != 0) {
            System.out.println("Error while drawing POINT SPRITES: " + this.glu.gluErrorString(glError));
        }
    }

    private void createPointTexture(GL gl) {
        System.out.println("Creating point texture...");
        String textureName = "image/arrow2.png";
        try {
            tex = TextureIO.newTexture((BufferedImage)TextureReader.readImage(textureName), (boolean)true);
            tex.setTexParameteri(10240, 9728);
            tex.setTexParameteri(10241, 9728);
        }
        catch (IOException ioe) {
            System.out.println("Error while loading texture " + textureName);
            System.out.println(ioe.getMessage());
        }
        if (tex == null) {
            JOptionPane.showMessageDialog(null, "I could not read the texture image", "Error", 0);
        }
        int glError = 0;
        glError = gl.glGetError();
        if (glError != 0) {
            System.out.println("Error while initializing POINT Texture: " + this.glu.gluErrorString(glError));
        }
        gl.glDisable(3553);
        tex.disable();
        gl.glBindTexture(3553, 0);
    }

    public static void setDistance(int dist) {
        distance = dist;
        ArrowPlot.update();
    }

    public static void setSize(int scale) {
        scaleGlobal = scale;
        ArrowPlot.update();
    }

    public static void updateEqualLength(boolean isEqualLen) {
        isEqualLength = isEqualLen;
        ArrowPlot.update();
    }

    public static void setColor(Vec4 col) {
        if (color != col) {
            color = col;
            ArrowPlot.update();
        }
    }

    private static void update() {
        timeout = 100;
        changes = true;
    }
}

