// Vertex Shader for Worldpos Rendering

uniform mat4 mModelMatrix;
uniform mat4 mViewMatrix;
uniform mat4 mProjectionMatrix;
uniform vec4 mVolumeSize;

void main()
{
	// default vertex transformation
	mat4 viewProjection =  mProjectionMatrix * mViewMatrix;
	vec4 worldPos = mModelMatrix * gl_Vertex;

	gl_Position = viewProjection * worldPos;

	// the volume texture coordinats used in the fragment
	//gl_TexCoord[0] = (worldPos / (2.0*mVolumeSize)) + vec4(0.5, 0.5, 0.5, 0.0);	
	gl_TexCoord[0] = gl_MultiTexCoord0;
	//gl_FrontColor = worldPos;
}