uniform sampler3D mVolume;
//uniform sampler1D mTransfer;
uniform sampler2D mFrontFaces;
uniform sampler2D mBackFaces;
uniform vec3 mClearColor;

void main()
{
	const float dz = 0.005;
	const int maxrange = 347;
	vec4 entrypoint = texture2D(mFrontFaces, gl_TexCoord[0].xy);
	vec4 exitpoint = texture2D(mBackFaces, gl_TexCoord[0].xy);
	
	float dist = distance(entrypoint, exitpoint)/dz;
	int maxiter = int(dist);

	vec3 diff = exitpoint.xyz - entrypoint.xyz; 
	diff /= dist;

	if(entrypoint.w == 0.0)
	{
		discard;
	}
	else
	{
		bool work = true;
		vec3 point = entrypoint.xyz + 0.5 * diff;

		float intensity = 0.0;
		float depth = 0.0;

		for(int i = 0; i < maxrange; i++)
		{
			vec4 lookup = texture3D(mVolume, point.xyz);
			float tmpintensity = lookup.x;
			float tmpdepth = distance (entrypoint.xyz,point);

			intensity = (tmpintensity > intensity) ? tmpintensity : intensity;
			depth = (tmpintensity > intensity) ? tmpdepth : depth;

			/*transferred.w *= intensity.x;
			Result.xyz += (1.0  Result.w) * transferred.w *
			transferred.xyz;
			Result.w += (1.0  Result.w) * transferred.w;*/
			point +=diff;
			if ((intensity >= 1.0)||(i >= maxiter))
			{
				break;
			}
		}
		//vec4 transfered = texture1D(mTransfer, intensity);

		vec3 ac = vec3(intensity,intensity,intensity);
		//gl_FragColor = vec4(intensity,intensity,intensity,1.0);
		float aa = intensity;
		vec3 col = mix(mClearColor, ac, aa);


		//gl_FragColor = vec4(ac,aa);
		gl_FragColor = vec4(col,1.0);
	}
}