uniform sampler3D mVolume;
uniform sampler2D mTransfer;
uniform sampler2D mFrontFaces;
uniform sampler2D mBackFaces;
uniform sampler2D mNoiseTexture;

uniform vec3 mClearColor;
uniform vec3 dimension;

void main()
{
	const float dz = 0.003;
	const int maxrange = 4096;
	vec4 entrypoint = texture2D(mFrontFaces, gl_TexCoord[0].xy);
	vec4 exitpoint = texture2D(mBackFaces, gl_TexCoord[0].xy);

	vec3 noiseoffset = texture2D(mNoiseTexture, gl_TexCoord[0].xy);
	noiseoffset.xyz /= dimension.xyz;
	
	if(exitpoint == entrypoint)
	{
		discard;
	}

	float dist = distance(entrypoint, exitpoint)/dz;
	int maxiter = int(dist);

	vec3 diff = exitpoint.xyz - entrypoint.xyz; 
	diff /= dist;

	if(entrypoint.w == 0.0)
	{
		discard;
	}
	else
	{
		vec3 point = entrypoint.xyz + diff ;
		//vec3 point = exitpoint.xyz - diff;
		vec4 destination = vec4(0.0,0.0,0.0,0.0);

		vec3 ac = vec3(0.0,0.0,0.0);
		float aa = 0.0;

		for(int i = 0; i < maxrange; i++)
		{
			//vec4 lookup = texture3D(mVolume, point.xyz);
			//float tmpintensity = lookup.x;
			vec3 offset = vec3(0.1, 0.1, 0.1) * noiseoffset.xyz ;
			vec4 lookup = texture3D(mVolume, point.xyz + offset.xyz);
			
			float val = lookup.x;
			vec3 grad = lookup.yzw;
			float gradmag = length(grad);
			
			vec4 valc = texture2D(mTransfer, vec2(val, gradmag));
			
			float va = valc.a;
			vec3 vc = valc.rgb * va;
		
			//FTB
			ac = ac + (1.0-aa)*vc; 
			aa = aa + (1.0-aa)*va;
			
			
			
			if(i > maxiter)
			{
				break;
			}
			if(aa > 1.0)
			{
				break;
			}

			//vec3 stepsize = (gradmag < 0.1 ) ? diff : diff * (5.0/gradmag);
			point += diff;

		} 

		vec3 col = mix(mClearColor, ac, aa);


		//gl_FragColor = vec4(ac,aa);
		gl_FragColor = vec4(col,1.0);
	}
}