#define DELTA (0.01)

uniform sampler3D mVolume;
uniform sampler2D mTransfer;
uniform sampler2D mFrontFaces;
uniform sampler2D mBackFaces;
uniform sampler2D mWorldFrontFaces;
uniform sampler2D mWorldBackFaces;

uniform float mTresholdH;
uniform float mTresholdL;
uniform mat4 mTex2World;
uniform vec3 mLightDir;
uniform vec3 mClearColor;
uniform vec3 mCamPos;

uniform float mClipNX;
uniform float mClipPX;
uniform float mClipNY;
uniform float mClipPY;
uniform float mClipNZ;
uniform float mClipPZ;

void main()
{
	const float dz = 0.002;
	const int maxrange = 1024;
	vec4 entrypoint = texture2D(mFrontFaces, gl_TexCoord[0].xy);
	vec4 exitpoint = texture2D(mBackFaces, gl_TexCoord[0].xy);

	vec4 wentrypoint = texture2D(mWorldFrontFaces, gl_TexCoord[0].xy);
	vec4 wexitpoint = texture2D(mWorldBackFaces, gl_TexCoord[0].xy);

	float dist = distance(entrypoint, exitpoint)/dz;
	int maxiter = int(dist);

	vec3 diff = exitpoint.xyz - entrypoint.xyz; 
	diff /= dist;
	diff = diff ;

	float wdist = distance(wentrypoint, wexitpoint)/dz;
	int wmaxiter = int(wdist);

	vec3 wdiff = wexitpoint.xyz - wentrypoint.xyz; 
	wdiff /= wdist;
	wdiff = wdiff ;


	if(entrypoint.w == 0.0)
	{
		discard;
	}
	else
	{
		vec3 point = entrypoint.xyz + diff;
		vec3 wpoint = wentrypoint.xyz + wdiff;

		vec4 destination = vec4(0.0,0.0,0.0,0.0);

		vec3 ac = vec3(0.0,0.0,0.0);
		float aa = 0.0;

		for(int i = 0; i < maxrange; i++)
		{
			vec4 lookup = texture3D(mVolume, point.xyz);
			float val = lookup.x;
			vec3 lgradient = lookup.yzw;
			
			float ltresh = mTresholdL;
			float htresh = mTresholdH;

			if(ltresh == htresh)
			{
				htresh += 0.1;
			}
			
			if(val >= ltresh && val <= htresh)
			{

				vec3 Ka = vec3(0.1, 0.1, 0.1);
				vec3 Ks = vec3(0.4, 0.4, 0.4);
				float n = 200.0;

				vec3 lightColor = vec3(1.0, 1.0, 1.0);
				vec3 ambientLight = vec3(0.2, 0.2, 0.2);

				vec4 valc = texture2D(mTransfer, vec2(val, length(lgradient)));

				vec3 worldpospoint = wpoint;

				vec3 gradient;
				if(i < 1)
				{	
					if(point.x < mClipNX + dz)
					{
						//gradient = vec3(1.0, 0.0, 0.0);
						gradient = vec3(-1.0, 0.0, 0.0);
					}
					else if(point.x > mClipPX - dz)
					{
						//gradient = vec3(0.5, 0.0, 0.0);
						gradient = vec3(1.0, 0.0, 0.0);
					}
					else if(point.y < mClipNY + dz)
					{
						//gradient = vec3(0.0, 1.0, 0.0);
						gradient = vec3(0.0, -1.0, 0.0);
					}
					else if(point.y > mClipPY - dz)
					{
						//gradient = vec3(0.0, 0.5, 0.0);
						gradient = vec3(0.0, 1.0, 0.0);
					}
					else if(point.z < mClipNZ + dz)
					{
						//gradient = vec3(0.0, 0.0, 1.0);
						gradient = vec3(0.0, 0.0, -1.0);
					}
					else if(point.z > mClipPZ - dz)
					{
						//gradient = vec3(0.0, 0.0, 0.5);
						gradient = vec3(0.0, 0.0, 1.0);
					}
				}
				else
				{
					gradient = lgradient;
				}

				vec3 N = normalize(gradient);


				vec3 view = normalize(mCamPos - worldpospoint);
				mLightDir = normalize(-mLightDir);

				vec3 H = normalize(mLightDir + view);

				vec3 ambient = Ka * ambientLight;

				vec3 Kd = valc.rgb;

				float diffuseLight = max(dot(mLightDir, N), 0.0);
				vec3 diffuse = Kd * lightColor * diffuseLight;

				float specularLight = pow(max(dot(H, N),0.0), n);
				if(diffuseLight <= 0.0) specularLight = 0.0;

				vec3 specular = Ks * lightColor * specularLight;

				vec3 color = ambient + diffuse + specular;
			
				ac = ac + (1.0-aa)*color;
				aa = 1.0;

			}
			else
			{
				float val = lookup.x;
				vec4 valc = texture2D(mTransfer, vec2(val, length(lookup.yzw)));

				float va = valc.a;
				vec3 vc = valc.rgb * va;
			
				//FTB
				ac = ac + (1.0-aa)*vc; 
				aa = aa + (1.0-aa)*va;
			}

			if(i > maxiter)
			{
				break;
			}
			if(aa > 0.95)
			{
				break;
			}

			point += diff;
			wpoint += wdiff;
		}

		vec3 col = mix(mClearColor, ac, aa);


		//gl_FragColor = vec4(ac,aa);
		gl_FragColor = vec4(col,1.0);
	}
}