uniform sampler3D mVolume;
uniform sampler2D mTransfer;
uniform sampler2D mFrontFaces;
uniform sampler2D mBackFaces;
uniform vec3 mClearColor;

void main()
{
	const float dz = 0.003;
	const int maxrange = 1024;
	vec4 entrypoint = texture2D(mFrontFaces, gl_TexCoord[0].xy);
	vec4 exitpoint = texture2D(mBackFaces, gl_TexCoord[0].xy);
	
	float dist = distance(entrypoint, exitpoint)/dz;
	int maxiter = int(dist);

	vec3 diff = exitpoint.xyz - entrypoint.xyz; 
	diff /= dist;
	diff = diff ;

	if(entrypoint.w == 0.0)
	{
		discard;
	}
	else
	{
		//vec3 point = entrypoint.xyz + diff;
		vec3 point = exitpoint.xyz - diff;
		vec4 destination = vec4(0.0,0.0,0.0,0.0);

		vec3 ac = mClearColor.rgb;
		float aa = 0.0;

		for(int i = 0; i < maxrange; i++)
		{
			//vec4 lookup = texture3D(mVolume, point.xyz);
			//float tmpintensity = lookup.x;
			float val = texture3D(mVolume, point.xyz).x;
			vec4 valc = texture2D(mTransfer, vec2(val,0.5));

			float va = valc.a;
			vec3 vc = valc.rgb * va;
		
			//BTF
			ac = ac*(1.0-va) + vc;
			
			if(aa > 1.0)
			{
				break;
			}
			
			if(i > maxiter)
			{
				break;
			}

			point -=diff;

		}

		gl_FragColor = vec4(ac,aa);
		//gl_FragColor = vec4(col,1.0);
	}
}