#define DELTA (0.01)

uniform sampler3D mVolume;
uniform sampler2D mTransfer;
uniform sampler2D mTransfer1D;

uniform sampler2D mFrontFaces;
uniform sampler2D mBackFaces;
uniform sampler2D mWorldFrontFaces;
uniform sampler2D mWorldBackFaces;

uniform float mTresholdH;
uniform float mTresholdL;
uniform mat4 mTex2World;
uniform vec3 mLightDir;
uniform vec3 mClearColor;
uniform vec3 mCamPos;

uniform float mClipNX;
uniform float mClipPX;
uniform float mClipNY;
uniform float mClipPY;
uniform float mClipNZ;
uniform float mClipPZ;


void main()
{
	const float dz = 0.002;
	const int maxrange = 1024;
	vec4 entrypoint = texture2D(mFrontFaces, gl_TexCoord[0].xy);
	vec4 exitpoint = texture2D(mBackFaces, gl_TexCoord[0].xy);

	vec4 wentrypoint = texture2D(mWorldFrontFaces, gl_TexCoord[0].xy);
	vec4 wexitpoint = texture2D(mWorldBackFaces, gl_TexCoord[0].xy);

	float dist = distance(entrypoint, exitpoint)/dz;
	int maxiter = int(dist);

	vec3 diff = exitpoint.xyz - entrypoint.xyz; 
	diff /= dist;
	diff = diff ;

	float wdist = distance(wentrypoint, wexitpoint)/dz;
	int wmaxiter = int(wdist);

	vec3 wdiff = wexitpoint.xyz - wentrypoint.xyz; 
	wdiff /= wdist;
	wdiff = wdiff ;


	if(entrypoint.w == 0.0)
	{
		discard;
	}
	else
	{
		vec3 point = entrypoint.xyz + diff;
		vec3 wpoint = wentrypoint.xyz + wdiff;

		vec4 destination = vec4(0.0,0.0,0.0,0.0);

		vec3 ac = vec3(0.0,0.0,0.0);
		float aa = 0.0;

		for(int i = 0; i < maxrange; i++)
		{
			vec4 lookup = texture3D(mVolume, point.xyz);
			float val = lookup.x;
			vec3 lgradient = lookup.yzw;
			
			float ltresh = mTresholdL;
			float htresh = mTresholdH;

			if(ltresh == htresh)
			{
				htresh += 0.1;
			}
			
			if(val >= ltresh && val <= htresh)
			{

				vec3 Ka = vec3(0.1, 0.1, 0.1);
				vec3 Ks = vec3(0.4, 0.4, 0.4);
				float n = 200.0;

				vec3 lightColor = vec3(1.0, 1.0, 1.0);
				vec3 ambientLight = vec3(0.2, 0.2, 0.2);

				vec4 valc = texture2D(mTransfer, vec2(val,length(lgradient)));

				vec3 worldpospoint = wpoint;

				vec3 gradient;
				if(i < 1)
				{	
					if(point.x < mClipNX + dz)
					{
						//gradient = vec3(1.0, 0.0, 0.0);
						gradient = vec3(-1.0, 0.0, 0.0);
					}
					else if(point.x > mClipPX - dz)
					{
						//gradient = vec3(0.5, 0.0, 0.0);
						gradient = vec3(1.0, 0.0, 0.0);
					}
					else if(point.y < mClipNY + dz)
					{
						//gradient = vec3(0.0, 1.0, 0.0);
						gradient = vec3(0.0, -1.0, 0.0);
					}
					else if(point.y > mClipPY - dz)
					{
						//gradient = vec3(0.0, 0.5, 0.0);
						gradient = vec3(0.0, 1.0, 0.0);
					}
					else if(point.z < mClipNZ + dz)
					{
						//gradient = vec3(0.0, 0.0, 1.0);
						gradient = vec3(0.0, 0.0, -1.0);
					}
					else if(point.z > mClipPZ - dz)
					{
						//gradient = vec3(0.0, 0.0, 0.5);
						gradient = vec3(0.0, 0.0, 1.0);
					}
				}
				else
				{
					gradient = lgradient;
				}

				//////////////////
				// Shadow Ray	//
				//////////////////
				float steplength = length(diff);
				
				vec3 lightraystep = normalize(-mLightDir) * steplength;
				
				float shadowcontribution = 0.0;
				vec3 shadowpoint = point + lightraystep;
				
				for(int j = 0; j < maxrange; j++)
				{
					
					if(shadowpoint.x < mClipNX + (dz * 3.0))
					{
						//gradient = vec3(1.0, 0.0, 0.0);
						//gradient = vec3(-1.0, 0.0, 0.0);
						break;
					}
					else if(shadowpoint.x > mClipPX - (dz * 3.0))
					{
						//gradient = vec3(0.5, 0.0, 0.0);
						//gradient = vec3(1.0, 0.0, 0.0);
						break;
					}
					else if(shadowpoint.y < mClipNY + (dz * 3.0))
					{
						//gradient = vec3(0.0, 1.0, 0.0);
						//gradient = vec3(0.0, -1.0, 0.0);
						break;
					}
					else if(shadowpoint.y > mClipPY - (dz * 3.0))
					{
						//gradient = vec3(0.0, 0.5, 0.0);
						//gradient = vec3(0.0, 1.0, 0.0);
						break;
					}
					else if(shadowpoint.z < mClipNZ + (dz * 3.0))
					{
						//gradient = vec3(0.0, 0.0, 1.0);
						//gradient = vec3(0.0, 0.0, -1.0);
						break;
					}
					else if(shadowpoint.z > mClipPZ - (dz * 3.0))
					{
						//gradient = vec3(0.0, 0.0, 0.5);
						//gradient = vec3(0.0, 0.0, 1.0);
						break;
					}
					
					
					vec4 lookup = texture3D(mVolume, shadowpoint);
					vec3 offset = normalize(lookup.yzw)*steplength;
					float sval = texture3D(mVolume, shadowpoint + offset).x;
					vec4 svalc = texture2D(mTransfer, vec2(val, length(lookup.yzw)));

					if(sval >= ltresh && sval <= htresh)
					{
						shadowcontribution = 0.9;
						break;
					}

					float sva = svalc.a / 32.0;					
			
					shadowcontribution = shadowcontribution + (1.0-shadowcontribution)*sva;
										
					shadowpoint += lightraystep;
				}

				//////////////////
				// Shadow Ray	//
				//////////////////

				vec3 N = normalize(gradient);


				vec3 view = normalize(mCamPos - worldpospoint);
				mLightDir = normalize(-mLightDir);

				vec3 H = normalize(mLightDir + view);

				vec3 ambient = Ka * ambientLight;

				//
				//compute curvature
				//
				float mDelta = 0.01;

				float n0 = texture3D(mVolume, point.xyz + vec3(-mDelta,  -mDelta,  0.0) ).x;
				float n1 = texture3D(mVolume, point.xyz + vec3( 0.0,	 -mDelta,  0.0) ).x;
				float n2 = texture3D(mVolume, point.xyz + vec3( mDelta,	 -mDelta,  0.0) ).x;
				float n3 = texture3D(mVolume, point.xyz + vec3(-mDelta,	  0.0,	   0.0) ).x;
				float n4 = val;
				float n5 = texture3D(mVolume, point.xyz + vec3( mDelta,	  0.0,     0.0) ).x;
				float n6 = texture3D(mVolume, point.xyz + vec3(-mDelta,   mDelta,  0.0) ).x;
				float n7 = texture3D(mVolume, point.xyz + vec3( 0.0,	  mDelta,  0.0) ).x;
				float n8 = texture3D(mVolume, point.xyz + vec3( mDelta,   mDelta,  0.0) ).x;

				float n0plusz = texture3D(mVolume, point.xyz + vec3(-mDelta, -mDelta,  mDelta) ).x;
				float n1plusz = texture3D(mVolume, point.xyz + vec3( 0.0,	 -mDelta,  mDelta) ).x;
				float n2plusz = texture3D(mVolume, point.xyz + vec3( mDelta, -mDelta,  mDelta) ).x;
				float n3plusz = texture3D(mVolume, point.xyz + vec3(-mDelta,  0.0,	   mDelta) ).x;
				float n4plusz = texture3D(mVolume, point.xyz + vec3( 0.0,     0.0,     mDelta) ).x;
				float n5plusz = texture3D(mVolume, point.xyz + vec3( mDelta,  0.0,     mDelta) ).x;
				float n6plusz = texture3D(mVolume, point.xyz + vec3(-mDelta,  mDelta,  mDelta) ).x;
				float n7plusz = texture3D(mVolume, point.xyz + vec3( 0.0,	  mDelta,  mDelta) ).x;
				float n8plusz = texture3D(mVolume, point.xyz + vec3( mDelta,  mDelta,  mDelta) ).x;

				float n0minusz = texture3D(mVolume, point.xyz + vec3(-mDelta, -mDelta,  -mDelta) ).x;
				float n1minusz = texture3D(mVolume, point.xyz + vec3( 0.0,	  -mDelta,  -mDelta) ).x;
				float n2minusz = texture3D(mVolume, point.xyz + vec3( mDelta, -mDelta,  -mDelta) ).x;
				float n3minusz = texture3D(mVolume, point.xyz + vec3(-mDelta,  0.0,	    -mDelta) ).x;
				float n4minusz = texture3D(mVolume, point.xyz + vec3( 0.0,     0.0,     -mDelta) ).x;
				float n5minusz = texture3D(mVolume, point.xyz + vec3( mDelta,  0.0,     -mDelta) ).x;
				float n6minusz = texture3D(mVolume, point.xyz + vec3(-mDelta,  mDelta,  -mDelta) ).x;
				float n7minusz = texture3D(mVolume, point.xyz + vec3( 0.0,	   mDelta,  -mDelta) ).x;
				float n8minusz = texture3D(mVolume, point.xyz + vec3( mDelta,  mDelta,  -mDelta) ).x;

				float dx = (n5 - n3)/2.0;
				float dy = (n7 - n1)/2.0;
				float dz = (n4plusz - n4minusz)/2.0;

				float dxplus	= n5 - n4;
				float dyplus	= n7 - n4;
				float dzplus	= n4plusz - n4;

				float dxminus	= n4 - n3;
				float dyminus	= n4 - n1;
				float dzminus	= n4 - n4minusz;

				float dxplusy	= (n8 - n6)/2.0;
				float dxminusy	= (n2 - n0)/2.0;
				float dxplusz	= (n5plusz - n3plusz)/2.0;
				float dxminusz	= (n5minusz - n3minusz)/2.0;

				float dyplusx	= (n8 - n2)/2.0;
				float dyminusx	= (n6 - n0)/2.0;
				float dyplusz	= (n7plusz - n1plusz)/2.0;
				float dyminusz	= (n7minusz - n1minusz)/2.0;

				float dzplusx	= (n5plusz - n5minusz)/2.0;
				float dzminusx	= (n3plusz - n3minusz)/2.0;
				float dzplusy	= (n7plusz - n7minusz)/2.0;
				float dzminusy	= (n1plusz - n1minusz)/2.0;

				float normalplus_denominatorx = sqrt(sqrt(dxplus*dxplus + ((dyplusx+dy)/2.0)*((dyplusx+dy)/2.0) + ((dzplusx+dz)/2.0)*((dzplusx+dz)/2.0)));
				float normalplus_denominatory = sqrt(sqrt(dyplus*dyplus + ((dxplusy+dx)/2.0)*((dxplusy+dx)/2.0) + ((dzplusy+dz)/2.0)*((dzplusy+dz)/2.0)));
				float normalplus_denominatorz = sqrt(sqrt(dzplus*dzplus + ((dxplusz+dx)/2.0)*((dxplusz+dx)/2.0) + ((dyplusz+dy)/2.0)*((dyplusz+dy)/2.0)));

				float normalminus_denominatorx = sqrt(sqrt(dxminus*dxminus + ((dyminusx+dy)/2.0)*((dyminusx+dy)/2.0) + ((dzminusx+dz)/2.0)*((dzminusx+dz)/2.0)));
				float normalminus_denominatory = sqrt(sqrt(dyminus*dyminus + ((dxminusy+dx)/2.0)*((dxminusy+dx)/2.0) + ((dzminusy+dz)/2.0)*((dzminusy+dz)/2.0)));
				float normalminus_denominatorz = sqrt(sqrt(dzminus*dzminus + ((dxminusz+dx)/2.0)*((dxminusz+dx)/2.0) + ((dyminusz+dy)/2.0)*((dyminusz+dy)/2.0))); 

				vec3 normalplus  = vec3(dxplus / normalplus_denominatorx, dyplus / normalplus_denominatory, dzplus / normalplus_denominatorz);
				vec3 normalminus = vec3(dxminus / normalminus_denominatorx, dyminus / normalminus_denominatory, dzminus / normalminus_denominatorz);

				vec3 divergence = vec3(normalplus.x - normalminus.x, normalplus.y - normalminus.y, normalplus.z - normalminus.z);

				float curvature = divergence.x + divergence.y + divergence.z;

				vec4 valc1d = texture2D(mTransfer1D, vec2((curvature+1.0)*0.5,0.5));

				vec3 Kd = valc1d.rgb;

				float edgefactor = clamp(0.25 * (length(gradient)) * pow((1 - dot(-view, N)),8), 0.0, 1.0);

				float diffuseLight = max(dot(mLightDir, N), 0.0);
				diffuseLight = min(diffuseLight, (1.0 - shadowcontribution));
				//diffuseLight = diffuseLight * 0.5 + 0.4;
				vec3 diffuse = Kd * lightColor * diffuseLight;

				float specularLight = pow(max(dot(H, N),0.0), n);
				specularLight = min(specularLight, (1.0 - shadowcontribution));
				if(diffuseLight <= 0.0) specularLight = 0.0;

				vec3 specular = Ks * lightColor * specularLight;

				vec3 color = ambient + (diffuse * edgefactor + specular);// * (1.0 - shadowcontribution);
				//vec3 color = vec3(1.0 - shadowcontribution,1.0 - shadowcontribution,1.0 - shadowcontribution);	
				ac = ac + (1.0-aa)*color;
				aa = 1.0;

			}
			else
			{
				float val = lookup.x;
				vec4 valc = texture2D(mTransfer, vec2(val, length(lgradient)));

				float va = valc.a;
				vec3 vc = valc.rgb * va;
			
				//FTB
				ac = ac + (1.0-aa)*vc; 
				aa = aa + (1.0-aa)*va;
			}

			if(i > maxiter)
			{
				break;
			}
			if(aa > 0.95)
			{
				break;
			}

			point += diff;
			wpoint += wdiff;
		}

		vec3 col = mix(mClearColor, ac, aa);


		//gl_FragColor = vec4(ac,aa);
		gl_FragColor = vec4(col,1.0);
	}
}